/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.edit.beans.PropertyBean;
import genj.gedcom.Property;
import genj.gedcom.PropertyName;
import genj.util.Registry;
import genj.util.swing.Action2;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.TextFieldWidget;
import genj.window.WindowManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NameBean
extends PropertyBean {
    private static final NestedBlockLayout LAYOUT = new NestedBlockLayout("<col><row><l/><v wx=\"1\"/></row><row><l/><v wx=\"1\"/><check/></row><row><l/><v wx=\"1\"/></row></col>");
    private Property[] sameLastNames;
    private ChoiceWidget cLast;
    private ChoiceWidget cFirst;
    private JCheckBox cAll;
    private TextFieldWidget tSuff;

    private String getReplaceAllMsg() {
        if (this.sameLastNames.length < 2) {
            return null;
        }
        return resources.getString("choice.global.confirm", new String[]{"" + this.sameLastNames.length, ((PropertyName)this.getProperty()).getLastName(), this.cLast.getText()});
    }

    void initialize(Registry setRegistry) {
        super.initialize(setRegistry);
        this.setLayout(LAYOUT.copy());
        this.cLast = new ChoiceWidget();
        this.cLast.addChangeListener(this.changeSupport);
        this.cLast.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                String msg = NameBean.this.getReplaceAllMsg();
                if (msg != null) {
                    NameBean.this.cAll.setVisible(true);
                    NameBean.this.cAll.setToolTipText(msg);
                }
            }
        });
        this.cLast.setIgnoreCase(true);
        this.cFirst = new ChoiceWidget();
        this.cFirst.addChangeListener(this.changeSupport);
        this.cFirst.setIgnoreCase(true);
        this.tSuff = new TextFieldWidget("", 10);
        this.tSuff.addChangeListener(this.changeSupport);
        this.cAll = new JCheckBox();
        this.cAll.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.cAll.setVisible(false);
        this.cAll.setRequestFocusEnabled(false);
        this.add(new JLabel(PropertyName.getLabelForFirstName()));
        this.add(this.cFirst);
        this.add(new JLabel(PropertyName.getLabelForLastName()));
        this.add(this.cLast);
        this.add(this.cAll);
        this.add(new JLabel(PropertyName.getLabelForSuffix()));
        this.add(this.tSuff);
        this.cAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String msg = NameBean.this.getReplaceAllMsg();
                WindowManager wm = WindowManager.getInstance(NameBean.this);
                if (wm != null && msg != null && NameBean.this.cAll.isSelected()) {
                    int rc = wm.openDialog(null, PropertyBean.resources.getString("choice.global.enable"), 3, msg, Action2.yesNo(), (Component)NameBean.this);
                    NameBean.this.cAll.setSelected(rc == 0);
                }
            }
        });
        this.defaultFocus = this.cFirst;
    }

    public void commit(Property property) {
        super.commit(property);
        String first = this.cFirst.getText().trim();
        String last = this.cLast.getText().trim();
        String suff = this.tSuff.getText().trim();
        PropertyName p = (PropertyName)property;
        p.setName(first, last, suff, this.cAll.isSelected());
    }

    boolean accepts(Property prop) {
        return prop instanceof PropertyName;
    }

    public void setPropertyImpl(Property prop) {
        PropertyName name = (PropertyName)prop;
        if (name == null) {
            return;
        }
        this.sameLastNames = name.getSameLastNames();
        this.cLast.setValues(name.getLastNames(true));
        this.cLast.setText(name.getLastName());
        this.cFirst.setValues(name.getFirstNames(true));
        this.cFirst.setText(name.getFirstName());
        this.tSuff.setText(name.getSuffix());
        this.cAll.setVisible(false);
        this.cAll.setSelected(false);
    }
}

