/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.edit.beans.PropertyBean;
import genj.gedcom.Property;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyFile;
import genj.util.Origin;
import genj.util.Registry;
import genj.util.swing.Action2;
import genj.util.swing.FileChooserWidget;
import genj.util.swing.ImageWidget;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilePermission;
import java.util.List;
import javax.swing.JCheckBox;

public class FileBean
extends PropertyBean {
    private ImageWidget preview = new ImageWidget();
    private JCheckBox updateMeta = new JCheckBox(resources.getString("file.update"), true);
    private FileChooserWidget chooser = new FileChooserWidget();
    private ActionListener doPreview = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            FileBean.this.registry.put("bean.file.dir", FileBean.this.chooser.getDirectory());
            File file = FileBean.this.getProperty().getGedcom().getOrigin().getFile(FileBean.this.chooser.getFile().toString());
            if (file == null) {
                FileBean.this.preview.setSource(null);
                return;
            }
            FileBean.this.preview.setSource(new ImageWidget.FileSource(file));
            String relative = FileBean.this.getProperty().getGedcom().getOrigin().calcRelativeLocation(file.getAbsolutePath());
            if (relative != null) {
                FileBean.this.chooser.setFile(relative);
            }
        }
    };

    void initialize(Registry setRegistry) {
        super.initialize(setRegistry);
        this.setLayout(new BorderLayout());
        this.chooser.setAccessory(this.updateMeta);
        this.chooser.addChangeListener(this.changeSupport);
        this.chooser.addActionListener(this.doPreview);
        this.add((Component)this.chooser, "North");
        this.add((Component)this.preview, "Center");
        this.setPreferredSize(new Dimension(128, 128));
        new DropTarget(this, new DropHandler());
    }

    boolean accepts(Property prop) {
        return prop instanceof PropertyFile || prop instanceof PropertyBlob;
    }

    public void setPropertyImpl(Property property) {
        String dir;
        if (property == null) {
            return;
        }
        Origin origin = property.getGedcom().getOrigin();
        String string = dir = origin.getFile() != null ? origin.getFile().getParent() : null;
        if (dir != null) {
            try {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission(new FilePermission(dir, "read"));
                }
                this.chooser.setDirectory(this.registry.get("bean.file.dir", dir));
                this.chooser.setVisible(true);
                this.defaultFocus = this.chooser;
            }
            catch (SecurityException se) {
                this.chooser.setVisible(false);
                this.defaultFocus = null;
            }
        }
        if (property instanceof PropertyFile) {
            PropertyFile file = (PropertyFile)property;
            this.chooser.setTemplate(false);
            this.chooser.setFile(file.getValue());
            if (property.getValue().length() > 0) {
                this.preview.setSource(new ImageWidget.RelativeSource(property.getGedcom().getOrigin(), property.getValue()));
            } else {
                this.preview.setSource(null);
            }
        }
        if (property instanceof PropertyBlob) {
            PropertyBlob blob = (PropertyBlob)property;
            this.chooser.setFile(blob.getValue());
            this.chooser.setTemplate(true);
            this.preview.setSource(new ImageWidget.ByteArraySource(((PropertyBlob)property).getBlobData()));
        }
        this.preview.setZoom((float)this.registry.get("file.zoom", 0) / 100.0f);
    }

    public void commit(Property property) {
        File file;
        super.commit(property);
        String value = this.chooser.getFile().toString();
        if (property instanceof PropertyFile) {
            ((PropertyFile)property).setValue(value, this.updateMeta.isSelected());
        }
        if (property instanceof PropertyBlob) {
            ((PropertyBlob)property).load(value, this.updateMeta.isSelected());
        }
        this.preview.setSource((file = this.getProperty().getGedcom().getOrigin().getFile(value)) != null ? new ImageWidget.FileSource(file) : null);
    }

    public ViewContext getContext() {
        ViewContext result = super.getContext();
        if (result != null) {
            result.addAction(new ActionZoom(10));
            result.addAction(new ActionZoom(25));
            result.addAction(new ActionZoom(50));
            result.addAction(new ActionZoom(100));
            result.addAction(new ActionZoom(150));
            result.addAction(new ActionZoom(200));
            result.addAction(new ActionZoom(0));
        }
        return result;
    }

    private class DropHandler
    extends DropTargetAdapter {
        private DropHandler() {
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrag(dtde.getDropAction());
            } else {
                dtde.rejectDrag();
            }
        }

        public void drop(DropTargetDropEvent dtde) {
            try {
                dtde.acceptDrop(dtde.getDropAction());
                List files = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                File file = (File)files.get(0);
                FileBean.this.chooser.setFile(file);
                FileBean.this.preview.setSource(new ImageWidget.FileSource(file));
                dtde.dropComplete(true);
            }
            catch (Throwable t) {
                dtde.dropComplete(false);
            }
        }
    }

    private class ActionZoom
    extends Action2 {
        private int zoom;

        protected ActionZoom(int zOOm) {
            this.zoom = zOOm;
            this.setText(this.zoom == 0 ? PropertyBean.resources.getString("file.zoom.fit") : this.zoom + "%");
            this.setEnabled(this.zoom != (int)(FileBean.this.preview.getZoom() * 100.0));
        }

        protected void execute() {
            FileBean.this.preview.setZoom((float)this.zoom / 100.0f);
            FileBean.this.registry.put("file.zoom", this.zoom);
        }
    }
}

