/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.common.AbstractPropertyTableModel;
import genj.common.PropertyTableWidget;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.util.Registry;
import java.awt.BorderLayout;
import java.awt.Dimension;

public class FamiliesBean
extends PropertyBean {
    private static final TagPath PATH_FAM = new TagPath("FAM");
    private static final TagPath PATH_HUSB = new TagPath("FAM:HUSB:*:..");
    private static final TagPath PATH_WIFE = new TagPath("FAM:WIFE:*:..");
    private static final TagPath PATH_HUSB_NAME = new TagPath("FAM:HUSB:*:..:NAME");
    private static final TagPath PATH_WIFE_NAME = new TagPath("FAM:WIFE:*:..:NAME");
    private static final TagPath PATH_MARR_DATE = Fam.PATH_FAMMARRDATE;
    private static final TagPath PATH_MARR_PLAC = Fam.PATH_FAMMARRPLAC;
    private PropertyTableWidget table;
    private static final String COLS_KEY = "bean.families.cols";

    void initialize(Registry setRegistry) {
        super.initialize(setRegistry);
        this.table = new PropertyTableWidget();
        this.table.setPreferredSize(new Dimension(64, 64));
        this.setLayout(new BorderLayout());
        this.add("Center", this.table);
    }

    public void addNotify() {
        super.addNotify();
        this.table.setColumnLayout(this.registry.get(COLS_KEY, (String)null));
    }

    public void removeNotify() {
        this.registry.put(COLS_KEY, this.table.getColumnLayout());
        super.removeNotify();
    }

    boolean accepts(Property prop) {
        return prop instanceof Indi;
    }

    public void setPropertyImpl(Property prop) {
        Indi indi = (Indi)prop;
        this.table.setModel(indi != null ? new Families(indi) : null);
    }

    public Property getProperty() {
        return null;
    }

    private class Families
    extends AbstractPropertyTableModel {
        private Indi indi;
        private Fam[] fams;

        private Families(Indi indi) {
            this.indi = indi;
            this.fams = indi.getFamiliesWhereSpouse();
        }

        public Gedcom getGedcom() {
            return this.indi.getGedcom();
        }

        public int getNumCols() {
            return 5;
        }

        public int getNumRows() {
            return this.fams.length;
        }

        public TagPath getPath(int col) {
            switch (col) {
                default: {
                    return PATH_FAM;
                }
                case 1: {
                    return this.indi.getSex() == 2 ? PATH_HUSB : PATH_WIFE;
                }
                case 2: {
                    return this.indi.getSex() == 2 ? PATH_HUSB_NAME : PATH_WIFE_NAME;
                }
                case 3: {
                    return PATH_MARR_DATE;
                }
                case 4: 
            }
            return PATH_MARR_PLAC;
        }

        public Property getProperty(int row) {
            return this.fams[row];
        }
    }
}

