/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.edit.beans.PropertyBean;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.util.Registry;
import genj.util.swing.NestedBlockLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EventBean
extends PropertyBean {
    private static final NestedBlockLayout LAYOUT = new NestedBlockLayout("<col><row><at/><age wx=\"1\"/></row><row><known/></row></col>");
    private JCheckBox cKnown;
    private JLabel lAgeAt;
    private JTextField tAge;

    void initialize(Registry setRegistry) {
        super.initialize(setRegistry);
        this.setLayout(LAYOUT.copy());
        this.lAgeAt = new JLabel();
        this.tAge = new JTextField("", 16);
        this.tAge.setEditable(false);
        this.tAge.setFocusable(false);
        this.cKnown = new JCheckBox(resources.getString("even.known"));
        this.cKnown.addActionListener(this.changeSupport);
        this.add(this.lAgeAt);
        this.add(this.tAge);
        this.add(this.cKnown);
    }

    public void commit(Property property) {
        super.commit(property);
        if (this.cKnown.isVisible()) {
            ((PropertyEvent)property).setKnownToHaveHappened(this.cKnown.isSelected());
        }
    }

    public boolean isEditable() {
        return this.cKnown.isVisible();
    }

    boolean accepts(Property prop) {
        return prop instanceof PropertyEvent;
    }

    public void setPropertyImpl(Property prop) {
        if (prop == null) {
            return;
        }
        PropertyEvent event = (PropertyEvent)prop;
        PropertyDate date = event.getDate(true);
        if (event.getEntity() instanceof Indi) {
            Indi indi = (Indi)event.getEntity();
            String ageat = "even.age";
            String age = "";
            if ("BIRT".equals(event.getTag())) {
                Delta delta;
                ageat = "even.age.today";
                if (date != null && (delta = Delta.get(date.getStart(), PointInTime.getNow())) != null) {
                    age = delta.toString();
                }
            } else {
                age = date != null ? indi.getAgeString(date.getStart()) : resources.getString("even.age.?");
            }
            this.lAgeAt.setText(resources.getString(ageat));
            this.tAge.setText(age);
            this.lAgeAt.setVisible(true);
            this.tAge.setVisible(true);
        } else {
            this.lAgeAt.setVisible(false);
            this.tAge.setVisible(false);
        }
        Boolean known = null;
        if (!"EVEN".equals(event.getTag())) {
            known = event.isKnownToHaveHappened();
        }
        if (known != null) {
            this.cKnown.setSelected(known);
            this.cKnown.setVisible(true);
            this.defaultFocus = this.cKnown;
        } else {
            this.cKnown.setVisible(false);
            this.defaultFocus = null;
        }
    }
}

