/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.edit.beans.PropertyBean;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.util.Registry;
import genj.util.swing.Action2;
import genj.util.swing.DateWidget;
import genj.util.swing.ImageIcon;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.PopupWidget;
import genj.util.swing.TextFieldWidget;
import java.util.ArrayList;
import javax.swing.JLabel;

public class DateBean
extends PropertyBean {
    private static final NestedBlockLayout LAYOUT = new NestedBlockLayout("<col><row><a/><b/></row><row><c/><d/></row><row><e wx=\"0.1\"/></row></col>");
    private static final ImageIcon PIT = new ImageIcon(PropertyBean.class, "/genj/gedcom/images/Time.gif");
    private PropertyDate.Format format;
    private DateWidget date1;
    private DateWidget date2;
    private PopupWidget choose;
    private JLabel label2;
    private TextFieldWidget phrase;

    void initialize(Registry setRegistry) {
        super.initialize(setRegistry);
        this.setLayout(LAYOUT.copy());
        ArrayList<ChangeFormat> actions = new ArrayList<ChangeFormat>(10);
        for (int i = 0; i < PropertyDate.FORMATS.length; ++i) {
            actions.add(new ChangeFormat(PropertyDate.FORMATS[i]));
        }
        this.choose = new PopupWidget(null, null, actions);
        this.add(this.choose);
        this.date1 = new DateWidget();
        this.date1.addChangeListener(this.changeSupport);
        this.add(this.date1);
        this.label2 = new JLabel();
        this.add(this.label2);
        this.date2 = new DateWidget();
        this.date2.addChangeListener(this.changeSupport);
        this.add(this.date2);
        this.phrase = new TextFieldWidget();
        this.phrase.addChangeListener(this.changeSupport);
        this.add(this.phrase);
        this.defaultFocus = this.date1;
    }

    public void commit(Property property) {
        super.commit(property);
        PropertyDate p = (PropertyDate)property;
        p.setValue(this.format, this.date1.getValue(), this.date2.getValue(), this.phrase.getText());
    }

    private void setFormat(PropertyDate.Format set) {
        if (this.format == set) {
            return;
        }
        this.changeSupport.fireChangeEvent();
        this.format = set;
        this.choose.setToolTipText(this.format.getName());
        String prefix1 = this.format.getPrefix1Name();
        this.choose.setIcon(prefix1 == null ? PIT : null);
        this.choose.setText(prefix1 == null ? "" : prefix1);
        if (this.format.isRange()) {
            this.date2.setVisible(true);
            this.label2.setVisible(true);
            this.label2.setText(this.format.getPrefix2Name());
        } else {
            this.date2.setVisible(false);
            this.label2.setVisible(false);
        }
        this.phrase.setVisible(this.format.usesPhrase());
        this.revalidate();
        this.repaint();
    }

    boolean accepts(Property prop) {
        return prop instanceof PropertyDate;
    }

    public void setPropertyImpl(Property prop) {
        if (prop == null) {
            return;
        }
        PropertyDate date = (PropertyDate)prop;
        this.date1.setValue(date.getStart());
        this.date2.setValue(date.getEnd());
        this.phrase.setText(date.getPhrase());
        this.setFormat(date.getFormat());
    }

    private class ChangeFormat
    extends Action2 {
        private PropertyDate.Format formatToSet;

        private ChangeFormat(PropertyDate.Format set) {
            this.formatToSet = set;
            super.setText(set.getName());
        }

        protected void execute() {
            DateBean.this.setFormat(this.formatToSet);
            DateBean.this.date1.requestFocusInWindow();
        }
    }
}

