/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.edit.beans.PropertyBean;
import genj.gedcom.Property;
import genj.gedcom.PropertyChoiceValue;
import genj.util.GridBagHelper;
import genj.util.Registry;
import genj.util.swing.Action2;
import genj.util.swing.ChoiceWidget;
import genj.window.WindowManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ChoiceBean
extends PropertyBean {
    private ChoiceWidget choices;
    private JCheckBox global;
    private Property[] sameChoices = new Property[0];

    private String getGlobalReplaceMsg() {
        if (this.sameChoices.length < 2) {
            return null;
        }
        return resources.getString("choice.global.confirm", new String[]{"" + this.sameChoices.length, this.sameChoices[0].getDisplayValue(), this.choices.getText()});
    }

    void initialize(Registry setRegistry) {
        super.initialize(setRegistry);
        this.choices = new ChoiceWidget();
        this.choices.addChangeListener(this.changeSupport);
        this.choices.setIgnoreCase(true);
        this.global = new JCheckBox();
        this.global.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.global.setVisible(false);
        this.global.setRequestFocusEnabled(false);
        this.choices.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                String msg = ChoiceBean.this.getGlobalReplaceMsg();
                if (msg != null) {
                    ChoiceBean.this.global.setVisible(true);
                    ChoiceBean.this.global.setToolTipText(msg);
                }
            }
        });
        this.global.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String msg = ChoiceBean.this.getGlobalReplaceMsg();
                WindowManager wm = WindowManager.getInstance(ChoiceBean.this);
                if (wm != null && msg != null && ChoiceBean.this.global.isSelected()) {
                    int rc = wm.openDialog(null, PropertyBean.resources.getString("choice.global.enable"), 3, msg, Action2.yesNo(), (Component)ChoiceBean.this);
                    ChoiceBean.this.global.setSelected(rc == 0);
                }
            }
        });
        GridBagHelper layout = new GridBagHelper(this);
        layout.add(this.choices, 0, 0, 1, 1, 17);
        layout.add(this.global, 1, 0);
        layout.addFiller(0, 1);
        this.defaultFocus = this.choices;
    }

    public void commit(Property property) {
        super.commit(property);
        PropertyChoiceValue choice = (PropertyChoiceValue)property;
        String text = this.choices.getText();
        choice.setValue(text, this.global.isSelected());
        this.choices.setValues(((PropertyChoiceValue)property).getChoices(true));
        this.choices.setText(text);
        this.global.setSelected(false);
        this.global.setVisible(false);
    }

    boolean accepts(Property prop) {
        return prop instanceof PropertyChoiceValue;
    }

    public void setPropertyImpl(Property prop) {
        if (prop == null) {
            return;
        }
        PropertyChoiceValue choice = (PropertyChoiceValue)prop;
        this.choices.setValues(choice.getChoices(true));
        this.choices.setText(choice.isSecret() ? "" : choice.getDisplayValue());
        this.global.setSelected(false);
        this.global.setVisible(false);
        this.sameChoices = choice.getSameChoices();
    }
}

