/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.edit.beans.AgeBean;
import genj.edit.beans.ChoiceBean;
import genj.edit.beans.DateBean;
import genj.edit.beans.EntityBean;
import genj.edit.beans.EventBean;
import genj.edit.beans.FileBean;
import genj.edit.beans.MLEBean;
import genj.edit.beans.NameBean;
import genj.edit.beans.PlaceBean;
import genj.edit.beans.PropertyBean;
import genj.edit.beans.SexBean;
import genj.edit.beans.SimpleValueBean;
import genj.edit.beans.XRefBean;
import genj.gedcom.Property;
import genj.util.Registry;
import genj.view.ViewManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BeanFactory {
    private Logger LOG = Logger.getLogger("genj.edit");
    private static final Class[] beanTypes = new Class[]{EntityBean.class, PlaceBean.class, AgeBean.class, ChoiceBean.class, DateBean.class, EventBean.class, FileBean.class, MLEBean.class, NameBean.class, SexBean.class, XRefBean.class, SimpleValueBean.class};
    private Registry registry;
    private static final Map property2cached = new HashMap();
    private static Map proxy2type = new HashMap();

    public BeanFactory(ViewManager viewManager, Registry registry) {
        this.registry = registry;
    }

    public PropertyBean get(String type, Property prop) {
        PropertyBean bean = this.getBeanOfType(type);
        bean.setProperty(prop);
        return bean;
    }

    public PropertyBean get(Property prop) {
        PropertyBean bean = this.getBeanFor(prop);
        bean.setProperty(prop);
        return bean;
    }

    private synchronized PropertyBean getBeanOfType(String type) {
        try {
            PropertyBean bean = (PropertyBean)Class.forName(type).newInstance();
            bean.initialize(this.registry);
            return bean;
        }
        catch (Throwable t) {
            this.LOG.log(Level.WARNING, "can't instantiate bean of type " + type, t);
            SimpleValueBean bean = new SimpleValueBean();
            ((PropertyBean)bean).initialize(this.registry);
            return bean;
        }
    }

    private synchronized PropertyBean getBeanFor(Property prop) {
        List cached = (List)property2cached.get(prop.getClass());
        if (cached != null && !cached.isEmpty()) {
            return (PropertyBean)cached.remove(cached.size() - 1);
        }
        try {
            for (int i = 0; i < beanTypes.length; ++i) {
                PropertyBean bean = (PropertyBean)beanTypes[i].newInstance();
                if (!bean.accepts(prop)) continue;
                bean.initialize(this.registry);
                return bean;
            }
        }
        catch (Throwable t) {
            this.LOG.log(Level.WARNING, "can't instantiate/init bean for " + prop.getClass().getName(), t);
        }
        return new SimpleValueBean();
    }

    public synchronized void recycle(PropertyBean bean) {
        Property property = bean.getProperty();
        if (property == null) {
            return;
        }
        ArrayList<PropertyBean> cached = (ArrayList<PropertyBean>)property2cached.get(property.getClass());
        if (cached == null) {
            cached = new ArrayList<PropertyBean>();
            property2cached.put(property.getClass(), cached);
        }
        cached.add(bean);
    }
}

