/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.edit.beans.PropertyBean;
import genj.gedcom.Property;
import genj.gedcom.PropertyAge;
import genj.gedcom.time.Delta;
import genj.util.Registry;
import genj.util.swing.Action2;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.NestedBlockLayout;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JLabel;

public class AgeBean
extends PropertyBean {
    private static final String TEMPLATE = "99y 9m 9d";
    private ChoiceWidget choice;
    private ActionUpdate update;
    private String newAge;

    public void commit(Property property) {
        super.commit(property);
        property.setValue(this.choice.getText());
    }

    void initialize(Registry setRegistry) {
        super.initialize(setRegistry);
        this.choice = new ChoiceWidget(Arrays.asList(PropertyAge.PHRASES));
        this.choice.addChangeListener(this.changeSupport);
        this.setLayout(new NestedBlockLayout("<col><row><value/><template/></row><row><action/></row></col>"));
        this.add(this.choice);
        this.add(new JLabel(TEMPLATE));
        this.update = new ActionUpdate();
        this.add(new JButton(this.update));
    }

    boolean accepts(Property prop) {
        return prop instanceof PropertyAge;
    }

    public void setPropertyImpl(Property prop) {
        PropertyAge age = (PropertyAge)prop;
        if (age == null) {
            return;
        }
        this.choice.setText(age.getValue());
        Delta delta = Delta.get(age.getEarlier(), age.getLater());
        this.newAge = delta == null ? null : delta.getValue();
        this.update.setEnabled(this.newAge != null);
    }

    private class ActionUpdate
    extends Action2 {
        private ActionUpdate() {
            this.setImage(PropertyAge.IMG);
            this.setTip(PropertyBean.resources.getString("age.tip"));
        }

        protected void execute() {
            AgeBean.this.choice.setText(AgeBean.this.newAge);
        }
    }
}

