/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.actions.AbstractChange;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.util.swing.Action2;
import genj.view.ViewManager;
import genj.window.WindowManager;
import java.util.Collection;
import java.util.Iterator;

public class TogglePrivate
extends AbstractChange {
    private Collection properties;
    private boolean makePrivate;

    public TogglePrivate(Gedcom gedcom, Collection properties, ViewManager mgr) {
        super(gedcom, MetaProperty.IMG_PRIVATE, "", mgr);
        this.gedcom = gedcom;
        this.properties = properties;
        this.makePrivate = true;
        Iterator ps = properties.iterator();
        while (ps.hasNext()) {
            Property p = (Property)ps.next();
            if (!p.isPrivate()) continue;
            this.makePrivate = false;
        }
        this.setText(resources.getString(this.makePrivate ? "private" : "public"));
    }

    public void perform(Gedcom gedcom) throws GedcomException {
        String pwd = gedcom.getPassword();
        if (pwd == "PASSWORD_UNKNOWN") {
            WindowManager.getInstance(this.getTarget()).openDialog(null, this.getText(), 2, "This Gedcom file contains encrypted information that has to be decrypted before changing private/public status of other information", Action2.okOnly(), this.getTarget());
            return;
        }
        if (pwd == "PASSWORD_NOT_SET" && (pwd = WindowManager.getInstance(this.getTarget()).openDialog(null, this.getText(), 3, AbstractChange.resources.getString("password", gedcom.getName()), "", this.getTarget())) == null) {
            return;
        }
        int recursive = WindowManager.getInstance(this.getTarget()).openDialog(null, this.getText(), 3, AbstractChange.resources.getString("recursive"), Action2.okCancel(), this.getTarget());
        gedcom.setPassword(pwd);
        Iterator ps = this.properties.iterator();
        while (ps.hasNext()) {
            Property p = (Property)ps.next();
            p.setPrivate(this.makePrivate, recursive == 0);
        }
    }
}

