/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.actions.CreateRelationship;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.view.ViewManager;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CreateXReference
extends CreateRelationship {
    private Property source;
    private String sourceTag;

    public CreateXReference(Property source, String sourceTag, ViewManager mgr) {
        super(CreateXReference.getName(source, sourceTag), source.getGedcom(), CreateXReference.getTargetType(source, sourceTag), mgr);
        this.source = source;
        this.sourceTag = sourceTag;
    }

    private static String getTargetType(Property source, String sourceTag) {
        try {
            PropertyXRef sample = (PropertyXRef)source.getMetaProperty().getNested(sourceTag, false).create("@@");
            return sample.getTargetType();
        }
        catch (GedcomException e) {
            Logger.getLogger("genj.edit.actions").log(Level.SEVERE, "couldn't determine target type", e);
            throw new RuntimeException("Couldn't determine target type for source tag " + sourceTag);
        }
    }

    private static String getName(Property source, String sourceTag) {
        String targetType = CreateXReference.getTargetType(source, sourceTag);
        if (targetType.equals(sourceTag)) {
            return Gedcom.getName(targetType);
        }
        return Gedcom.getName(targetType) + " (" + Gedcom.getName(sourceTag) + ")";
    }

    public String getDescription() {
        return resources.getString("create.xref.desc", new String[]{Gedcom.getName(this.targetType), this.source.getEntity().toString()});
    }

    protected Property change(Entity target, boolean targetIsNew) throws GedcomException {
        PropertyXRef xref = (PropertyXRef)this.source.addProperty(this.sourceTag, '@' + target.getId() + '@');
        try {
            xref.link();
            xref.addDefaultProperties();
        }
        catch (GedcomException e) {
            this.source.delProperty(xref);
            throw e;
        }
        return targetIsNew ? xref.getTarget() : xref;
    }
}

