/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.actions.CreateRelationship;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.view.ViewManager;

public class CreateSpouse
extends CreateRelationship {
    private Indi spouse;

    public CreateSpouse(Indi spouse, ViewManager mgr) {
        super(resources.getString("create.spouse"), spouse.getGedcom(), "INDI", mgr);
        this.spouse = spouse;
    }

    public String getWarning(Entity target) {
        int n = this.spouse.getNoOfFams();
        if (n > 0) {
            return resources.getString("create.spouse.warning", new String[]{this.spouse.toString(), "" + n});
        }
        return null;
    }

    public String getDescription() {
        return resources.getString("create.spouse.of", this.spouse);
    }

    protected Property change(Entity target, boolean targetIsNew) throws GedcomException {
        Fam[] fams = this.spouse.getFamiliesWhereSpouse();
        Fam fam = null;
        if (fams.length > 0) {
            fam = fams[0];
        }
        if (fam == null || fam.getNoOfSpouses() >= 2) {
            fam = (Fam)this.spouse.getGedcom().createEntity("FAM").addDefaultProperties();
            fam.setSpouse(this.spouse);
        }
        return fam.setSpouse((Indi)target).getTarget();
    }
}

