/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.actions.CreateRelationship;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Options;
import genj.gedcom.Property;
import genj.gedcom.PropertySex;
import genj.gedcom.PropertyXRef;
import genj.view.ViewManager;

public class CreateSibling
extends CreateRelationship {
    private Indi sibling;
    private boolean isBrotherNotSister;

    public CreateSibling(Indi sibling, ViewManager mgr, boolean isBrotherNotSister) {
        super(CreateSibling.calcName(isBrotherNotSister), sibling.getGedcom(), "INDI", mgr);
        this.sibling = sibling;
        this.isBrotherNotSister = isBrotherNotSister;
    }

    private static String calcName(boolean isBrotherNotSister) {
        String sibling = resources.getString("create.sibling", false);
        if (sibling == null) {
            return resources.getString(isBrotherNotSister ? "create.brother" : "create.sister");
        }
        return sibling + " (" + (isBrotherNotSister ? PropertySex.TXT_MALE : PropertySex.TXT_FEMALE) + ")";
    }

    public String getDescription() {
        return resources.getString("create.sibling.of", this.sibling);
    }

    protected Property change(Entity target, boolean targetIsNew) throws GedcomException {
        PropertyXRef CHIL;
        Fam[] fams = this.sibling.getFamiliesWhereChild();
        if (fams.length > 0) {
            CHIL = fams[0].addChild((Indi)target);
        } else {
            fams = ((Indi)target).getFamiliesWhereChild();
            if (fams.length > 0) {
                CHIL = fams[0].addChild(this.sibling);
            } else {
                Gedcom ged = this.sibling.getGedcom();
                Fam fam = (Fam)ged.createEntity("FAM");
                try {
                    CHIL = fam.addChild((Indi)target);
                }
                catch (GedcomException e) {
                    ged.deleteEntity(fam);
                    throw e;
                }
                Indi husband = (Indi)ged.createEntity("INDI").addDefaultProperties();
                Indi wife = (Indi)ged.createEntity("INDI").addDefaultProperties();
                husband.setName("", this.sibling.getLastName());
                if (Options.getInstance().setWifeLastname) {
                    wife.setName("", this.sibling.getLastName());
                }
                fam.setHusband(husband);
                fam.setWife(wife);
                fam.addChild(this.sibling);
            }
        }
        if (targetIsNew) {
            Indi indi = (Indi)target;
            indi.setName("", this.sibling.getLastName());
            indi.setSex(this.isBrotherNotSister ? 1 : 2);
        }
        return CHIL.getTarget();
    }
}

