/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.common.SelectEntityWidget;
import genj.edit.actions.AbstractChange;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.util.WordBuffer;
import genj.util.swing.NestedBlockLayout;
import genj.view.ContextSelectionEvent;
import genj.view.ViewContext;
import genj.view.ViewManager;
import genj.window.WindowManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class CreateRelationship
extends AbstractChange {
    private Entity existing;
    private JCheckBox checkID;
    private JTextField requestID;
    protected String targetType;

    public CreateRelationship(String name, Gedcom gedcom, String targetType, ViewManager manager) {
        super(gedcom, Gedcom.getEntityImage(targetType).getOverLayed(imgNew), resources.getString("link", name), manager);
        this.targetType = targetType;
    }

    protected String getConfirmMessage() {
        WordBuffer result = new WordBuffer("\n");
        result.append(this.existing == null ? resources.getString("confirm.new", new Object[]{Gedcom.getName(this.targetType, false), this.gedcom}) : resources.getString("confirm.use", new Object[]{this.existing.getId(), this.gedcom}));
        result.append(resources.getString("confirm.new.related", this.getDescription()));
        String warning = this.getWarning(this.existing);
        if (warning != null) {
            result.append("**Note**: " + warning);
        }
        return result.toString();
    }

    public abstract String getDescription();

    public String getWarning(Entity target) {
        return null;
    }

    protected JPanel getDialogContent() {
        JPanel result = new JPanel(new NestedBlockLayout("<col><row><select wx=\"1\"/></row><row><text wx=\"1\" wy=\"1\"/></row><row><check/><text/></row></col>"));
        final SelectEntityWidget select = new SelectEntityWidget(this.gedcom, this.targetType, resources.getString("select.new"));
        this.requestID = new JTextField(this.gedcom.getNextAvailableID(this.targetType), 8);
        this.requestID.setEditable(false);
        this.checkID = new JCheckBox(resources.getString("assign_id"));
        this.checkID.getModel().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                CreateRelationship.this.requestID.setEditable(CreateRelationship.this.checkID.isSelected());
                if (CreateRelationship.this.checkID.isSelected()) {
                    CreateRelationship.this.requestID.requestFocusInWindow();
                }
            }
        });
        result.add(select);
        result.add(this.getConfirmComponent());
        result.add(this.checkID);
        result.add(this.requestID);
        select.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateRelationship.this.existing = select.getSelection();
                if (CreateRelationship.this.existing != null) {
                    CreateRelationship.this.checkID.setSelected(false);
                }
                CreateRelationship.this.checkID.setEnabled(CreateRelationship.this.existing == null);
                CreateRelationship.this.refresh();
            }
        });
        if (!this.targetType.equals("INDI") && !this.targetType.equals("FAM")) {
            select.setSelection(this.gedcom.getEntity(ViewManager.getRegistry(this.gedcom).get("select." + this.targetType, (String)null)));
        }
        return result;
    }

    public void perform(Gedcom gedcom) throws GedcomException {
        Entity change;
        if (this.existing != null) {
            change = this.existing;
        } else {
            String id = null;
            if (this.requestID.isEditable() && gedcom.getEntity(this.targetType, id = this.requestID.getText()) != null) {
                throw new GedcomException(resources.getString("assign_id_error", id));
            }
            change = gedcom.createEntity(this.targetType, id);
            change.addDefaultProperties();
        }
        Property focus = this.change(change, change != this.existing);
        ViewManager.getRegistry(gedcom).put("select." + this.targetType, change.getId());
        WindowManager.broadcast(new ContextSelectionEvent(new ViewContext(focus), this.getTarget(), false));
    }

    protected abstract Property change(Entity var1, boolean var2) throws GedcomException;
}

