/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.actions.CreateRelationship;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Options;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyXRef;
import genj.view.ViewManager;

public class CreateParent
extends CreateRelationship {
    private Indi child;
    private Fam family;

    public CreateParent(Fam family, ViewManager mgr) {
        super(resources.getString("create.parent"), family.getGedcom(), "INDI", mgr);
        if (family.getNoOfSpouses() >= 2) {
            throw new IllegalArgumentException("can't create additional parent in family with husband and wife");
        }
        this.family = family;
        this.child = null;
    }

    public CreateParent(Indi child, ViewManager mgr) {
        super(resources.getString("create.parent"), child.getGedcom(), "INDI", mgr);
        this.child = child;
        Fam[] fams = child.getFamiliesWhereChild();
        for (int f = 0; f < fams.length; ++f) {
            if (fams[f].getNoOfSpouses() >= 2) continue;
            this.family = fams[f];
            break;
        }
    }

    public String getDescription() {
        if (this.child != null) {
            return resources.getString("create.parent.of", this.child);
        }
        return resources.getString("create.parent.in", this.family);
    }

    public String getWarning(Entity indi) {
        Fam fam;
        if (this.child != null && this.family == null && (fam = this.child.getFamilyWhereBiologicalChild()) != null) {
            return PropertyChild.getLabelChildAlreadyinFamily(this.child, fam);
        }
        return null;
    }

    protected Property change(Entity parent, boolean parentIsNew) throws GedcomException {
        String lastname;
        PropertyXRef FAMS;
        Gedcom ged = parent.getGedcom();
        if (this.family != null) {
            FAMS = this.family.setSpouse((Indi)parent).getTarget();
            Indi other = this.family.getOtherSpouse((Indi)parent);
            lastname = other != null ? other.getLastName() : "";
        } else {
            lastname = this.child.getLastName();
            this.family = (Fam)ged.createEntity("FAM");
            this.family.addChild(this.child);
            this.family.addDefaultProperties();
            FAMS = this.family.setSpouse((Indi)parent).getTarget();
            if (this.family.getNoOfSpouses() < 2) {
                Indi spouse = (Indi)ged.createEntity("INDI");
                spouse.addDefaultProperties();
                this.family.setSpouse(spouse);
                if (Options.getInstance().setWifeLastname || spouse.getSex() == 1) {
                    spouse.setName("", lastname);
                }
            }
        }
        if (parentIsNew && (((Indi)parent).getSex() == 1 || Options.getInstance().setWifeLastname)) {
            ((Indi)parent).setName("", lastname);
        }
        return FAMS;
    }
}

