/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.actions.AbstractChange;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.util.swing.NestedBlockLayout;
import genj.view.ContextSelectionEvent;
import genj.view.ViewContext;
import genj.view.ViewManager;
import genj.window.WindowManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CreateEntity
extends AbstractChange {
    private String etag;
    private JTextField requestID;

    public CreateEntity(Gedcom ged, String tag, ViewManager manager) {
        super(ged, Gedcom.getEntityImage(tag).getOverLayed(imgNew), resources.getString("new", Gedcom.getName(tag, false)), manager);
        this.etag = tag;
    }

    protected JPanel getDialogContent() {
        JPanel result = new JPanel(new NestedBlockLayout("<col><row><text wx=\"1\" wy=\"1\"/></row><row><check/><text/></row></col>"));
        this.requestID = new JTextField(this.gedcom.getNextAvailableID(this.etag), 8);
        this.requestID.setEditable(false);
        final JCheckBox check = new JCheckBox(resources.getString("assign_id"));
        check.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateEntity.this.requestID.setEditable(check.isSelected());
                if (check.isSelected()) {
                    CreateEntity.this.requestID.requestFocusInWindow();
                }
            }
        });
        result.add(this.getConfirmComponent());
        result.add(check);
        result.add(this.requestID);
        return result;
    }

    protected String getConfirmMessage() {
        String about = resources.getString("confirm.new", new Object[]{Gedcom.getName(this.etag, false), this.gedcom});
        String detail = resources.getString("confirm.new.unrelated");
        return about + '\n' + detail;
    }

    public void perform(Gedcom gedcom) throws GedcomException {
        String id = null;
        if (this.requestID.isEditable() && gedcom.getEntity(this.etag, id = this.requestID.getText()) != null) {
            throw new GedcomException(resources.getString("assign_id_error", id));
        }
        Entity entity = gedcom.createEntity(this.etag, id);
        entity.addDefaultProperties();
        WindowManager.broadcast(new ContextSelectionEvent(new ViewContext(entity), this.getTarget(), true));
    }
}

