/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.actions.CreateRelationship;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertySex;
import genj.gedcom.PropertyXRef;
import genj.view.ViewManager;

public class CreateChild
extends CreateRelationship {
    private Entity parentOrFamily;
    private boolean male;

    public CreateChild(Fam family, ViewManager mgr, boolean male) {
        super(CreateChild.calcText(male), family.getGedcom(), "INDI", mgr);
        this.male = male;
        this.setImage(male ? PropertyChild.IMG_MALE : PropertyChild.IMG_FEMALE);
        this.parentOrFamily = family;
    }

    public CreateChild(Indi parent, ViewManager mgr, boolean male) {
        super(CreateChild.calcText(male), parent.getGedcom(), "INDI", mgr);
        this.male = male;
        this.setImage(male ? PropertyChild.IMG_MALE : PropertyChild.IMG_FEMALE);
        this.parentOrFamily = parent;
    }

    private static String calcText(boolean male) {
        String txt = resources.getString("create.child", false);
        if (txt != null) {
            return txt + " (" + (male ? PropertySex.TXT_MALE : PropertySex.TXT_FEMALE) + ")";
        }
        return resources.getString("create." + (male ? "son" : "daughter"));
    }

    public String getDescription() {
        if (this.parentOrFamily instanceof Indi) {
            return resources.getString("create.child.of", this.parentOrFamily);
        }
        return resources.getString("create.child.in", this.parentOrFamily);
    }

    public String getWarning(Entity indi) {
        Fam fam;
        if (indi != null && (fam = ((Indi)indi).getFamilyWhereBiologicalChild()) != null) {
            return PropertyChild.getLabelChildAlreadyinFamily((Indi)indi, fam);
        }
        return null;
    }

    protected Property change(Entity target, boolean targetIsNew) throws GedcomException {
        PropertyXRef CHIL;
        Fam family;
        Indi parent;
        Indi child = (Indi)target;
        Gedcom ged = child.getGedcom();
        if (this.parentOrFamily instanceof Indi) {
            parent = (Indi)this.parentOrFamily;
            Fam[] fams = parent.getFamiliesWhereSpouse();
            if (fams.length > 0) {
                family = fams[0];
                CHIL = family.addChild(child);
            } else {
                family = (Fam)ged.createEntity("FAM");
                try {
                    CHIL = family.addChild(child);
                }
                catch (GedcomException e) {
                    ged.deleteEntity(family);
                    throw e;
                }
                family.setSpouse(parent);
                family.setSpouse((Indi)ged.createEntity("INDI").addDefaultProperties());
            }
        } else {
            family = (Fam)this.parentOrFamily;
            CHIL = family.addChild(child);
        }
        if (targetIsNew) {
            parent = family.getHusband();
            if (parent == null) {
                parent = family.getWife();
            }
            if (parent != null) {
                child.setName("", parent.getLastName());
            }
            child.setSex(this.male ? 1 : 2);
        }
        return CHIL.getTarget();
    }
}

