/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.Images;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.UnitOfWork;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ImageIcon;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.TextAreaWidget;
import genj.view.ViewManager;
import genj.window.WindowManager;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public abstract class AbstractChange
extends Action2
implements UnitOfWork {
    static final Resources resources = Resources.get(AbstractChange.class);
    protected Gedcom gedcom;
    protected ViewManager manager;
    protected static final ImageIcon imgNew = Images.imgNewEntity;
    private JTextArea confirm;

    public AbstractChange(Gedcom ged, ImageIcon img, String text, ViewManager mgr) {
        this.gedcom = ged;
        this.manager = mgr;
        super.setImage(img);
        super.setText(text);
    }

    protected void handleThrowable(String phase, Throwable t) {
        String message = "" + t.getMessage();
        this.getWindowManager().openDialog("err", "Error", 0, message, Action2.okOnly(), this.getTarget());
    }

    protected WindowManager getWindowManager() {
        return WindowManager.getInstance(this.getTarget());
    }

    protected String getConfirmMessage() {
        return null;
    }

    protected JPanel getDialogContent() {
        JPanel result = new JPanel(new NestedBlockLayout("<col><text wx=\"1\" wy=\"1\"/></col>"));
        result.add(this.getConfirmComponent());
        return result;
    }

    protected JComponent getConfirmComponent() {
        if (this.confirm == null) {
            this.confirm = new TextAreaWidget(this.getConfirmMessage(), 6, 40);
            this.confirm.setWrapStyleWord(true);
            this.confirm.setLineWrap(true);
            this.confirm.setEditable(false);
        }
        return new JScrollPane(this.confirm);
    }

    protected void refresh() {
        if (this.confirm != null) {
            this.confirm.setText(this.getConfirmMessage());
        }
    }

    protected void execute() {
        String msg = this.getConfirmMessage();
        if (msg != null) {
            Action[] actions = new Action[]{new Action2(resources.getString("confirm.proceed", this.getText())), Action2.cancel()};
            int rc = this.getWindowManager().openDialog(this.getClass().getName(), this.getText(), 3, this.getDialogContent(), actions, this.getTarget());
            if (rc != 0) {
                return;
            }
        }
        try {
            this.gedcom.doUnitOfWork(this);
        }
        catch (Throwable t) {
            this.getWindowManager().openDialog(this.getClass().getName(), null, 0, t.getMessage(), Action2.okOnly(), this.getTarget());
        }
    }

    public abstract void perform(Gedcom var1) throws GedcomException;
}

