/*
 * Decompiled with CFR 0.152.
 */
package genj.edit;

import genj.edit.EditView;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomListener;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyChange;
import genj.gedcom.PropertyXRef;
import genj.gedcom.UnitOfWork;
import genj.io.PropertyReader;
import genj.io.PropertyTransferable;
import genj.util.swing.HeadlessLabel;
import genj.util.swing.ImageIcon;
import genj.view.ContextProvider;
import genj.view.ViewContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import spin.Spin;
import swingx.dnd.tree.DnDTree;
import swingx.dnd.tree.DnDTreeModel;
import swingx.tree.AbstractTreeModel;

public class PropertyTreeWidget
extends DnDTree
implements ContextProvider {
    private static final String UNIX_DND_FILE_PREFIX = "file:";
    private DefaultTreeCellRenderer defaultRenderer;
    private Gedcom gedcom;
    private static Gedcom draggingFrom = null;

    public PropertyTreeWidget(Gedcom gedcom) {
        super.setModel(new Model(gedcom));
        this.gedcom = gedcom;
        this.setCellRenderer(new Renderer());
        this.getSelectionModel().setSelectionMode(4);
        this.setToggleClickCount(Integer.MAX_VALUE);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                TreePath path = PropertyTreeWidget.this.getPathForLocation(e.getX(), e.getY());
                if (path != null && PropertyTreeWidget.this.getSelection().contains(path.getLastPathComponent())) {
                    return;
                }
                if (path == null) {
                    PropertyTreeWidget.this.clearSelection();
                } else {
                    PropertyTreeWidget.this.setSelection(Collections.singletonList(path.getLastPathComponent()));
                }
            }
        });
        this.setExpandsSelectedPaths(true);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public ViewContext getContext() {
        Entity root = (Entity)this.getRoot();
        if (root == null) {
            return new ViewContext(this.gedcom);
        }
        Property[] selection = Property.toArray(this.getSelection());
        if (selection.length == 0) {
            return new ViewContext(root);
        }
        ViewContext result = new ViewContext(this.gedcom);
        result.addProperties(selection);
        return result;
    }

    public void setModel() {
        throw new IllegalArgumentException();
    }

    private Model getPropertyModel() {
        return (Model)this.getModel();
    }

    public Object[] getPathFor(Property property) {
        return this.getPropertyModel().getPathToRoot(property);
    }

    public void addNotify() {
        super.addNotify();
        this.gedcom.addGedcomListener((GedcomListener)Spin.over(this.getPropertyModel()));
    }

    public void removeNotify() {
        this.gedcom.removeGedcomListener((GedcomListener)Spin.over(this.getPropertyModel()));
        super.removeNotify();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(256, 128);
    }

    public void setRoot(Property property) {
        if (this.getPropertyModel().getRoot() == property) {
            return;
        }
        this.getPropertyModel().setRoot(property);
        this.expandAllRows();
    }

    public void expandAllRows() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    public void expandAll(TreePath root) {
        this.expandPath(root);
        Model model = this.getPropertyModel();
        Object node = root.getLastPathComponent();
        for (int i = 0; i < model.getChildCount(node); ++i) {
            this.expandAll(root.pathByAddingChild(model.getChild(node, i)));
        }
    }

    public Property getRoot() {
        return this.getPropertyModel().getPropertyRoot();
    }

    public void setRowHeight(int rowHeight) {
        super.setRowHeight(0);
    }

    public void setSelection(List select) {
        this.clearSelection();
        Property root = (Property)this.getPropertyModel().getRoot();
        if (root == null) {
            return;
        }
        TreePath first = null;
        Iterator ps = select.iterator();
        while (ps.hasNext()) {
            try {
                TreePath path = new TreePath(this.getPropertyModel().getPathToRoot((Property)ps.next()));
                this.addSelectionPath(path);
                if (first != null) continue;
                first = path;
            }
            catch (IllegalArgumentException e) {}
        }
        if (first != null) {
            this.scrollPathToVisible(first);
        }
    }

    public List getSelection() {
        ArrayList<Object> result = new ArrayList<Object>();
        TreePath[] paths = this.getSelectionPaths();
        for (int i = 0; paths != null && i < paths.length; ++i) {
            result.add(paths[i].getLastPathComponent());
        }
        return result;
    }

    public Property getPropertyAt(int x, int y) {
        TreePath path = super.getPathForLocation(x, y);
        if (path == null || path.getPathCount() == 0) {
            return null;
        }
        return (Property)path.getLastPathComponent();
    }

    public Property getPropertyAt(Point pos) {
        return this.getPropertyAt(pos.x, pos.y);
    }

    public String getToolTipText(MouseEvent event) {
        Property prop = this.getPropertyAt(event.getX(), event.getY());
        if (prop == null) {
            return null;
        }
        if (prop.isTransient()) {
            return null;
        }
        if (prop.getEntity() == null) {
            return null;
        }
        String info = prop.getPropertyInfo();
        if (info == null) {
            return null;
        }
        return "<html><table width=200><tr><td>" + info + "</td></tr></table></html";
    }

    public void setUI(TreeUI ui) {
        super.setUI(ui);
        this.defaultRenderer = new DefaultTreeCellRenderer();
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof Property) {
            return ((Property)value).getTag();
        }
        return "";
    }

    private abstract class IOUnitOfWork
    implements UnitOfWork {
        private IOUnitOfWork() {
        }

        public final void perform(Gedcom gedcom) throws GedcomException {
            try {
                this.performIO(gedcom);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        protected abstract void performIO(Gedcom var1) throws IOException, UnsupportedFlavorException;
    }

    private class Renderer
    extends HeadlessLabel
    implements TreeCellRenderer {
        private Renderer() {
            this.setOpaque(true);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object object, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (!(object instanceof Property)) {
                return this;
            }
            Property prop = (Property)object;
            if (PropertyTreeWidget.this.defaultRenderer != null) {
                if (sel) {
                    this.setForeground(PropertyTreeWidget.this.defaultRenderer.getTextSelectionColor());
                    this.setBackground(PropertyTreeWidget.this.defaultRenderer.getBackgroundSelectionColor());
                } else {
                    this.setForeground(PropertyTreeWidget.this.defaultRenderer.getTextNonSelectionColor());
                    this.setBackground(PropertyTreeWidget.this.defaultRenderer.getBackgroundNonSelectionColor());
                }
            }
            ImageIcon img = prop.getImage(true);
            if (prop.isPrivate()) {
                img = img.getOverLayed(MetaProperty.IMG_PRIVATE);
            }
            this.setIcon(img);
            this.setText(prop instanceof Entity ? this.calcText((Entity)prop) : this.calcText(prop));
            return this;
        }

        private String calcText(Entity entity) {
            return "@" + entity.getId() + "@ " + entity.getTag();
        }

        private String calcText(Property prop) {
            StringBuffer result = new StringBuffer();
            if (!prop.isTransient()) {
                result.append(prop.getTag());
                result.append(' ');
            }
            if (prop.isSecret()) {
                result.append("*****");
            } else {
                String val = prop.getDisplayValue();
                int nl = val.indexOf(10);
                if (nl >= 0) {
                    val = val.substring(0, nl) + "...";
                }
                result.append(val);
            }
            return result.toString();
        }
    }

    private class Model
    extends AbstractTreeModel
    implements DnDTreeModel,
    GedcomListener {
        private Property root = null;
        private Gedcom ged;

        protected Model(Gedcom gedcom) {
            this.ged = gedcom;
        }

        protected void setRoot(Property set) {
            this.root = set;
            this.rootExchanged();
            PropertyTreeWidget.this.setRootVisible(this.root != null);
            PropertyTreeWidget.this.expandAllRows();
        }

        public Property getPropertyRoot() {
            return this.root;
        }

        public Transferable createTransferable(Object[] nodes) {
            draggingFrom = this.ged;
            List list = Property.normalize(Arrays.asList(nodes));
            return new PropertyTransferable(list);
        }

        public int getDragActions(Transferable transferable) {
            return 3;
        }

        public int getDropActions(Transferable transferable, Object parent, int index) {
            try {
                if (transferable.isDataFlavorSupported(PropertyTransferable.VMLOCAL_FLAVOR)) {
                    List dragged = (List)transferable.getTransferData(PropertyTransferable.VMLOCAL_FLAVOR);
                    for (Property pparent = (Property)parent; pparent != null; pparent = pparent.getParent()) {
                        if (!dragged.contains(pparent)) continue;
                        return 0;
                    }
                    return 3;
                }
                if (transferable.isDataFlavorSupported(PropertyTransferable.STRING_FLAVOR)) {
                    return 3;
                }
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    return 3;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return 0;
        }

        public void drop(final Transferable transferable, Object parent, final int index, final int action) throws IOException, UnsupportedFlavorException {
            final Property pparent = (Property)parent;
            if (transferable.isDataFlavorSupported(PropertyTransferable.VMLOCAL_FLAVOR)) {
                final List children = (List)transferable.getTransferData(PropertyTransferable.VMLOCAL_FLAVOR);
                if (action == 2 && pparent.hasProperties(children)) {
                    this.ged.doMuteUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            pparent.moveProperties(children, index);
                        }
                    });
                    return;
                }
                this.ged.doMuteUnitOfWork(new IOUnitOfWork(){

                    protected void performIO(Gedcom gedcom) throws IOException, UnsupportedFlavorException {
                        int i;
                        ArrayList xrefs = new ArrayList();
                        String string = transferable.getTransferData(PropertyTransferable.STRING_FLAVOR).toString();
                        new PropertyReader(new StringReader(string), xrefs, true).read(pparent, index);
                        if (action == 2 && draggingFrom == gedcom) {
                            for (i = 0; i < children.size(); ++i) {
                                Property child = (Property)children.get(i);
                                child.getParent().delProperty(child);
                            }
                        }
                        for (i = 0; i < xrefs.size(); ++i) {
                            try {
                                ((PropertyXRef)xrefs.get(i)).link();
                                continue;
                            }
                            catch (Throwable t) {
                                EditView.LOG.log(Level.WARNING, "caught exception during dnd trying to link xrefs", t);
                            }
                        }
                    }
                });
                return;
            }
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                this.ged.doMuteUnitOfWork(new IOUnitOfWork(){

                    protected void performIO(Gedcom gedcom) throws IOException, UnsupportedFlavorException {
                        Iterator files = ((List)transferable.getTransferData(DataFlavor.javaFileListFlavor)).iterator();
                        while (files.hasNext()) {
                            pparent.addFile((File)files.next());
                        }
                    }
                });
                return;
            }
            if (!transferable.isDataFlavorSupported(PropertyTransferable.STRING_FLAVOR)) {
                return;
            }
            final String string = transferable.getTransferData(PropertyTransferable.STRING_FLAVOR).toString();
            if (string.length() < 4) {
                return;
            }
            if (string.startsWith(PropertyTreeWidget.UNIX_DND_FILE_PREFIX)) {
                this.ged.doMuteUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) {
                        StringTokenizer files = new StringTokenizer(string, "\n");
                        while (files.hasMoreTokens()) {
                            String file = files.nextToken().trim();
                            if (!file.startsWith(PropertyTreeWidget.UNIX_DND_FILE_PREFIX)) continue;
                            pparent.addFile(new File(file.substring(PropertyTreeWidget.UNIX_DND_FILE_PREFIX.length())));
                        }
                    }
                });
                return;
            }
            EditView.LOG.fine("reading dropped text '" + string + "'");
            this.ged.doMuteUnitOfWork(new IOUnitOfWork(){

                protected void performIO(Gedcom gedcom) throws IOException, UnsupportedFlavorException {
                    new PropertyReader(new StringReader(string), null, true).read(pparent, index);
                }
            });
        }

        public void drag(Transferable transferable, int action) throws UnsupportedFlavorException, IOException {
            final List children = (List)transferable.getTransferData(PropertyTransferable.VMLOCAL_FLAVOR);
            if (children.isEmpty()) {
                return;
            }
            if (action == 2 && draggingFrom != this.ged) {
                this.ged.doMuteUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) {
                        for (int i = 0; i < children.size(); ++i) {
                            Property child = (Property)children.get(i);
                            child.getParent().delProperty(child);
                        }
                    }
                });
            }
        }

        public void releaseTransferable(Transferable transferable) {
            draggingFrom = null;
        }

        protected Object getParent(Object node) {
            if (node == this.root) {
                return null;
            }
            return ((Property)node).getParent();
        }

        public Object getChild(Object parent, int index) {
            return ((Property)parent).getProperty(index);
        }

        public int getChildCount(Object parent) {
            return ((Property)parent).getNoOfProperties();
        }

        public int getIndexOfChild(Object parent, Object child) {
            try {
                return ((Property)parent).getPropertyPosition((Property)child);
            }
            catch (Throwable t) {
                return -1;
            }
        }

        public Object getRoot() {
            return this.root;
        }

        public boolean isLeaf(Object node) {
            return ((Property)node).getNoOfProperties() == 0;
        }

        public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        }

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            if (this.root == entity) {
                this.setRoot(null);
            }
        }

        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
            if (this.root != property.getEntity()) {
                return;
            }
            Object[] path = PropertyTreeWidget.this.getPathFor(property);
            this.fireTreeNodesInserted(this, path, new int[]{pos}, new Property[]{added});
            PropertyTreeWidget.this.expandAllRows();
        }

        public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
            if (this.root != property.getEntity()) {
                return;
            }
            this.fireTreeNodesChanged(this, PropertyTreeWidget.this.getPathFor(property), null, null);
        }

        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property deleted) {
            if (this.root != property.getEntity()) {
                return;
            }
            if (property instanceof PropertyChange) {
                return;
            }
            this.fireTreeNodesRemoved(this, PropertyTreeWidget.this.getPathFor(property), new int[]{pos}, new Property[]{deleted});
        }

        static /* synthetic */ PropertyTreeWidget access$300(Model x0) {
            return x0.PropertyTreeWidget.this;
        }
    }
}

