/*
 * Decompiled with CFR 0.152.
 */
package genj.edit;

import genj.crypto.Enigma;
import genj.edit.EditView;
import genj.edit.Images;
import genj.edit.actions.AbstractChange;
import genj.edit.actions.CreateAlias;
import genj.edit.actions.CreateAssociation;
import genj.edit.actions.CreateChild;
import genj.edit.actions.CreateEntity;
import genj.edit.actions.CreateParent;
import genj.edit.actions.CreateSibling;
import genj.edit.actions.CreateSpouse;
import genj.edit.actions.CreateXReference;
import genj.edit.actions.DelEntity;
import genj.edit.actions.DelProperty;
import genj.edit.actions.OpenForEdit;
import genj.edit.actions.Redo;
import genj.edit.actions.RunExternal;
import genj.edit.actions.SetPlaceHierarchy;
import genj.edit.actions.SetSubmitter;
import genj.edit.actions.SwapSpouses;
import genj.edit.actions.TogglePrivate;
import genj.edit.actions.Undo;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyPlace;
import genj.gedcom.Submitter;
import genj.gedcom.TagPath;
import genj.io.FileAssociation;
import genj.util.Registry;
import genj.util.swing.Action2;
import genj.util.swing.ImageIcon;
import genj.view.ActionProvider;
import genj.view.ViewContext;
import genj.view.ViewFactory;
import genj.view.ViewManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;

public class EditViewFactory
implements ViewFactory,
ActionProvider {
    private static final Action2 aNOOP = Action2.NOOP;
    static /* synthetic */ Class class$genj$gedcom$PropertyNote;
    static /* synthetic */ Class class$genj$gedcom$PropertyRepository;
    static /* synthetic */ Class class$genj$gedcom$PropertySource;
    static /* synthetic */ Class class$genj$gedcom$PropertySubmitter;
    static /* synthetic */ Class class$genj$gedcom$PropertyFamilyChild;
    static /* synthetic */ Class class$genj$gedcom$PropertyMedia;

    public JComponent createView(String title, Gedcom gedcom, Registry registry, ViewManager manager) {
        return new EditView(title, gedcom, registry, manager);
    }

    public ImageIcon getImage() {
        return Images.imgView;
    }

    public String getTitle(boolean abbreviate) {
        return EditView.resources.getString("title" + (abbreviate ? ".short" : ""));
    }

    public List createActions(Property[] properties, ViewManager manager) {
        ArrayList<AbstractChange> result = new ArrayList<AbstractChange>();
        for (int i = 0; i < properties.length; ++i) {
            if (!(properties[i] instanceof Entity)) continue;
            return result;
        }
        if (Enigma.isAvailable()) {
            result.add(new TogglePrivate(properties[0].getGedcom(), Arrays.asList(properties), manager));
        }
        result.add(new DelProperty(properties, manager));
        return result;
    }

    public List createActions(Property property, ViewManager manager) {
        ArrayList<AbstractChange> result = new ArrayList<AbstractChange>();
        if (property instanceof PropertyFile) {
            EditViewFactory.createActions(result, (PropertyFile)property);
        }
        if (property instanceof PropertyPlace) {
            result.add(new SetPlaceHierarchy((PropertyPlace)property, manager));
        }
        MetaProperty[] subs = property.getNestedMetaProperties(0);
        for (int s = 0; s < subs.length; ++s) {
            Class type = subs[s].getType();
            if (type != (class$genj$gedcom$PropertyNote == null ? EditViewFactory.class$("genj.gedcom.PropertyNote") : class$genj$gedcom$PropertyNote) && type != (class$genj$gedcom$PropertyRepository == null ? EditViewFactory.class$("genj.gedcom.PropertyRepository") : class$genj$gedcom$PropertyRepository) && type != (class$genj$gedcom$PropertySource == null ? EditViewFactory.class$("genj.gedcom.PropertySource") : class$genj$gedcom$PropertySource) && type != (class$genj$gedcom$PropertySubmitter == null ? EditViewFactory.class$("genj.gedcom.PropertySubmitter") : class$genj$gedcom$PropertySubmitter) && type != (class$genj$gedcom$PropertyFamilyChild == null ? EditViewFactory.class$("genj.gedcom.PropertyFamilyChild") : class$genj$gedcom$PropertyFamilyChild) && type != (class$genj$gedcom$PropertyMedia == null ? EditViewFactory.class$("genj.gedcom.PropertyMedia") : class$genj$gedcom$PropertyMedia)) continue;
            result.add(new CreateXReference(property, subs[s].getTag(), manager));
        }
        if (property instanceof PropertyEvent && (property.getEntity() instanceof Indi || property.getGedcom().getGrammar().getMeta(new TagPath("INDI:ASSO")).allows("TYPE"))) {
            result.add(new CreateAssociation(property, manager));
        }
        if (Enigma.isAvailable()) {
            result.add(new TogglePrivate(property.getGedcom(), Collections.singletonList(property), manager));
        }
        if (!property.isTransient()) {
            result.add(new DelProperty(property, manager));
        }
        return result;
    }

    public List createActions(Entity entity, ViewManager manager) {
        ArrayList<Action2> result = new ArrayList<Action2>();
        if (entity instanceof Indi) {
            this.createActions(result, (Indi)entity, manager);
        }
        if (entity instanceof Fam) {
            this.createActions(result, (Fam)entity, manager);
        }
        if (entity instanceof Submitter) {
            this.createActions(result, (Submitter)entity, manager);
        }
        result.add(Action2.NOOP);
        MetaProperty[] subs = entity.getNestedMetaProperties(0);
        for (int s = 0; s < subs.length; ++s) {
            Class type = subs[s].getType();
            if (type != (class$genj$gedcom$PropertyNote == null ? EditViewFactory.class$("genj.gedcom.PropertyNote") : class$genj$gedcom$PropertyNote) && type != (class$genj$gedcom$PropertyRepository == null ? EditViewFactory.class$("genj.gedcom.PropertyRepository") : class$genj$gedcom$PropertyRepository) && type != (class$genj$gedcom$PropertySource == null ? EditViewFactory.class$("genj.gedcom.PropertySource") : class$genj$gedcom$PropertySource) && type != (class$genj$gedcom$PropertySubmitter == null ? EditViewFactory.class$("genj.gedcom.PropertySubmitter") : class$genj$gedcom$PropertySubmitter) && type != (class$genj$gedcom$PropertyMedia == null ? EditViewFactory.class$("genj.gedcom.PropertyMedia") : class$genj$gedcom$PropertyMedia)) continue;
            result.add(new CreateXReference(entity, subs[s].getTag(), manager));
        }
        result.add(Action2.NOOP);
        result.add(new DelEntity(entity, manager));
        EditView[] edits = EditView.getInstances(entity.getGedcom());
        if (edits.length == 0) {
            result.add(Action2.NOOP);
            result.add(new OpenForEdit(new ViewContext(entity), manager));
        }
        return result;
    }

    public List createActions(Gedcom gedcom, ViewManager manager) {
        ArrayList<Action2> result = new ArrayList<Action2>();
        result.add(new CreateEntity(gedcom, "INDI", manager));
        result.add(new CreateEntity(gedcom, "FAM", manager));
        result.add(new CreateEntity(gedcom, "NOTE", manager));
        result.add(new CreateEntity(gedcom, "OBJE", manager));
        result.add(new CreateEntity(gedcom, "REPO", manager));
        result.add(new CreateEntity(gedcom, "SOUR", manager));
        result.add(new CreateEntity(gedcom, "SUBM", manager));
        result.add(Action2.NOOP);
        result.add(new Undo(gedcom, gedcom.canUndo()));
        result.add(new Redo(gedcom, gedcom.canRedo()));
        return result;
    }

    private void createActions(List result, Indi indi, ViewManager manager) {
        result.add(new CreateChild(indi, manager, true));
        result.add(new CreateChild(indi, manager, false));
        result.add(new CreateParent(indi, manager));
        result.add(new CreateSpouse(indi, manager));
        result.add(new CreateSibling(indi, manager, true));
        result.add(new CreateSibling(indi, manager, false));
        result.add(new CreateAlias(indi, manager));
    }

    private void createActions(List result, Fam fam, ViewManager manager) {
        result.add(new CreateChild(fam, manager, true));
        result.add(new CreateChild(fam, manager, false));
        if (fam.getNoOfSpouses() < 2) {
            result.add(new CreateParent(fam, manager));
        }
        if (fam.getNoOfSpouses() != 0) {
            result.add(new SwapSpouses(fam, manager));
        }
    }

    private void createActions(List result, Submitter submitter, ViewManager manager) {
        result.add(new SetSubmitter(submitter, manager));
    }

    public static void createActions(List result, PropertyFile file) {
        String suffix = file.getSuffix();
        List assocs = FileAssociation.getAll(suffix);
        if (assocs.isEmpty()) {
            result.add(new RunExternal(file));
        } else {
            Iterator it = assocs.iterator();
            while (it.hasNext()) {
                FileAssociation fa = (FileAssociation)it.next();
                result.add(new RunExternal(file, fa));
            }
        }
    }
}

