/*
 * Decompiled with CFR 0.152.
 */
package genj.edit;

import genj.edit.AdvancedEditor;
import genj.edit.BasicEditor;
import genj.edit.Editor;
import genj.edit.Images;
import genj.edit.Options;
import genj.edit.actions.Redo;
import genj.edit.actions.Undo;
import genj.edit.beans.BeanFactory;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomListenerAdapter;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ButtonHelper;
import genj.util.swing.PopupWidget;
import genj.view.ContextProvider;
import genj.view.ContextSelectionEvent;
import genj.view.ToolBarSupport;
import genj.view.ViewContext;
import genj.view.ViewManager;
import genj.window.WindowBroadcastEvent;
import genj.window.WindowBroadcastListener;
import genj.window.WindowManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import spin.Spin;

public class EditView
extends JPanel
implements ToolBarSupport,
WindowBroadcastListener,
ContextProvider {
    static final Logger LOG = Logger.getLogger("genj.edit");
    private static List instances = new LinkedList();
    private Gedcom gedcom;
    private Registry registry;
    private BeanFactory beanFactory;
    private ViewManager manager;
    static final Resources resources = Resources.get(EditView.class);
    private Sticky sticky = new Sticky();
    private Back back = new Back();
    private Forward forward = new Forward();
    private Mode mode;
    private ContextMenu contextMenu = new ContextMenu();
    private Callback callback = new Callback();
    private Undo undo;
    private Redo redo;
    private boolean isSticky = false;
    private Editor editor;

    public EditView(String setTitle, Gedcom setGedcom, Registry setRegistry, ViewManager setManager) {
        super(new BorderLayout());
        this.gedcom = setGedcom;
        this.registry = setRegistry;
        this.manager = setManager;
        this.beanFactory = new BeanFactory(this.manager, this.registry);
        this.mode = new Mode();
        this.undo = new Undo(this.gedcom);
        this.redo = new Redo(this.gedcom);
        if (this.registry.get("advanced", false)) {
            this.mode.trigger();
        }
        InputMap imap = this.getInputMap(2);
        ActionMap amap = this.getActionMap();
        imap.put(KeyStroke.getKeyStroke("alt LEFT"), this.back);
        amap.put(this.back, this.back);
        imap.put(KeyStroke.getKeyStroke("alt RIGHT"), this.forward);
        amap.put(this.forward, this.forward);
    }

    private void setEditor(Editor set) {
        ViewContext old = null;
        if (this.editor != null) {
            old = this.editor.getContext();
            this.editor.setContext(new ViewContext(this.gedcom));
        }
        this.removeAll();
        this.editor = set;
        this.editor.init(this.gedcom, this, this.registry);
        this.add((Component)this.editor, "Center");
        if (old != null) {
            this.editor.setContext(old);
        }
        this.revalidate();
        this.repaint();
    }

    public void addNotify() {
        super.addNotify();
        instances.add(this);
        Entity entity = this.gedcom.getEntity(this.registry.get("entity", (String)null));
        if (entity == null) {
            entity = this.gedcom.getFirstEntity("INDI");
        }
        boolean bl = this.isSticky = entity == null ? false : this.registry.get("sticky", false);
        if (entity != null) {
            this.setContext(new ViewContext(entity));
        }
        this.callback.enable();
        this.gedcom.addGedcomListener((GedcomListener)Spin.over(this.undo));
        this.gedcom.addGedcomListener((GedcomListener)Spin.over(this.redo));
    }

    public void removeNotify() {
        this.registry.put("sticky", this.isSticky);
        Entity entity = this.editor.getContext().getEntity();
        if (entity != null) {
            this.registry.put("entity", entity.getId());
        }
        this.registry.put("advanced", this.mode.advanced);
        instances.remove(this);
        this.callback.disable();
        this.gedcom.removeGedcomListener((GedcomListener)Spin.over(this.undo));
        this.gedcom.removeGedcomListener((GedcomListener)Spin.over(this.redo));
        super.removeNotify();
    }

    BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    boolean isCommitChanges() {
        if (!this.getTopLevelAncestor().isVisible()) {
            return false;
        }
        if (Options.getInstance().isAutoCommit) {
            return true;
        }
        JCheckBox auto = new JCheckBox(resources.getString("confirm.autocomit"));
        auto.setFocusable(false);
        int rc = WindowManager.getInstance(this).openDialog(null, resources.getString("confirm.keep.changes"), 3, new JComponent[]{new JLabel(resources.getString("confirm.keep.changes")), auto}, Action2.yesNo(), (Component)this);
        if (rc != 0) {
            return false;
        }
        Options.getInstance().isAutoCommit = auto.isSelected();
        return true;
    }

    static EditView[] getInstances(Gedcom gedcom) {
        ArrayList<EditView> result = new ArrayList<EditView>();
        Iterator it = instances.iterator();
        while (it.hasNext()) {
            EditView edit = (EditView)it.next();
            if (edit.gedcom != gedcom) continue;
            result.add(edit);
        }
        return result.toArray(new EditView[result.size()]);
    }

    public ViewContext getContext() {
        return this.editor.getContext();
    }

    public boolean handleBroadcastEvent(WindowBroadcastEvent event) {
        ContextSelectionEvent cse = ContextSelectionEvent.narrow(event, this.gedcom);
        if (cse == null) {
            return true;
        }
        ViewContext context = cse.getContext();
        if (context.getEntity() == null) {
            return true;
        }
        if (cse.isInbound()) {
            if (!this.isSticky) {
                this.setContext(context);
            }
            return false;
        }
        if (cse.isActionPerformed()) {
            if (context.getProperty() instanceof PropertyXRef) {
                PropertyXRef xref = (PropertyXRef)context.getProperty();
                if ((xref = xref.getTarget()) != null) {
                    context = new ViewContext(xref);
                }
            }
            this.setContext(context);
        }
        return true;
    }

    public void setContext(ViewContext context) {
        ViewContext current = this.editor.getContext();
        if (current.getEntity() != context.getEntity()) {
            this.back.push(current);
        }
        this.editor.setContext(context);
    }

    public void populate(JToolBar bar) {
        ButtonHelper bh = new ButtonHelper().setInsets(0).setContainer(bar);
        bh.create(this.back);
        bh.create(this.forward);
        bh.create(this.sticky, Images.imgStickOn, this.isSticky);
        bh.create(this.undo);
        bh.create(this.redo);
        bar.add(this.contextMenu);
        bar.addSeparator();
        bh.create(this.mode, Images.imgAdvanced, this.mode.advanced).setFocusable(false);
    }

    public Dimension getPreferredSize() {
        return new Dimension(256, 480);
    }

    public boolean isSticky() {
        return this.isSticky;
    }

    public Entity getEntity() {
        return this.editor.getContext().getEntity();
    }

    private class Callback
    extends GedcomListenerAdapter {
        private Callback() {
        }

        void enable() {
            EditView.this.gedcom.addGedcomListener((GedcomListener)Spin.over(this));
            EditView.this.back.clear();
            EditView.this.forward.clear();
        }

        void disable() {
            EditView.this.gedcom.removeGedcomListener((GedcomListener)Spin.over(this));
            EditView.this.back.clear();
            EditView.this.forward.clear();
        }

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            EditView.this.back.remove(entity);
            EditView.this.forward.remove(entity);
        }

        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property removed) {
            EditView.this.back.remove(removed);
            EditView.this.forward.remove(removed);
        }

        public void gedcomWriteLockReleased(Gedcom gedcom) {
            if (EditView.this.editor.getContext().getEntities().length == 0 && EditView.this.back.isEnabled()) {
                EditView.this.back.execute();
            }
        }
    }

    private class Back
    extends Action2 {
        protected Stack stack = new Stack();

        public Back() {
            this.setImage(Images.imgBack);
            this.setTip(Resources.get(this).getString("action.return.tip"));
            this.setEnabled(false);
        }

        protected void execute() {
            if (this.stack.size() == 0) {
                return;
            }
            ViewContext old = EditView.this.editor.getContext();
            if (old.getEntities().length > 0) {
                ((EditView)EditView.this).forward.stack.push(EditView.this.editor.getContext());
                EditView.this.forward.setEnabled(true);
            }
            ViewContext context = new ViewContext((Context)this.stack.pop());
            WindowManager.broadcast(new ContextSelectionEvent(context, EditView.this));
            EditView.this.editor.setContext(context);
            this.setEnabled(this.stack.size() > 0);
        }

        public void push(Context context) {
            EditView.this.forward.clear();
            this.stack.push(new Context(context));
            while (this.stack.size() > 32) {
                this.stack.remove(0);
            }
            this.setEnabled(true);
        }

        void clear() {
            this.stack.clear();
            this.setEnabled(false);
        }

        void remove(Entity entity) {
            ListIterator it = this.stack.listIterator();
            block0: while (it.hasNext()) {
                Context ctx = (Context)it.next();
                Entity[] ents = ctx.getEntities();
                for (int i = 0; i < ents.length; ++i) {
                    if (ents[i] != entity) continue;
                    it.remove();
                    continue block0;
                }
            }
            this.setEnabled(!this.stack.isEmpty());
        }

        void remove(Property prop) {
            List<Property> list = Collections.singletonList(prop);
            ListIterator it = this.stack.listIterator();
            while (it.hasNext()) {
                Context ctx = (Context)it.next();
                ctx.removeProperties(list);
            }
        }
    }

    private class Forward
    extends Back {
        public Forward() {
            this.setImage(Images.imgForward);
            this.setTip(Resources.get(this).getString("action.forward.tip"));
        }

        protected void execute() {
            if (this.stack.size() == 0) {
                return;
            }
            ViewContext old = EditView.this.editor.getContext();
            if (old.getEntities().length > 0) {
                ((EditView)EditView.this).back.stack.push(EditView.this.editor.getContext());
                EditView.this.back.setEnabled(true);
            }
            ViewContext context = new ViewContext((Context)this.stack.pop());
            WindowManager.broadcast(new ContextSelectionEvent(context, EditView.this));
            EditView.this.editor.setContext(context);
            this.setEnabled(this.stack.size() > 0);
        }
    }

    private class Mode
    extends Action2 {
        private boolean advanced = false;

        private Mode() {
            this.setImage(Images.imgView);
            EditView.this.setEditor(new BasicEditor());
            this.setTip(resources, "action.mode");
        }

        protected void execute() {
            this.advanced = !this.advanced;
            EditView.this.setEditor(this.advanced ? new AdvancedEditor() : new BasicEditor());
        }
    }

    private class Sticky
    extends Action2 {
        protected Sticky() {
            super.setImage(Images.imgStickOff);
            super.setTip(resources, "action.stick.tip");
        }

        protected void execute() {
            EditView.this.isSticky = !EditView.this.isSticky;
        }
    }

    private class ContextMenu
    extends PopupWidget {
        private ContextMenu() {
            this.setIcon(Gedcom.getImage());
            this.setToolTipText(resources.getString("action.context.tip"));
        }

        protected JPopupMenu createPopup() {
            EditView.this.editor.setContext(EditView.this.editor.getContext());
            return EditView.this.manager.getContextMenu(EditView.this.editor.getContext(), this);
        }
    }
}

