/*
 * Decompiled with CFR 0.152.
 */
package genj.edit;

import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.util.GridBagHelper;
import genj.util.Resources;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ChoosePropertyBean
extends JComponent {
    private JRadioButton rbChoose;
    private JRadioButton rbNew;
    private JTextField tfNew;
    private JList lChoose;
    private JScrollPane spInfo;
    private JTextPane tpInfo;
    private Property parent;
    private List listeners = new ArrayList();
    private Callback callback = new Callback();

    public ChoosePropertyBean(Property pArent, Resources resources) {
        this.parent = pArent;
        MetaProperty[] defs = this.parent.getNestedMetaProperties(5);
        Arrays.sort(defs, this.callback);
        GridBagHelper gh = new GridBagHelper(this);
        this.rbChoose = new JRadioButton(resources.getString("choose.known"), defs.length > 0);
        this.rbChoose.setEnabled(defs.length > 0);
        this.rbChoose.addItemListener(this.callback);
        this.rbChoose.setAlignmentX(0.0f);
        gh.add(this.rbChoose, 1, 1, 2, 1, 17);
        this.lChoose = new JList<MetaProperty>(defs);
        this.lChoose.setVisibleRowCount(4);
        this.lChoose.setEnabled(defs.length > 0);
        this.lChoose.setCellRenderer(new MetaDefRenderer());
        this.lChoose.addListSelectionListener(this.callback);
        this.lChoose.addMouseListener(this.callback);
        JScrollPane sp = new JScrollPane(this.lChoose);
        sp.setMinimumSize(sp.getPreferredSize());
        gh.add(sp, 1, 2, 1, 1, 34);
        this.tpInfo = new JTextPane();
        this.tpInfo.setText("");
        this.tpInfo.setEditable(false);
        this.spInfo = new JScrollPane(this.tpInfo);
        gh.add(this.spInfo, 2, 2, 1, 1, 68);
        this.rbNew = new JRadioButton(resources.getString("choose.new"), defs.length == 0);
        this.rbNew.addItemListener(this.callback);
        this.rbNew.setAlignmentX(0.0f);
        gh.add(this.rbNew, 1, 3, 2, 1, 17);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbChoose);
        group.add(this.rbNew);
        this.tfNew = new JTextField();
        this.tfNew.setEnabled(defs.length == 0);
        this.tfNew.setAlignmentX(0.0f);
        gh.add(this.tfNew, 1, 4, 2, 1, 17);
        if (defs.length > 0) {
            this.lChoose.setSelectedIndex(0);
        }
    }

    public String[] getSelectedTags() {
        String[] stringArray;
        String[] result = null;
        if (this.rbChoose.isSelected()) {
            Object[] objs = this.lChoose.getSelectedValues();
            result = new String[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                result[i] = ((MetaProperty)objs[i]).getTag();
            }
            return result;
        }
        String tag = this.tfNew.getText();
        if (tag != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = tag;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    private class Callback
    extends MouseAdapter
    implements ItemListener,
    ListSelectionListener,
    Comparator {
        private Callback() {
        }

        public int compare(Object o1, Object o2) {
            MetaProperty m1 = (MetaProperty)o1;
            MetaProperty m2 = (MetaProperty)o2;
            return m1.getTag().compareTo(m2.getTag());
        }

        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() > 1) {
                ActionEvent e = new ActionEvent(ChoosePropertyBean.this, 0, null);
                ActionListener[] as = ChoosePropertyBean.this.listeners.toArray(new ActionListener[ChoosePropertyBean.this.listeners.size()]);
                for (int i = 0; i < as.length; ++i) {
                    as[i].actionPerformed(e);
                }
            }
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == ChoosePropertyBean.this.rbChoose) {
                ChoosePropertyBean.this.lChoose.setEnabled(true);
                ChoosePropertyBean.this.tfNew.setEnabled(false);
                ChoosePropertyBean.this.lChoose.requestFocusInWindow();
            }
            if (e.getSource() == ChoosePropertyBean.this.rbNew) {
                ChoosePropertyBean.this.lChoose.clearSelection();
                ChoosePropertyBean.this.lChoose.setEnabled(false);
                ChoosePropertyBean.this.tfNew.setEnabled(true);
                ChoosePropertyBean.this.tfNew.requestFocusInWindow();
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            Object[] selection = ChoosePropertyBean.this.lChoose.getSelectedValues();
            if (selection == null || selection.length == 0) {
                ChoosePropertyBean.this.tpInfo.setText("");
                return;
            }
            MetaProperty meta = (MetaProperty)selection[selection.length - 1];
            ChoosePropertyBean.this.tpInfo.setText(meta.getInfo());
            if (!ChoosePropertyBean.this.rbChoose.isSelected()) {
                ChoosePropertyBean.this.rbChoose.doClick();
            }
        }
    }

    class MetaDefRenderer
    extends DefaultListCellRenderer
    implements ListCellRenderer {
        MetaDefRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            MetaProperty def = (MetaProperty)value;
            this.setText(def.getTag() + " (" + def.getName() + ")");
            this.setIcon(def.getImage());
            return this;
        }
    }
}

