/*
 * Decompiled with CFR 0.152.
 */
package genj.edit;

import genj.edit.EditView;
import genj.edit.Editor;
import genj.edit.Images;
import genj.edit.beans.BeanFactory;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomListenerAdapter;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyVisitor;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.gedcom.UnitOfWork;
import genj.util.Registry;
import genj.util.swing.Action2;
import genj.util.swing.ButtonHelper;
import genj.util.swing.ImageIcon;
import genj.util.swing.LinkWidget;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.PopupWidget;
import genj.view.ContextProvider;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import spin.Spin;

class BasicEditor
extends Editor
implements ContextProvider {
    private static Map META2DESCRIPTOR = new HashMap();
    private Gedcom gedcom = null;
    private Entity currentEntity = null;
    private Registry registry;
    private EditView view;
    private Action2 ok = new OK();
    private Action2 cancel = new Cancel();
    private BeanPanel beanPanel;
    private JPanel buttonPanel;
    private GedcomListener callback = new Callback();
    static /* synthetic */ Class class$genj$edit$BasicEditor;
    static /* synthetic */ Class class$genj$edit$BasicEditor$PropertyProxy;
    static /* synthetic */ Class class$genj$gedcom$Property;

    BasicEditor() {
    }

    public void init(Gedcom gedcom, EditView edit, Registry registry) {
        this.gedcom = gedcom;
        this.view = edit;
        this.registry = registry;
        this.setFocusTraversalPolicy(new FocusPolicy());
        this.setFocusCycleRoot(true);
        this.buttonPanel = new JPanel(new FlowLayout(2));
        ButtonHelper bh = new ButtonHelper().setInsets(0).setContainer(this.buttonPanel);
        bh.create(this.ok).setFocusable(false);
        bh.create(this.cancel).setFocusable(false);
    }

    public void addNotify() {
        super.addNotify();
        this.gedcom.addGedcomListener((GedcomListener)Spin.over(this.callback));
    }

    public void removeNotify() {
        this.setEntity(null, null);
        this.gedcom.removeGedcomListener((GedcomListener)Spin.over(this.callback));
        super.removeNotify();
    }

    public ViewContext getContext() {
        PropertyBean bean = this.getFocus();
        if (bean != null && bean.getContext() != null) {
            return bean.getContext();
        }
        if (this.currentEntity != null) {
            return new ViewContext(this.currentEntity);
        }
        return new ViewContext(this.gedcom);
    }

    public void setContext(ViewContext context) {
        if (this.currentEntity != context.getEntity()) {
            this.setEntity(context.getEntity(), context.getProperty());
        } else if (this.beanPanel != null) {
            this.beanPanel.select(context.getProperty());
        }
    }

    public void setEntity(Entity set, Property focus) {
        if (!this.gedcom.isWriteLocked() && this.currentEntity != null && this.ok.isEnabled() && this.view.isCommitChanges()) {
            this.ok.trigger();
        }
        this.currentEntity = set;
        if (focus == null) {
            PropertyBean bean = this.getFocus();
            if (bean != null && bean.getProperty() != null && bean.getProperty().getEntity() == this.currentEntity) {
                focus = bean.getProperty();
            }
            if (focus == null) {
                focus = this.currentEntity;
            }
        }
        if (this.beanPanel != null) {
            this.removeAll();
            this.beanPanel = null;
        }
        if (this.currentEntity != null) {
            try {
                this.beanPanel = new BeanPanel();
                this.setLayout(new BorderLayout());
                this.add("Center", new JScrollPane(this.beanPanel));
                this.add("South", this.buttonPanel);
            }
            catch (Throwable t) {
                EditView.LOG.log(Level.SEVERE, "problem changing entity", t);
            }
            this.ok.setEnabled(false);
            this.cancel.setEnabled(false);
        }
        this.revalidate();
        this.repaint();
        if (this.beanPanel != null) {
            this.beanPanel.select(focus);
        }
    }

    private PropertyBean getFocus() {
        Component focus;
        for (focus = FocusManager.getCurrentManager().getFocusOwner(); focus != null && !(focus instanceof PropertyBean); focus = focus.getParent()) {
        }
        if (!(focus instanceof PropertyBean)) {
            return null;
        }
        return SwingUtilities.isDescendingFrom(focus, this) ? (PropertyBean)focus : null;
    }

    private static NestedBlockLayout getSharedDescriptor(MetaProperty meta) {
        NestedBlockLayout descriptor = (NestedBlockLayout)META2DESCRIPTOR.get(meta);
        if (descriptor != null) {
            return descriptor;
        }
        if (META2DESCRIPTOR.containsKey(meta)) {
            return null;
        }
        for (MetaProperty cursor = meta; descriptor == null && cursor != null; cursor = cursor.getSuper()) {
            String file = "descriptors/" + (cursor.isEntity() ? "entities" : "properties") + "/" + cursor.getTag() + ".xml";
            try {
                InputStream in = (class$genj$edit$BasicEditor == null ? BasicEditor.class$("genj.edit.BasicEditor") : class$genj$edit$BasicEditor).getResourceAsStream(file);
                if (in == null) continue;
                descriptor = new NestedBlockLayout(in);
                in.close();
                continue;
            }
            catch (IOException e) {
                EditView.LOG.log(Level.WARNING, "problem reading descriptor " + file + " (" + e.getMessage() + ")");
                continue;
            }
            catch (Throwable t) {
                EditView.LOG.log(Level.WARNING, "problem parsing descriptor " + file + " (" + t.getMessage() + ")");
            }
        }
        META2DESCRIPTOR.put(meta, descriptor);
        return descriptor;
    }

    private class Callback
    extends GedcomListenerAdapter {
        private Property setFocus;

        private Callback() {
        }

        public void gedcomWriteLockAcquired(Gedcom gedcom) {
            this.setFocus = null;
        }

        public void gedcomWriteLockReleased(Gedcom gedcom) {
            BasicEditor.this.setEntity(BasicEditor.this.currentEntity, this.setFocus);
        }

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            if (BasicEditor.this.currentEntity == entity) {
                BasicEditor.this.currentEntity = null;
            }
        }

        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
            if (this.setFocus == null && property.getEntity() == BasicEditor.this.currentEntity) {
                this.setFocus = added;
            }
        }

        public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
            if (this.setFocus == null && property.getEntity() == BasicEditor.this.currentEntity) {
                this.setFocus = property;
            }
        }
    }

    private class DelTab
    extends Action2 {
        private Property prop;

        private DelTab(Property prop) {
            this.setText(EditView.resources.getString("action.del", prop.getPropertyName()));
            this.setImage(Images.imgCut);
            this.prop = prop;
        }

        protected void execute() {
            if (BasicEditor.this.currentEntity == null) {
                return;
            }
            BasicEditor.this.gedcom.doMuteUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) {
                    if (BasicEditor.this.ok.isEnabled() && BasicEditor.this.view.isCommitChanges()) {
                        BasicEditor.this.beanPanel.commit();
                    }
                    DelTab.this.prop.getParent().delProperty(DelTab.this.prop);
                }
            });
        }
    }

    private class AddTab
    extends Action2 {
        private MetaProperty meta;
        private Property property;

        private AddTab(MetaProperty meta) {
            this.meta = meta;
            this.setText(meta.getName());
            this.setImage(meta.getImage());
            this.setTip(meta.getInfo());
        }

        protected void execute() {
            if (BasicEditor.this.currentEntity == null) {
                return;
            }
            BasicEditor.this.gedcom.doMuteUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) {
                    if (BasicEditor.this.ok.isEnabled() && BasicEditor.this.view.isCommitChanges()) {
                        BasicEditor.this.beanPanel.commit();
                    }
                    AddTab.this.property = BasicEditor.this.currentEntity.addProperty(AddTab.this.meta.getTag(), "");
                }
            });
            if (BasicEditor.this.beanPanel != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BasicEditor.this.beanPanel.select(AddTab.this.property);
                    }
                });
            }
        }
    }

    private class BeanPanel
    extends JPanel
    implements ChangeListener {
        private Set topLevelTags = new HashSet();
        private List beans = new ArrayList(32);
        private JTabbedPane tabsPane;

        BeanPanel() {
            this.parse(this, BasicEditor.this.currentEntity, BasicEditor.getSharedDescriptor(BasicEditor.this.currentEntity.getMetaProperty()).copy());
        }

        public void removeNotify() {
            this.removeAll();
            BeanFactory factory = BasicEditor.this.view.getBeanFactory();
            Iterator it = this.beans.iterator();
            while (it.hasNext()) {
                PropertyBean bean = (PropertyBean)it.next();
                bean.removeChangeListener(this);
                bean.setProperty(null);
                try {
                    factory.recycle(bean);
                }
                catch (Throwable t) {
                    EditView.LOG.log(Level.WARNING, "Problem cleaning up bean " + bean, t);
                }
            }
            this.beans.clear();
            super.removeNotify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void commit() {
            try {
                Iterator it = this.beans.iterator();
                while (it.hasNext()) {
                    PropertyBean bean = (PropertyBean)it.next();
                    if (!bean.hasChanged() || bean.getProperty() == null) continue;
                    Property prop = bean.getProperty();
                    PropertyProxy proxy = (PropertyProxy)prop.getContaining(class$genj$edit$BasicEditor$PropertyProxy == null ? BasicEditor.class$("genj.edit.BasicEditor$PropertyProxy") : class$genj$edit$BasicEditor$PropertyProxy);
                    if (proxy != null) {
                        prop = proxy.getProxied().setValue(prop.getPathToContaining(proxy), "");
                    }
                    bean.commit(prop);
                }
            }
            finally {
                BasicEditor.this.ok.setEnabled(false);
            }
        }

        void select(Property prop) {
            PropertyBean bean;
            if (prop == null || this.beans.isEmpty()) {
                return;
            }
            Iterator it = this.beans.iterator();
            while (it.hasNext()) {
                bean = (PropertyBean)it.next();
                if (bean.getProperty() != prop) continue;
                bean.requestFocusInWindow();
                return;
            }
            it = this.beans.iterator();
            while (it.hasNext()) {
                bean = (PropertyBean)it.next();
                if (!bean.isDisplayable() || bean.getProperty() == null || !bean.getProperty().isContained(prop)) continue;
                bean.requestFocusInWindow();
                return;
            }
            Component[] cs = this.tabsPane.getComponents();
            for (int i = 0; i < cs.length; ++i) {
                JComponent c = (JComponent)cs[i];
                if (c.getClientProperty(class$genj$gedcom$Property == null ? BasicEditor.class$("genj.gedcom.Property") : class$genj$gedcom$Property) != prop) continue;
                c.requestFocusInWindow();
                return;
            }
            PropertyBean first = (PropertyBean)this.beans.get(0);
            first.requestFocusInWindow();
        }

        public void stateChanged(ChangeEvent e) {
            BasicEditor.this.ok.setEnabled(true);
            BasicEditor.this.cancel.setEnabled(true);
        }

        private void parse(JPanel panel, Property root, NestedBlockLayout descriptor) {
            panel.setLayout(descriptor);
            Iterator cells = descriptor.getCells().iterator();
            while (cells.hasNext()) {
                NestedBlockLayout.Cell cell = (NestedBlockLayout.Cell)cells.next();
                JComponent comp = this.createComponent(root, cell);
                if (comp == null) continue;
                panel.add((Component)comp, cell);
            }
        }

        private JComponent createComponent(Property root, NestedBlockLayout.Cell cell) {
            String element = cell.getElement();
            if ("tabs".equals(element)) {
                this.tabsPane = new ContextTabbedPane();
                Iterator tabs = cell.getNestedLayouts().iterator();
                while (tabs.hasNext()) {
                    NestedBlockLayout tabLayout = (NestedBlockLayout)tabs.next();
                    JPanel tab = new JPanel();
                    this.parse(tab, root, tabLayout);
                    this.tabsPane.addTab("", root.getImage(false), tab);
                }
                this.createTabs(this.tabsPane);
                return this.tabsPane;
            }
            TagPath path = new TagPath(cell.getAttribute("path"));
            MetaProperty meta = root.getMetaProperty().getNestedRecursively(path, false);
            if (cell.getAttribute("ifexists") != null && root.getProperty(path) == null) {
                return null;
            }
            if ("label".equals(element)) {
                JLabel label = path.length() == 1 && path.getLast().equals(BasicEditor.this.currentEntity.getTag()) ? new JLabel(meta.getName() + ' ' + BasicEditor.this.currentEntity.getId(), BasicEditor.this.currentEntity.getImage(false), 2) : new JLabel(meta.getName(cell.isAttribute("plural")), meta.getImage(), 2);
                return label;
            }
            if ("bean".equals(element)) {
                PropertyBean bean = this.createBean(root, path, meta, cell.getAttribute("type"));
                if (bean == null) {
                    return null;
                }
                if (root == BasicEditor.this.currentEntity && path.length() > 1) {
                    this.topLevelTags.add(path.get(1));
                }
                return cell.getAttribute("popup") == null ? bean : new PopupBean(bean);
            }
            throw new IllegalArgumentException("Template element " + cell.getElement() + " is unkown");
        }

        private PropertyBean createBean(Property root, TagPath path, MetaProperty meta, String beanOverride) {
            final Property[] _prop = new Property[1];
            path.iterate(root, new PropertyVisitor(){

                protected boolean leaf(Property leaf) {
                    if (leaf instanceof PropertyXRef) {
                        return true;
                    }
                    _prop[0] = leaf;
                    return false;
                }
            });
            Property prop = _prop[0];
            if (prop == null) {
                prop = new PropertyProxy(root).setValue(path, "");
            }
            BeanFactory factory = BasicEditor.this.view.getBeanFactory();
            PropertyBean bean = beanOverride == null ? factory.get(prop) : factory.get(beanOverride, prop);
            bean.addChangeListener(this);
            this.beans.add(bean);
            return bean;
        }

        private void createTabs(JTabbedPane tabs) {
            HashSet<String> skippedTags = new HashSet<String>();
            int j = BasicEditor.this.currentEntity.getNoOfProperties();
            for (int i = 0; i < j; ++i) {
                Property prop = BasicEditor.this.currentEntity.getProperty(i);
                String tag = prop.getTag();
                if (skippedTags.add(tag) && this.topLevelTags.contains(tag)) continue;
                this.topLevelTags.add(tag);
                this.createTab(prop, tabs);
            }
            JPanel newTab = new JPanel(new FlowLayout(0));
            newTab.setPreferredSize(new Dimension(64, 64));
            tabs.addTab("", Images.imgNew, newTab);
            Object[] nested = BasicEditor.this.currentEntity.getNestedMetaProperties(1);
            Arrays.sort(nested);
            for (int i = 0; i < nested.length; ++i) {
                Object meta = nested[i];
                NestedBlockLayout descriptor = BasicEditor.getSharedDescriptor((MetaProperty)meta);
                if (descriptor == null || descriptor.getCells().isEmpty() || this.topLevelTags.contains(((MetaProperty)meta).getTag()) && ((MetaProperty)meta).isSingleton()) continue;
                newTab.add(new LinkWidget(new AddTab((MetaProperty)meta)));
            }
        }

        private void createTab(Property prop, JTabbedPane tabs) {
            if (prop instanceof PropertyXRef) {
                try {
                    String tt = ((PropertyXRef)prop).getTargetType();
                    if (tt.equals("INDI") || tt.equals("FAM")) {
                        return;
                    }
                }
                catch (IllegalArgumentException e) {
                    return;
                }
                tabs.insertTab(prop.getPropertyName(), prop.getImage(false), BasicEditor.this.view.getBeanFactory().get(prop), prop.getPropertyInfo(), 0);
                return;
            }
            MetaProperty meta = prop.getMetaProperty();
            NestedBlockLayout descriptor = BasicEditor.getSharedDescriptor(meta);
            if (descriptor == null) {
                return;
            }
            JPanel tab = new JPanel();
            tab.putClientProperty(class$genj$gedcom$Property == null ? (class$genj$gedcom$Property = BasicEditor.class$("genj.gedcom.Property")) : class$genj$gedcom$Property, prop);
            this.parse(tab, prop, descriptor.copy());
            tabs.insertTab(meta.getName() + prop.format("{ $y}"), prop.getImage(false), tab, meta.getInfo(), 0);
        }

        private class ContextTabbedPane
        extends JTabbedPane
        implements ContextProvider {
            private ContextTabbedPane() {
                super(1, 0);
            }

            public ViewContext getContext() {
                Component selection = BeanPanel.this.tabsPane.getSelectedComponent();
                Property prop = (Property)((JComponent)selection).getClientProperty(class$genj$gedcom$Property == null ? (class$genj$gedcom$Property = BasicEditor.class$("genj.gedcom.Property")) : class$genj$gedcom$Property);
                if (prop == null) {
                    return null;
                }
                return new ViewContext(prop).addAction(new DelTab(prop));
            }
        }
    }

    private class FocusPolicy
    extends ContainerOrderFocusTraversalPolicy {
        private Hack hack = new Hack();

        private FocusPolicy() {
        }

        protected boolean accept(Component c) {
            return this.hack.accept(c);
        }

        private class Hack
        extends LayoutFocusTraversalPolicy {
            private Hack() {
            }

            protected boolean accept(Component c) {
                return super.accept(c);
            }
        }
    }

    private class Cancel
    extends Action2 {
        private Cancel() {
            this.setText(Action2.TXT_CANCEL);
        }

        protected void execute() {
            BasicEditor.this.ok.setEnabled(false);
            BasicEditor.this.cancel.setEnabled(false);
            BasicEditor.this.setEntity(BasicEditor.this.currentEntity, null);
        }
    }

    private class OK
    extends Action2 {
        private OK() {
            this.setText(Action2.TXT_OK);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void execute() {
            if (BasicEditor.this.beanPanel == null) {
                return;
            }
            try {
                BasicEditor.this.gedcom.removeGedcomListener((GedcomListener)Spin.over(BasicEditor.this.callback));
                BasicEditor.this.gedcom.doMuteUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) {
                        BasicEditor.this.beanPanel.commit();
                    }
                });
            }
            finally {
                BasicEditor.this.gedcom.addGedcomListener((GedcomListener)Spin.over(BasicEditor.this.callback));
            }
            PropertyBean focussedBean = BasicEditor.this.getFocus();
            Property focus = focussedBean != null ? focussedBean.getProperty() : null;
            BasicEditor.this.beanPanel.select(focus);
        }
    }

    private class PopupBean
    extends PopupWidget {
        private PropertyBean wrapped;

        private PopupBean(PropertyBean wrapped) {
            this.wrapped = wrapped;
            wrapped.setAlignmentX(0.0f);
            Property prop = wrapped.getProperty();
            ImageIcon img = prop.getImage(false);
            if (prop.getValue().length() == 0) {
                img = img.getDisabled(50);
            }
            this.setIcon(img);
            this.setToolTipText(prop.getPropertyName());
            this.setFocusable(false);
            this.setBorder(null);
            ArrayList<JComponent> actions = new ArrayList<JComponent>();
            actions.add(new JLabel(prop.getPropertyName()));
            actions.add(wrapped);
            this.setActions(actions);
        }

        public void showPopup() {
            super.showPopup();
            SwingUtilities.getWindowAncestor(this.wrapped).setFocusableWindowState(true);
            this.wrapped.requestFocus();
            this.setIcon(this.wrapped.getProperty().getImage(false));
        }
    }

    private static class PropertyProxy
    extends Property {
        private Property proxied;

        private PropertyProxy(Property prop) {
            this.proxied = prop;
        }

        public Property getProxied() {
            return this.proxied;
        }

        public boolean isContained(Property in) {
            return this.proxied == in ? true : this.proxied.isContained(in);
        }

        public Gedcom getGedcom() {
            return this.proxied.getGedcom();
        }

        public String getValue() {
            throw new IllegalArgumentException();
        }

        public void setValue(String val) {
            throw new IllegalArgumentException();
        }

        public String getTag() {
            return this.proxied.getTag();
        }

        public TagPath getPath() {
            return this.proxied.getPath();
        }

        public MetaProperty getMetaProperty() {
            return this.proxied.getMetaProperty();
        }
    }
}

