/*
 * Decompiled with CFR 0.152.
 */
package genj.edit;

import genj.common.SelectEntityWidget;
import genj.edit.ChoosePropertyBean;
import genj.edit.EditView;
import genj.edit.Editor;
import genj.edit.Images;
import genj.edit.PropertyTreeWidget;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.TagPath;
import genj.gedcom.UnitOfWork;
import genj.io.PropertyReader;
import genj.io.PropertyTransferable;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ButtonHelper;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.TextAreaWidget;
import genj.view.ContextSelectionEvent;
import genj.view.ViewContext;
import genj.window.WindowManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

class AdvancedEditor
extends Editor {
    private static final String ACC_CUT = "ctrl X";
    private static final String ACC_COPY = "ctrl C";
    private static final String ACC_PASTE = "ctrl V";
    private static final Clipboard clipboard = AdvancedEditor.initClipboard();
    private boolean ignoreSelection = false;
    private static Resources resources = Resources.get(AdvancedEditor.class);
    private Gedcom gedcom;
    private PropertyTreeWidget tree = null;
    private JPanel editPane;
    private PropertyBean bean = null;
    private JSplitPane splitPane = null;
    private EditView editView;
    private Action2 ok = new OK();
    private Action2 cancel = new Cancel();
    private Registry registry;
    private InteractionListener callback;

    AdvancedEditor() {
    }

    private static Clipboard initClipboard() {
        try {
            return Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (Throwable t) {
            return new Clipboard("GenJ");
        }
    }

    public void init(Gedcom ged, EditView view, Registry regty) {
        this.gedcom = ged;
        this.editView = view;
        this.registry = regty;
        this.tree = new Tree();
        this.callback = new InteractionListener();
        this.tree.addTreeSelectionListener(this.callback);
        JScrollPane treePane = new JScrollPane(this.tree);
        treePane.setMinimumSize(new Dimension(160, 128));
        treePane.setPreferredSize(new Dimension(160, 128));
        treePane.getHorizontalScrollBar().setFocusable(false);
        treePane.getVerticalScrollBar().setFocusable(false);
        this.editPane = new JPanel(new BorderLayout());
        JScrollPane editScroll = new JScrollPane(this.editPane);
        editScroll.getVerticalScrollBar().setFocusable(false);
        editScroll.getHorizontalScrollBar().setFocusable(false);
        this.splitPane = new JSplitPane(0, treePane, editScroll);
        this.splitPane.setDividerLocation(this.registry.get("divider", -1));
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        this.setFocusTraversalPolicy(new FocusPolicy());
        this.setFocusCycleRoot(true);
        new Cut().install(this.tree, 0);
        new Copy().install(this.tree, 0);
        new Paste().install(this.tree, 0);
    }

    public ViewContext getContext() {
        return this.tree.getContext();
    }

    public void removeNotify() {
        this.registry.put("divider", this.splitPane.getDividerLocation());
        super.removeNotify();
    }

    public void setContext(ViewContext context) {
        Property[] props;
        if (this.ignoreSelection || context.getEntities().length == 0) {
            return;
        }
        this.tree.clearSelection();
        Entity entity = context.getEntity();
        if (entity != this.tree.getRoot()) {
            this.tree.setRoot(entity);
        }
        if ((props = context.getProperties()).length == 0 && entity.getNoOfProperties() > 0) {
            props = new Property[]{entity.getProperty(0)};
        }
        this.tree.setSelection(Arrays.asList(props));
        if (this.bean != null) {
            this.bean.requestFocusInWindow();
        }
    }

    private class Tree
    extends PropertyTreeWidget {
        private Tree() {
            super(AdvancedEditor.this.gedcom);
        }

        public ViewContext getContext() {
            ViewContext result = super.getContext();
            Property[] props = result.getProperties();
            List selection = AdvancedEditor.this.tree.getSelection();
            if (props.length > 0) {
                result.addAction(new Cut(selection));
                result.addAction(new Copy(selection));
            }
            if (selection.size() == 1) {
                result.addAction(new Paste((Property)selection.get(0)));
                result.addAction(Action2.NOOP);
                Property prop = (Property)selection.get(0);
                if (!prop.isTransient()) {
                    result.addAction(new Add(prop));
                    Action2.Group group = new Action2.Group(resources.getString("action.add"));
                    Object[] metas = prop.getNestedMetaProperties(5);
                    Arrays.sort(metas);
                    for (int i = 0; i < metas.length; ++i) {
                        if (!((MetaProperty)metas[i]).isInstantiated()) continue;
                        group.add(new Add(prop, (MetaProperty)metas[i]));
                    }
                    result.addActions(group);
                }
            }
            if (!selection.isEmpty() && !selection.contains(AdvancedEditor.this.tree.getRoot())) {
                result.addAction(new Propagate(selection));
            }
            return result;
        }
    }

    private class FocusPolicy
    extends LayoutFocusTraversalPolicy {
        private FocusPolicy() {
        }

        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            Component result = super.getComponentAfter(focusCycleRoot, aComponent);
            if (result == null) {
                return null;
            }
            if (AdvancedEditor.this.bean != null && !SwingUtilities.isDescendingFrom(result, AdvancedEditor.this.bean)) {
                AdvancedEditor.this.tree.setSelectionRow((AdvancedEditor.this.tree.getSelectionRows()[0] + 1) % AdvancedEditor.this.tree.getRowCount());
            }
            return result;
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            Component result = super.getComponentBefore(focusCycleRoot, aComponent);
            if (result == null) {
                return null;
            }
            if (AdvancedEditor.this.bean != null && !SwingUtilities.isDescendingFrom(result, AdvancedEditor.this.bean)) {
                AdvancedEditor.this.tree.setSelectionRow((AdvancedEditor.this.tree.getSelectionRows()[0] - 1) % AdvancedEditor.this.tree.getRowCount());
            }
            return result;
        }
    }

    private class InteractionListener
    implements TreeSelectionListener,
    ChangeListener {
        private InteractionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void valueChanged(TreeSelectionEvent e) {
            Gedcom gedcom;
            Property root = AdvancedEditor.this.tree.getRoot();
            if (root != null && !(gedcom = root.getGedcom()).isWriteLocked() && AdvancedEditor.this.bean != null && AdvancedEditor.this.ok.isEnabled() && AdvancedEditor.this.editView.isCommitChanges()) {
                AdvancedEditor.this.ok.trigger();
            }
            if (AdvancedEditor.this.bean != null) {
                AdvancedEditor.this.bean.removeChangeListener(this);
                AdvancedEditor.this.editView.getBeanFactory().recycle(AdvancedEditor.this.bean);
            }
            AdvancedEditor.this.bean = null;
            AdvancedEditor.this.editPane.removeAll();
            AdvancedEditor.this.editPane.revalidate();
            AdvancedEditor.this.editPane.repaint();
            Property[] selection = Property.toArray(AdvancedEditor.this.tree.getSelection());
            if (selection.length == 1) {
                Property prop = selection[0];
                try {
                    AdvancedEditor.this.bean = AdvancedEditor.this.editView.getBeanFactory().get(prop);
                    AdvancedEditor.this.editPane.add((Component)AdvancedEditor.this.bean, "Center");
                    JLabel label = new JLabel(Gedcom.getName(prop.getTag()), prop.getImage(false), 2);
                    AdvancedEditor.this.editPane.add((Component)label, "North");
                    if (AdvancedEditor.this.bean.isEditable()) {
                        JPanel buttons = new JPanel(new FlowLayout(2));
                        ButtonHelper bh = new ButtonHelper().setInsets(0).setContainer(buttons);
                        bh.create(AdvancedEditor.this.ok).setFocusable(false);
                        bh.create(AdvancedEditor.this.cancel).setFocusable(false);
                        AdvancedEditor.this.editPane.add((Component)buttons, "South");
                    }
                    AdvancedEditor.this.bean.addChangeListener(this);
                }
                catch (Throwable t) {
                    EditView.LOG.log(Level.WARNING, "Property bean " + AdvancedEditor.this.bean, t);
                }
                AdvancedEditor.this.ok.setEnabled(false);
                AdvancedEditor.this.cancel.setEnabled(false);
            }
            if (selection.length > 0) {
                try {
                    AdvancedEditor.this.ignoreSelection = true;
                    ViewContext context = new ViewContext(AdvancedEditor.this.gedcom);
                    context.addProperties(selection);
                    WindowManager.broadcast(new ContextSelectionEvent(context, AdvancedEditor.this));
                }
                finally {
                    AdvancedEditor.this.ignoreSelection = false;
                }
            }
        }

        public void stateChanged(ChangeEvent e) {
            AdvancedEditor.this.ok.setEnabled(true);
            AdvancedEditor.this.cancel.setEnabled(true);
        }
    }

    private class Cancel
    extends Action2 {
        private Cancel() {
            this.setText(Action2.TXT_CANCEL);
        }

        protected void execute() {
            AdvancedEditor.this.ok.setEnabled(false);
            AdvancedEditor.this.cancel.setEnabled(false);
            List selection = AdvancedEditor.this.tree.getSelection();
            AdvancedEditor.this.tree.clearSelection();
            AdvancedEditor.this.tree.setSelection(selection);
        }
    }

    private class OK
    extends Action2 {
        private OK() {
            this.setText(Action2.TXT_OK);
        }

        protected void execute() {
            Property root = AdvancedEditor.this.tree.getRoot();
            if (root == null) {
                return;
            }
            Gedcom gedcom = root.getGedcom();
            if (AdvancedEditor.this.bean != null) {
                gedcom.doMuteUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) {
                        AdvancedEditor.this.bean.commit();
                    }
                });
            }
            AdvancedEditor.this.ok.setEnabled(false);
            AdvancedEditor.this.cancel.setEnabled(false);
        }
    }

    private class Add
    extends Action2 {
        private Property parent;
        private String[] tags;
        private boolean addDefaults = true;

        protected Add(Property parent, MetaProperty meta) {
            this.parent = parent;
            String txt = meta.getName();
            if (!txt.equals(meta.getTag())) {
                txt = txt + " (" + meta.getTag() + ")";
            }
            this.setText(txt);
            this.setImage(meta.getImage());
            this.tags = new String[]{meta.getTag()};
        }

        protected Add(Property parent) {
            this.parent = parent;
            this.setText(resources.getString("action.add") + " ...");
            this.setImage(Images.imgNew);
        }

        protected void execute() {
            PropertyDate pdate;
            Property newProp;
            if (this.tags == null) {
                JLabel label = new JLabel(resources.getString("add.choose"));
                ChoosePropertyBean choose = new ChoosePropertyBean(this.parent, resources);
                JCheckBox check = new JCheckBox(resources.getString("add.default_too"), this.addDefaults);
                int option = WindowManager.getInstance(AdvancedEditor.this).openDialog("add", resources.getString("add.title"), 3, new JComponent[]{label, choose, check}, Action2.okCancel(), (Component)AdvancedEditor.this);
                if (option != 0) {
                    return;
                }
                this.tags = choose.getSelectedTags();
                this.addDefaults = check.isSelected();
                if (this.tags.length == 0) {
                    WindowManager.getInstance(AdvancedEditor.this).openDialog(null, null, 0, resources.getString("add.must_enter"), Action2.okOnly(), (Component)AdvancedEditor.this);
                    return;
                }
            }
            AdvancedEditor.this.tree.clearSelection();
            final ArrayList newProps = new ArrayList();
            AdvancedEditor.this.gedcom.doMuteUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) {
                    for (int i = 0; i < Add.this.tags.length; ++i) {
                        Property prop = Add.this.parent.addProperty(Add.this.tags[i], "");
                        newProps.add(prop);
                        if (!Add.this.addDefaults) continue;
                        prop.addDefaultProperties();
                    }
                }
            });
            Property property = newProp = newProps.isEmpty() ? null : (Property)newProps.get(0);
            if (newProp instanceof PropertyEvent && (pdate = ((PropertyEvent)newProp).getDate(false)) != null) {
                newProp = pdate;
            }
            AdvancedEditor.this.tree.setSelectionPath(new TreePath(AdvancedEditor.this.tree.getPathFor(newProp)));
            if (AdvancedEditor.this.bean != null) {
                AdvancedEditor.this.bean.requestFocusInWindow();
            }
        }
    }

    private class Paste
    extends Action2 {
        private Property presetParent;

        protected Paste(Property property) {
            this.presetParent = property;
            this.setText(resources.getString("action.paste"));
            this.setImage(Images.imgPaste);
        }

        protected Paste() {
            this.setAccelerator(AdvancedEditor.ACC_PASTE);
        }

        protected void execute() {
            Property parent;
            String content;
            try {
                content = clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor).toString();
            }
            catch (Throwable t) {
                EditView.LOG.log(Level.INFO, "Accessing system clipboard as stringFlavor failed (" + t.getMessage() + ")");
                return;
            }
            if (this.presetParent != null) {
                parent = this.presetParent;
            } else if (AdvancedEditor.this.tree.getSelectionCount() == 1) {
                parent = (Property)AdvancedEditor.this.tree.getSelection().get(0);
            } else {
                return;
            }
            AdvancedEditor.this.gedcom.doMuteUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    PropertyReader reader = new PropertyReader(new StringReader(content), null, true);
                    reader.setMerge(true);
                    try {
                        reader.read(parent);
                    }
                    catch (IOException e) {
                        throw new GedcomException("IO during read()");
                    }
                }
            });
        }
    }

    private class Copy
    extends Action2 {
        protected List presetSelection;

        protected Copy(List preset) {
            this.presetSelection = Property.normalize(preset);
            this.setText(resources.getString("action.copy"));
            this.setImage(Images.imgCopy);
        }

        protected Copy() {
            this.setAccelerator(AdvancedEditor.ACC_COPY);
        }

        protected void execute() {
            List<Property> selection = this.presetSelection;
            if (selection == null) {
                selection = Property.normalize(AdvancedEditor.this.tree.getSelection());
            }
            if (selection.contains(AdvancedEditor.this.tree.getRoot())) {
                selection = Arrays.asList(AdvancedEditor.this.tree.getRoot().getProperties());
            }
            try {
                clipboard.setContents(new PropertyTransferable(selection).getStringTransferable(), null);
            }
            catch (Throwable t) {
                EditView.LOG.log(Level.WARNING, "Couldn't copy properties", t);
            }
        }
    }

    private class Cut
    extends Action2 {
        protected List presetSelection;

        private Cut(List preset) {
            this.presetSelection = Property.normalize(preset);
            super.setImage(Images.imgCut);
            super.setText(resources.getString("action.cut"));
        }

        private Cut() {
            this.setAccelerator(AdvancedEditor.ACC_CUT);
        }

        protected void execute() {
            int rc;
            String veto;
            List selection;
            List list = selection = this.presetSelection != null ? this.presetSelection : Property.normalize(AdvancedEditor.this.tree.getSelection());
            if (selection.isEmpty()) {
                return;
            }
            if (selection.contains(AdvancedEditor.this.tree.getRoot())) {
                selection.clear();
                selection.addAll(Arrays.asList(AdvancedEditor.this.tree.getRoot().getProperties()));
            }
            if ((veto = this.getVeto(selection)).length() > 0 && (rc = WindowManager.getInstance(AdvancedEditor.this).openDialog("cut.warning", resources.getString("action.cut"), 2, veto, new Action[]{new Action2(resources.getString("action.cut")), Action2.cancel()}, (Component)AdvancedEditor.this)) != 0) {
                return;
            }
            try {
                clipboard.setContents(new PropertyTransferable(selection).getStringTransferable(), null);
            }
            catch (Throwable t) {
                EditView.LOG.log(Level.WARNING, "Couldn't copy properties", t);
                return;
            }
            AdvancedEditor.this.gedcom.doMuteUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) {
                    ListIterator props = selection.listIterator();
                    while (props.hasNext()) {
                        Property p = (Property)props.next();
                        p.getParent().delProperty(p);
                    }
                }
            });
        }

        private String getVeto(List properties) {
            StringBuffer result = new StringBuffer();
            ListIterator checks = properties.listIterator();
            while (checks.hasNext()) {
                Property p = (Property)checks.next();
                String veto = p.getDeleteVeto();
                if (veto == null) continue;
                result.append(resources.getString("del.warning", new String[]{p.getPropertyName(), p.getParent().getPropertyName(), veto}));
                result.append("\n");
            }
            return result.toString();
        }
    }

    private class Propagate
    extends Action2 {
        private Entity entity;
        private List properties;
        private String what;

        private Propagate(List selection) {
            this.entity = (Entity)AdvancedEditor.this.tree.getRoot();
            this.properties = Property.normalize(selection);
            if (this.properties.isEmpty()) {
                this.setText(resources.getString("action.propagate", ""));
                this.setEnabled(false);
                return;
            }
            this.what = "'" + Property.getPropertyNames(Property.toArray(this.properties), 5) + "' (" + this.properties.size() + ")";
            this.setText(resources.getString("action.propagate", this.what) + " ...");
        }

        protected void execute() {
            boolean cancel;
            final TextAreaWidget text = new TextAreaWidget("", 4, 10, false, true);
            final SelectEntityWidget select = new SelectEntityWidget(AdvancedEditor.this.gedcom, this.entity.getTag(), resources.getString("action.propagate.toall"));
            select.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Entity target = select.getSelection();
                    String string = target == null ? resources.getString("action.propagate.all", new Object[]{Propagate.this.what, "" + select.getEntityCount(), Gedcom.getName(Propagate.this.entity.getTag())}) : resources.getString("action.propagate.one", new Object[]{Propagate.this.what, target.getId(), Gedcom.getName(target.getTag())});
                    text.setText(string);
                }
            });
            final JCheckBox check = new JCheckBox(resources.getString("action.propagate.value"));
            JPanel panel = new JPanel(new NestedBlockLayout("<col><select wx=\"1\"/><note wx=\"1\" wy=\"1\"/><check wx=\"1\"/></col>"));
            panel.add(select);
            panel.add(new JScrollPane(text));
            panel.add(check);
            select.setSelection(AdvancedEditor.this.gedcom.getEntity(AdvancedEditor.this.registry.get("select." + this.entity.getTag(), (String)null)));
            boolean bl = cancel = 0 != WindowManager.getInstance(AdvancedEditor.this).openDialog("propagate", this.getText(), 2, panel, Action2.okCancel(), (Component)AdvancedEditor.this);
            if (cancel) {
                return;
            }
            final Entity selection = select.getSelection();
            AdvancedEditor.this.registry.put("select." + this.entity.getTag(), selection != null ? selection.getId() : null);
            try {
                AdvancedEditor.this.gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        List<Entity> to = selection != null ? Collections.singletonList(selection) : gedcom.getEntities(Propagate.this.entity.getTag());
                        Iterator it = to.iterator();
                        while (it.hasNext()) {
                            Propagate.this.copy(Propagate.this.properties, Propagate.this.entity, (Entity)it.next(), check.isSelected());
                        }
                    }
                });
            }
            catch (GedcomException e) {
                WindowManager.getInstance(AdvancedEditor.this).openDialog(null, null, 0, e.getMessage(), Action2.okOnly(), (Component)AdvancedEditor.this);
            }
        }

        private void copy(List selection, Entity from, Entity to, boolean values) throws GedcomException {
            if (from == to) {
                return;
            }
            for (int i = 0; i < selection.size(); ++i) {
                Property property = (Property)selection.get(i);
                TagPath path = property.getParent().getPath();
                Property root = to.getProperty(path);
                if (root == null) {
                    root = to.setValue(path, "");
                }
                root.copyProperties(property, values);
            }
        }
    }
}

