/*
 * Decompiled with CFR 0.152.
 */
package genj.common;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyComparator;
import genj.gedcom.TagPath;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.PopupWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;

public class SelectEntityWidget
extends JPanel {
    private static final Resources RESOURCES = Resources.get(SelectEntityWidget.class);
    private String type = "INDI";
    private Object[] list;
    private Object none;
    private PopupWidget sortWidget;
    private JComboBox listWidget;
    private Registry registry = Registry.lookup("genj", null);
    private Sort sort;
    private static final String[] SORTS = new String[]{"INDI:NAME", "INDI", "INDI:BIRT:DATE", "INDI:DEAT:DATE", "FAM", "FAM:MARR:DATE", "OBJE", "OBJE:TITL", "NOTE", "NOTE:NOTE", "SOUR", "SOUR:TITL", "SOUR:AUTH", "SOUR:REPO", "SUBM", "REPO", "REPO:NAME", "REPO:REFN", "REPO:RIN"};

    public SelectEntityWidget(Gedcom gedcom, String type, String none) {
        int e;
        this.type = type;
        this.none = none;
        Collection entities = gedcom.getEntities(type);
        if (none != null) {
            this.list = new Object[entities.size() + 1];
            this.list[0] = none;
        } else {
            this.list = new Object[entities.size()];
        }
        Iterator es = entities.iterator();
        int n = e = none != null ? 1 : 0;
        while (e < this.list.length) {
            Entity ent = (Entity)es.next();
            if (!ent.getTag().equals(type)) {
                throw new IllegalArgumentException("Type of all entities has to be " + type);
            }
            this.list[e] = ent;
            ++e;
        }
        this.sortWidget = new PopupWidget();
        ArrayList<Sort> sorts = new ArrayList<Sort>();
        for (int i = 0; i < SORTS.length; ++i) {
            String path = SORTS[i];
            if (!path.startsWith(type)) continue;
            Sort s = new Sort(path);
            sorts.add(s);
            if (this.sort != null && !path.equals(this.registry.get("select.sort." + type, ""))) continue;
            this.sort = s;
        }
        this.sortWidget.setActions(sorts);
        this.listWidget = new JComboBox();
        this.listWidget.setMaximumRowCount(16);
        this.listWidget.setEditable(false);
        this.listWidget.setRenderer(new Renderer());
        this.setLayout(new BorderLayout());
        this.add("Center", this.listWidget);
        this.add("West", this.sortWidget);
        if (this.sort != null) {
            this.sort.trigger();
        }
        if (this.list.length > 0) {
            this.listWidget.setSelectedIndex(0);
        }
    }

    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(128, super.getPreferredSize().height);
    }

    public int getEntityCount() {
        return this.listWidget.getItemCount() - 1;
    }

    public Entity getSelection() {
        Object item = this.listWidget.getSelectedItem();
        if (!(item instanceof Entity)) {
            return null;
        }
        return (Entity)item;
    }

    public void setSelection(Entity set) {
        if (set == null) {
            this.listWidget.setSelectedItem(this.none != null ? this.none : null);
        }
        if (!(set instanceof Entity) || !set.getTag().equals(this.type)) {
            return;
        }
        this.listWidget.setSelectedItem(set);
    }

    public void addActionListener(ActionListener listener) {
        this.listWidget.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listWidget.removeActionListener(listener);
    }

    private class Sort
    extends Action2 {
        private TagPath tagPath;

        private Sort(String path) {
            this.tagPath = new TagPath(path);
            MetaProperty meta = this.tagPath.length() > 1 && this.tagPath.getLast().equals("DATE") ? Grammar.V55.getMeta(new TagPath(this.tagPath, this.tagPath.length() - 1)) : Grammar.V55.getMeta(this.tagPath);
            this.setImage(meta.getImage());
            this.setText(RESOURCES.getString("select.sort", this.tagPath.length() == 1 ? "ID" : meta.getName()));
        }

        protected void execute() {
            SelectEntityWidget.this.sort = this;
            SelectEntityWidget.this.registry.put("select.sort." + SelectEntityWidget.this.type, this.tagPath.toString());
            PropertyComparator comparator = new PropertyComparator(this.tagPath);
            Arrays.sort(SelectEntityWidget.this.list, SelectEntityWidget.this.none != null ? 1 : 0, SelectEntityWidget.this.list.length, comparator);
            Entity selection = SelectEntityWidget.this.getSelection();
            SelectEntityWidget.this.listWidget.setModel(new DefaultComboBoxModel<Object>(SelectEntityWidget.this.list));
            SelectEntityWidget.this.sortWidget.setIcon(this.getImage());
            SelectEntityWidget.this.sortWidget.setToolTipText(this.getText());
            SelectEntityWidget.this.setSelection(selection);
        }
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String txt = value instanceof Entity ? this.getString((Entity)value) : (value != null ? value.toString() : "");
            return super.getListCellRendererComponent((JList<?>)list, txt, index, isSelected, cellHasFocus);
        }

        private String getString(Entity e) {
            if (SelectEntityWidget.this.sort == null) {
                return e.toString();
            }
            Property p = e.getProperty(SelectEntityWidget.this.sort.tagPath);
            String value = p == e ? e.getId() : (p != null && p.isValid() ? p.getDisplayValue() : "?");
            return value + " / " + e.toString();
        }
    }
}

