/*
 * Decompiled with CFR 0.152.
 */
package genj.common;

import genj.common.PropertyTableModel;
import genj.common.PropertyTableModelListener;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.TagPath;
import genj.renderer.Options;
import genj.renderer.PropertyRenderer;
import genj.util.Dimension2d;
import genj.util.WordBuffer;
import genj.util.swing.Action2;
import genj.util.swing.HeadlessLabel;
import genj.util.swing.LinkWidget;
import genj.util.swing.SortableTableModel;
import genj.view.ContextProvider;
import genj.view.ContextSelectionEvent;
import genj.view.ViewContext;
import genj.window.WindowBroadcastEvent;
import genj.window.WindowBroadcastListener;
import genj.window.WindowManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class PropertyTableWidget
extends JPanel
implements WindowBroadcastListener {
    private static final Logger LOG = Logger.getLogger("genj.common");
    private Table table = new Table();
    private JPanel panelShortcuts;
    static /* synthetic */ Class class$genj$gedcom$Property;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$javax$swing$event$TableModelListener;

    public PropertyTableWidget() {
        this((PropertyTableModel)null);
    }

    public PropertyTableWidget(PropertyTableModel propertyModel) {
        this.setModel(propertyModel);
        this.panelShortcuts = new JPanel();
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.table));
        this.add("East", this.panelShortcuts);
    }

    public TableModel getTableModel() {
        return this.table.getModel();
    }

    public void removeNotify() {
        super.removeNotify();
        this.table.setPropertyModel(null);
    }

    public void setModel(PropertyTableModel set) {
        this.table.setPropertyModel(set);
    }

    public void setAutoResize(boolean on) {
        this.table.setAutoResizeMode(on ? 4 : 0);
    }

    public int getRow(Property property) {
        return this.table.getRow(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleBroadcastEvent(WindowBroadcastEvent event) {
        if (event.isOutbound()) {
            return true;
        }
        ContextSelectionEvent cse = ContextSelectionEvent.narrow(event, this.table.propertyModel.getGedcom());
        if (cse == null) {
            return true;
        }
        try {
            this.table.ignoreSelection = true;
            ViewContext context = cse.getContext();
            Property[] props = context.getProperties();
            if (props.length == 0) {
                ArrayList<Entity> all = new ArrayList<Entity>();
                Entity[] ents = context.getEntities();
                for (int i = 0; i < ents.length; ++i) {
                    all.addAll(ents[i].getProperties(class$genj$gedcom$Property == null ? PropertyTableWidget.class$("genj.gedcom.Property") : class$genj$gedcom$Property));
                    all.add(ents[i]);
                }
                props = Property.toArray(all);
            }
            ListSelectionModel rows = this.table.getSelectionModel();
            ListSelectionModel cols = this.table.getColumnModel().getSelectionModel();
            this.table.clearSelection();
            int r = -1;
            int c = -1;
            for (int i = 0; i < props.length; ++i) {
                Property prop = props[i];
                r = this.getRow(prop.getEntity());
                if (r < 0) continue;
                c = this.table.getCol(r, prop);
                rows.addSelectionInterval(r, r);
                if (c < 0) continue;
                cols.addSelectionInterval(c, c);
            }
            if (r >= 0) {
                Rectangle visible = this.table.getVisibleRect();
                Rectangle scrollto = this.table.getCellRect(r, c, true);
                if (c < 0) {
                    scrollto.x = visible.x;
                }
                this.table.scrollRectToVisible(scrollto);
            }
        }
        finally {
            this.table.ignoreSelection = false;
        }
        return true;
    }

    public String getColumnLayout() {
        SortableTableModel model = (SortableTableModel)this.table.getModel();
        TableColumnModel columns = this.table.getColumnModel();
        List directives = model.getDirectives();
        WordBuffer result = new WordBuffer(",");
        result.append(columns.getColumnCount());
        for (int c = 0; c < columns.getColumnCount(); ++c) {
            result.append(columns.getColumn(c).getWidth());
        }
        for (int d = 0; d < directives.size(); ++d) {
            SortableTableModel.Directive dir = (SortableTableModel.Directive)directives.get(d);
            result.append(dir.getColumn());
            result.append(dir.getDirection());
        }
        return result.toString();
    }

    public void setColumnLayout(String layout) {
        SortableTableModel model = (SortableTableModel)this.table.getModel();
        TableColumnModel columns = this.table.getColumnModel();
        try {
            StringTokenizer tokens = new StringTokenizer(layout, ",");
            int n = Integer.parseInt(tokens.nextToken());
            if (n != model.getColumnCount()) {
                return;
            }
            for (int i = 0; i < n; ++i) {
                TableColumn col = columns.getColumn(i);
                int w = Integer.parseInt(tokens.nextToken());
                col.setWidth(w);
                col.setPreferredWidth(w);
            }
            model.cancelSorting();
            while (tokens.hasMoreTokens()) {
                int c = Integer.parseInt(tokens.nextToken());
                int d = Integer.parseInt(tokens.nextToken());
                model.setSortingStatus(c, d);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public int[] getColumnDirections() {
        SortableTableModel model = (SortableTableModel)this.table.getModel();
        int[] result = new int[model.getColumnCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = model.getSortingStatus(i);
        }
        return result;
    }

    public void setColumnDirections(int[] set) {
        SortableTableModel model = (SortableTableModel)this.table.getModel();
        for (int i = 0; i < set.length && i < model.getColumnCount(); ++i) {
            model.setSortingStatus(i, set[i]);
        }
    }

    private class Table
    extends JTable
    implements ContextProvider,
    ListSelectionListener {
        private PropertyTableModel propertyModel;
        private boolean ignoreSelection = false;
        private SortableTableModel sortableModel = new SortableTableModel();

        Table() {
            this.setPropertyModel(null);
            this.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = PropertyTableWidget.class$("java.lang.Object")) : class$java$lang$Object, new Renderer());
            this.getSelectionModel().setSelectionMode(2);
            this.getColumnModel().setColumnSelectionAllowed(true);
            this.getColumnModel().getSelectionModel().setSelectionMode(2);
            this.getTableHeader().setReorderingAllowed(false);
            this.setRowHeight((int)Math.ceil(Options.getInstance().getDefaultFont().getLineMetrics("", new FontRenderContext(null, false, false)).getHeight()) + this.getRowMargin());
            this.getColumnModel().getSelectionModel().addListSelectionListener(this);
            this.getSelectionModel().addListSelectionListener(this);
            this.setModel(this.sortableModel);
            this.sortableModel.setTableHeader(this.getTableHeader());
            this.setFocusTraversalKeys(0, null);
            this.setFocusTraversalKeys(1, null);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    int row = Table.this.rowAtPoint(e.getPoint());
                    int col = Table.this.columnAtPoint(e.getPoint());
                    if (row < 0 || col < 0) {
                        Table.this.clearSelection();
                    } else if (!Table.this.isCellSelected(row, col)) {
                        Table.this.getSelectionModel().setSelectionInterval(row, row);
                        Table.this.getColumnModel().getSelectionModel().setSelectionInterval(col, col);
                    }
                }
            });
            this.sortableModel.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    if (e.getLastRow() == Integer.MAX_VALUE) {
                        Table.this.createShortcuts();
                    }
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    Table.this.createShortcuts();
                }
            });
        }

        Action2 createShortcut(String txt, final int y, Container container) {
            Action2 shortcut = new Action2(txt.toUpperCase()){

                protected void execute() {
                    int x = 0;
                    try {
                        x = ((JViewport)((PropertyTableWidget)((Table)Table.this).PropertyTableWidget.this).table.getParent()).getViewPosition().x;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    PropertyTableWidget.this.table.scrollRectToVisible(new Rectangle(x, y, 1, Table.this.getParent().getHeight()));
                }
            };
            LinkWidget link = new LinkWidget(shortcut);
            link.setAlignmentX(0.5f);
            link.setBorder(new EmptyBorder(0, 1, 0, 1));
            container.add(link);
            return shortcut;
        }

        void createShortcuts(int col, JComponent container) {
            Property prop;
            TableModel model = this.getModel();
            Collator collator = this.propertyModel.getGedcom().getCollator();
            String cursor = "";
            for (int r = 0; r < model.getRowCount() && !((prop = (Property)model.getValueAt(r, col)) instanceof PropertyDate); ++r) {
                String value;
                if (prop == null || (value = prop.getDisplayValue().trim()).length() == 0 || collator.compare(cursor, value = value.substring(0, 1).toLowerCase()) >= 0) continue;
                cursor = value;
                Action2 shortcut = this.createShortcut(value, ((PropertyTableWidget)PropertyTableWidget.this).table.getCellRect((int)r, (int)col, (boolean)true).y, container);
                InputMap imap = container.getInputMap(2);
                ActionMap amap = container.getActionMap();
                imap.put(KeyStroke.getKeyStroke(value.charAt(0)), shortcut);
                amap.put(shortcut, shortcut);
            }
        }

        void createShortcuts() {
            PropertyTableWidget.this.panelShortcuts.removeAll();
            PropertyTableWidget.this.panelShortcuts.setLayout(new BoxLayout(PropertyTableWidget.this.panelShortcuts, 1));
            PropertyTableWidget.this.panelShortcuts.getInputMap(2).clear();
            PropertyTableWidget.this.panelShortcuts.getActionMap().clear();
            PropertyTableWidget.this.panelShortcuts.revalidate();
            PropertyTableWidget.this.panelShortcuts.repaint();
            if (!this.sortableModel.isSorting()) {
                return;
            }
            SortableTableModel.Directive directive = (SortableTableModel.Directive)this.sortableModel.getDirectives().get(0);
            if (directive.getDirection() <= 0) {
                return;
            }
            this.createShortcuts(directive.getColumn(), PropertyTableWidget.this.panelShortcuts);
        }

        int getCol(int row, Property property) {
            TableModel model = this.getModel();
            int j = model.getColumnCount();
            for (int i = 0; i < j; ++i) {
                if (model.getValueAt(row, i) != property) continue;
                return i;
            }
            return -1;
        }

        int getRow(Property property) {
            if (this.propertyModel == null) {
                return -1;
            }
            SortableTableModel model = (SortableTableModel)this.getModel();
            for (int i = 0; i < model.getRowCount(); ++i) {
                if (this.propertyModel.getProperty(model.modelIndex(i)) != property) continue;
                return i;
            }
            return -1;
        }

        void setPropertyModel(PropertyTableModel propertyModel) {
            this.propertyModel = propertyModel;
            this.sortableModel.setTableModel(new Model(propertyModel));
        }

        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (this.ignoreSelection || e.getValueIsAdjusting()) {
                return;
            }
            Context context = null;
            ListSelectionModel rows = this.getSelectionModel();
            ListSelectionModel cols = this.getColumnModel().getSelectionModel();
            for (int r = rows.getMinSelectionIndex(); r <= rows.getMaxSelectionIndex(); ++r) {
                for (int c = cols.getMinSelectionIndex(); c <= cols.getMaxSelectionIndex(); ++c) {
                    if (!rows.isSelectedIndex(r) || !cols.isSelectedIndex(c)) continue;
                    SortableTableModel model = (SortableTableModel)this.getModel();
                    if (r < 0 || r >= model.getRowCount() || c < 0 || c >= model.getColumnCount()) continue;
                    Property prop = (Property)this.getValueAt(r, c);
                    if (prop == null) {
                        prop = this.propertyModel.getProperty(model.modelIndex(r));
                    }
                    if (context == null) {
                        context = new ViewContext(prop);
                        continue;
                    }
                    context.addProperty(prop);
                }
            }
            if (context != null) {
                WindowManager.broadcast(new ContextSelectionEvent((ViewContext)context, this));
            }
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public ViewContext getContext() {
            Gedcom ged = this.propertyModel.getGedcom();
            if (ged == null) {
                return null;
            }
            SortableTableModel model = (SortableTableModel)this.getModel();
            ViewContext result = new ViewContext(ged);
            int[] rows = this.getSelectedRows();
            if (rows.length > 0) {
                int[] cols = this.getSelectedColumns();
                for (int r = 0; r < rows.length; ++r) {
                    boolean rowRepresented = false;
                    for (int c = 0; c < cols.length; ++c) {
                        Property p = (Property)this.getValueAt(rows[r], cols[c]);
                        if (p == null) continue;
                        result.addProperty(p);
                        rowRepresented = true;
                    }
                    if (rowRepresented) continue;
                    result.addProperty(this.propertyModel.getProperty(model.modelIndex(rows[r])));
                }
            }
            return result;
        }

        private class Renderer
        extends HeadlessLabel
        implements TableCellRenderer {
            private int RENDERER_PREFERENCE = 2;
            private Property curProp;
            private JTable curTable;
            private boolean isSelected;

            Renderer() {
                this.setFont(Options.getInstance().getDefaultFont());
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focs, int row, int col) {
                this.curProp = (Property)value;
                this.curTable = table;
                this.isSelected = selected;
                return this;
            }

            public Dimension getPreferredSize() {
                if (this.curProp == null) {
                    return new Dimension(0, 0);
                }
                return Dimension2d.getDimension(PropertyRenderer.get(this.curProp).getSize(this.getFont(), new FontRenderContext(null, false, false), this.curProp, this.RENDERER_PREFERENCE, Options.getInstance().getDPI()));
            }

            public void paint(Graphics g) {
                Graphics2D graphics = (Graphics2D)g;
                Rectangle bounds = this.getBounds();
                bounds.x = 0;
                bounds.y = 0;
                if (this.isSelected) {
                    g.setColor(this.curTable.getSelectionBackground());
                    g.fillRect(0, 0, bounds.width, bounds.height);
                    g.setColor(this.curTable.getSelectionForeground());
                } else {
                    g.setColor(this.curTable.getForeground());
                }
                if (this.curProp == null) {
                    return;
                }
                g.setFont(this.getFont());
                PropertyRenderer proxy = PropertyRenderer.get(this.curProp);
                ++bounds.x;
                bounds.width -= 2;
                proxy.render(graphics, bounds, this.curProp, this.RENDERER_PREFERENCE, Options.getInstance().getDPI());
            }
        }

        private class Model
        extends AbstractTableModel
        implements PropertyTableModelListener {
            private PropertyTableModel model;
            private Property[][] cells;

            private Model(PropertyTableModel set) {
                this.model = set;
            }

            private Gedcom getGedcom() {
                return this.model != null ? this.model.getGedcom() : null;
            }

            public void handleRowsAdded(PropertyTableModel model, int rowStart, int rowEnd) {
                int rows = model.getNumRows();
                int cols = model.getNumCols();
                this.cells = new Property[rows][cols];
                this.fireTableRowsInserted(rowStart, rowEnd);
            }

            public void handleRowsDeleted(PropertyTableModel model, int rowStart, int rowEnd) {
                int rows = model.getNumRows();
                int cols = model.getNumCols();
                this.cells = new Property[rows][cols];
                this.fireTableRowsDeleted(rowStart, rowEnd);
            }

            public void handleRowsChanged(PropertyTableModel model, int rowStart, int rowEnd, int col) {
                for (int i = rowStart; i <= rowEnd; ++i) {
                    this.cells[i][col] = null;
                }
                this.fireTableChanged(new TableModelEvent(this, rowStart, rowEnd, col));
            }

            public void addTableModelListener(TableModelListener l) {
                super.addTableModelListener(l);
                if (this.model != null && this.getListeners(class$javax$swing$event$TableModelListener == null ? (class$javax$swing$event$TableModelListener = PropertyTableWidget.class$("javax.swing.event.TableModelListener")) : class$javax$swing$event$TableModelListener).length == 1) {
                    this.model.addListener(this);
                }
            }

            public void removeTableModelListener(TableModelListener l) {
                super.removeTableModelListener(l);
                if (this.model != null && this.getListeners(class$javax$swing$event$TableModelListener == null ? (class$javax$swing$event$TableModelListener = PropertyTableWidget.class$("javax.swing.event.TableModelListener")) : class$javax$swing$event$TableModelListener).length == 0) {
                    this.model.removeListener(this);
                }
            }

            public String getColumnName(int col) {
                return this.model != null ? this.model.getName(col) : "";
            }

            public int getColumnCount() {
                return this.model != null ? this.model.getNumCols() : 0;
            }

            public int getRowCount() {
                return this.model != null ? this.model.getNumRows() : 0;
            }

            private TagPath getPath(int col) {
                return this.model != null ? this.model.getPath(col) : null;
            }

            private Context getContextAt(int row, int col) {
                if (this.model == null) {
                    return null;
                }
                Property prop = this.getPropertyAt(row, col);
                if (prop != null) {
                    return new Context(prop);
                }
                Property root = this.model.getProperty(row);
                if (root != null) {
                    return new Context(root.getEntity());
                }
                return new Context(this.model.getGedcom());
            }

            private Property getPropertyAt(int row, int col) {
                Property prop;
                if (this.cells == null) {
                    this.cells = new Property[this.model.getNumRows()][this.model.getNumCols()];
                }
                if ((prop = this.cells[row][col]) == null) {
                    this.cells[row][col] = prop = this.model.getProperty(row).getProperty(this.model.getPath(col));
                }
                return prop;
            }

            public Object getValueAt(int row, int col) {
                return this.getPropertyAt(row, col);
            }

            private Property getProperty(int row) {
                return this.model.getProperty(row);
            }
        }
    }
}

