/*
 * Decompiled with CFR 0.152.
 */
package genj.common;

import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.TagPath;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class PathTreeWidget
extends JScrollPane {
    private List listeners = new ArrayList();
    private Gedcom gedcom;
    private JTree tree;
    private Model model = new Model();

    public PathTreeWidget() {
        this.tree = new JTree(this.model);
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new Renderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addMouseListener(new Selector());
        this.setMinimumSize(new Dimension(160, 160));
        this.setPreferredSize(new Dimension(160, 160));
        this.getViewport().setView(this.tree);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void expandRows() {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    private void fireSelectionChanged(TagPath path, boolean on) {
        Listener[] ls = this.listeners.toArray(new Listener[this.listeners.size()]);
        for (int l = 0; l < ls.length; ++l) {
            ls[l].handleSelection(path, on);
        }
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void setPaths(TagPath[] paths, TagPath[] selection) {
        this.model.setPaths(paths, selection);
        this.expandRows();
    }

    public TagPath[] getSelection() {
        return this.model.getSelection().toArray(new TagPath[0]);
    }

    private class Selector
    extends MouseAdapter {
        private Selector() {
        }

        public void mousePressed(MouseEvent me) {
            TreePath path = PathTreeWidget.this.tree.getPathForLocation(me.getX(), me.getY());
            if (path == null) {
                return;
            }
            PathTreeWidget.this.model.toggleSelection((TagPath)path.getLastPathComponent());
        }
    }

    public static interface Listener {
        public void handleSelection(TagPath var1, boolean var2);
    }

    private class Model
    implements TreeModel {
        private TagPath[] paths = new TagPath[0];
        private Set selection = new HashSet();
        private Map path2childen = new HashMap();
        private List tmlisteners = new ArrayList();

        private Model() {
        }

        public void setPaths(TagPath[] ps, TagPath[] ss) {
            this.selection = new HashSet<TagPath>(Arrays.asList(ss));
            this.paths = ps;
            TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{this});
            TreeModelListener[] ls = this.getListenerSnapshot();
            for (int l = 0; l < ls.length; ++l) {
                ls[l].treeStructureChanged(e);
            }
        }

        private void toggleSelection(TagPath path) {
            boolean removed = this.selection.remove(path);
            if (!removed) {
                this.selection.add(path);
            }
            PathTreeWidget.this.fireSelectionChanged(path, !removed);
            TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{this});
            TreeModelListener[] ls = this.getListenerSnapshot();
            for (int l = 0; l < ls.length; ++l) {
                ls[l].treeNodesChanged(e);
            }
        }

        private TreeModelListener[] getListenerSnapshot() {
            return this.tmlisteners.toArray(new TreeModelListener[PathTreeWidget.this.listeners.size()]);
        }

        public void addTreeModelListener(TreeModelListener l) {
            this.tmlisteners.add(l);
        }

        public void removeTreeModelListener(TreeModelListener l) {
            this.tmlisteners.remove(l);
        }

        public Object getChild(Object parent, int index) {
            return this.getChildren(parent)[index];
        }

        public int getChildCount(Object parent) {
            return this.getChildren(parent).length;
        }

        private TagPath[] getChildren(Object node) {
            TagPath[] result = (TagPath[])this.path2childen.get(node);
            if (result == null) {
                result = node == this ? this.getChildrenOfRoot() : this.getChildrenOfNode((TagPath)node);
            }
            return result;
        }

        private TagPath[] getChildrenOfNode(TagPath path) {
            ArrayList children = new ArrayList(8);
            for (int p = 0; p < this.paths.length; ++p) {
                if (this.paths[p].length() <= path.length() || !this.paths[p].startsWith(path)) continue;
                this.add(new TagPath(this.paths[p], path.length() + 1), children);
            }
            Iterator ss = this.selection.iterator();
            while (ss.hasNext()) {
                TagPath sel = (TagPath)ss.next();
                if (sel.length() <= path.length() || !sel.startsWith(path)) continue;
                this.add(new TagPath(sel, path.length() + 1), children);
            }
            return TagPath.toArray(children);
        }

        private TagPath[] getChildrenOfRoot() {
            ArrayList children = new ArrayList(8);
            for (int p = 0; p < this.paths.length; ++p) {
                this.add(new TagPath(this.paths[p], 1), children);
            }
            Iterator ss = this.selection.iterator();
            while (ss.hasNext()) {
                this.add(new TagPath((TagPath)ss.next(), 1), children);
            }
            return TagPath.toArray(children);
        }

        private void add(TagPath path, List list) {
            if (!list.contains(path)) {
                list.add(path);
            }
        }

        public int getIndexOfChild(Object parent, Object child) {
            return 0;
        }

        public Object getRoot() {
            return this;
        }

        public boolean isLeaf(Object node) {
            return this.getChildren(node).length == 0;
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        public Collection getSelection() {
            return this.selection;
        }
    }

    private class Renderer
    extends DefaultTreeCellRenderer {
        private JPanel panel = new JPanel();
        private JCheckBox checkbox = new JCheckBox();

        private Renderer() {
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this.checkbox, "West");
            this.panel.add((Component)this, "Center");
            this.checkbox.setOpaque(false);
            this.panel.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof TagPath) {
                TagPath path = (TagPath)value;
                this.setText(path.getLast());
                this.setIcon(Grammar.V55.getMeta(path).getImage());
                this.checkbox.setSelected(PathTreeWidget.this.model.getSelection().contains(value));
                this.panel.invalidate();
            }
            return this.panel;
        }
    }
}

