/*
 * Decompiled with CFR 0.152.
 */
package genj.common;

import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.Property;
import genj.view.ContextProvider;
import genj.view.ContextSelectionEvent;
import genj.view.ViewContext;
import genj.window.WindowManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import spin.Spin;

public class ContextListWidget
extends JList
implements ContextProvider {
    private Gedcom ged;
    private Callback callback = new Callback();

    public ContextListWidget(Gedcom gedcom) {
        super(new Model());
        this.ged = gedcom;
        this.setSelectionMode(2);
        this.setCellRenderer(this.callback);
        this.addListSelectionListener(this.callback);
    }

    public ContextListWidget(Gedcom gedcom, List contextList) {
        this(gedcom);
        this.setContextList(contextList);
    }

    public ViewContext getContext() {
        Object[] selection = this.getSelectedValues();
        if (selection.length == 1 && selection[0] instanceof ViewContext) {
            return (ViewContext)selection[0];
        }
        ViewContext result = new ViewContext(this.ged);
        for (int i = 0; i < selection.length; ++i) {
            Context context = (Context)selection[i];
            result.addContext(context);
        }
        return result;
    }

    public void addNotify() {
        super.addNotify();
        this.ged.addGedcomListener((GedcomListener)Spin.over(this.getModel()));
    }

    public void removeNotify() {
        this.ged.removeGedcomListener((GedcomListener)Spin.over(this.getModel()));
        super.removeNotify();
    }

    public void setContextList(List contextList) {
        ((Model)this.getModel()).setContextList(contextList);
    }

    public void setModel(ListModel model) {
        if (!(model instanceof Model)) {
            throw new IllegalArgumentException("setModel() n/a");
        }
        super.setModel(model);
    }

    public void setListData(Object[] listData) {
        throw new IllegalArgumentException("setListData() n/a");
    }

    public void setListData(Vector listData) {
        throw new IllegalArgumentException("setListData() n/a");
    }

    private class Callback
    extends DefaultListCellRenderer
    implements ListSelectionListener {
        private Callback() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ViewContext context = ContextListWidget.this.getContext();
            if (context != null) {
                WindowManager.broadcast(new ContextSelectionEvent(context, ContextListWidget.this));
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, (Object)null, index, isSelected, cellHasFocus);
            Context ctx = (Context)value;
            this.setIcon(ctx.getImage());
            this.setText(ctx.getText());
            return this;
        }
    }

    private static class Model
    extends AbstractListModel
    implements GedcomListener {
        private List list = new ArrayList();

        private Model() {
        }

        private void setContextList(List set) {
            int n = this.list.size();
            this.list.clear();
            if (n > 0) {
                this.fireIntervalRemoved(this, 0, n - 1);
            }
            this.list.addAll(set);
            n = this.list.size();
            if (n > 0) {
                this.fireIntervalAdded(this, 0, n - 1);
            }
        }

        public int getSize() {
            return this.list.size();
        }

        public Object getElementAt(int index) {
            return this.list.get(index);
        }

        public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        }

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                Context context = (Context)it.next();
                context.removeEntities(Collections.singletonList(entity));
            }
            this.fireContentsChanged(this, 0, this.list.size());
        }

        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
        }

        public void gedcomPropertyChanged(Gedcom gedcom, Property prop) {
            this.fireContentsChanged(this, 0, this.list.size());
        }

        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property removed) {
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                Context context = (Context)it.next();
                context.removeProperties(Collections.singletonList(removed));
            }
            this.fireContentsChanged(this, 0, this.list.size());
        }
    }
}

