/*
 * Decompiled with CFR 0.152.
 */
package genj.common;

import genj.common.PropertyTableModel;
import genj.common.PropertyTableModelListener;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.Property;
import java.util.ArrayList;
import java.util.List;
import spin.Spin;

public abstract class AbstractPropertyTableModel
implements PropertyTableModel,
GedcomListener {
    private List listeners = new ArrayList(3);
    private Gedcom gedcom = null;
    private GedcomListener callback;

    public void addListener(PropertyTableModelListener listener) {
        this.listeners.add(listener);
        if (this.listeners.size() == 1) {
            if (this.gedcom == null) {
                this.gedcom = this.getGedcom();
            }
            this.gedcom.addGedcomListener((GedcomListener)Spin.over(this));
        }
    }

    public void removeListener(PropertyTableModelListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.gedcom.removeGedcomListener((GedcomListener)Spin.over(this));
        }
    }

    public String getName(int col) {
        return this.getPath(col).getName();
    }

    protected void fireRowsChanged(int rowStart, int rowEnd, int col) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((PropertyTableModelListener)this.listeners.get(i)).handleRowsChanged(this, rowStart, rowEnd, col);
        }
    }

    protected void fireRowsAdded(int rowStart, int rowEnd) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((PropertyTableModelListener)this.listeners.get(i)).handleRowsAdded(this, rowStart, rowEnd);
        }
    }

    protected void fireRowsDeleted(int rowStart, int rowEnd) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((PropertyTableModelListener)this.listeners.get(i)).handleRowsDeleted(this, rowStart, rowEnd);
        }
    }

    public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
    }

    public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
    }

    public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
    }

    public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
    }

    public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property deleted) {
    }
}

