/*
 * Decompiled with CFR 0.152.
 */
package genj.chart;

import genj.chart.IndexedSeries;
import genj.chart.XYSeries;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Paint;
import java.text.NumberFormat;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;

public class Chart
extends JPanel {
    private void init(String title, Plot plot, boolean legend) {
        this.setLayout(new BorderLayout());
        ChartPanel panel = new ChartPanel(new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, plot, legend));
        panel.setHorizontalZoom(true);
        panel.setVerticalZoom(true);
        this.add((Component)panel, "Center");
    }

    public Chart(String title, String labelAxisX, String labelAxisY, IndexedSeries[] series, NumberFormat format, boolean stacked) {
        NumberAxis xAxis = new NumberAxis(labelAxisX);
        xAxis.setAutoRangeIncludesZero(false);
        NumberAxis yAxis = new NumberAxis(labelAxisY);
        yAxis.setNumberFormatOverride(format);
        StackedXYAreaRenderer renderer = stacked ? new StackedXYAreaRenderer() : new XYAreaRenderer();
        XYPlot plot = new XYPlot((XYDataset)IndexedSeries.asTableXYDataset(series), (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        this.init(title, (Plot)plot, true);
    }

    public Chart(String title, String labelAxisX, String labelAxisY, XYSeries[] series, NumberFormat format, boolean shapes) {
        NumberAxis xAxis = new NumberAxis(labelAxisX);
        xAxis.setAutoRangeIncludesZero(false);
        NumberAxis yAxis = new NumberAxis(labelAxisY);
        yAxis.setNumberFormatOverride(format);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(shapes ? 3 : 2);
        XYPlot plot = new XYPlot(XYSeries.toXYDataset(series), (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        this.init(title, (Plot)plot, true);
    }

    public Chart(String title, IndexedSeries series, String[] categories, boolean legend) {
        PiePlot plot = new PiePlot(IndexedSeries.asPieDataset(series, categories));
        plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieItemLabelGenerator());
        plot.setInsets(new Insets(0, 5, 5, 5));
        this.init(title, (Plot)plot, legend);
    }

    public Chart(String title, String labelCatAxis, IndexedSeries[] series, String[] categories, NumberFormat format, boolean isStacked, boolean isVertical) {
        CategoryAxis categoryAxis = new CategoryAxis(labelCatAxis);
        NumberAxis valueAxis = new NumberAxis();
        valueAxis.setNumberFormatOverride(format);
        Object renderer = isStacked ? new StackedBarRenderer() : new BarRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.BLUE);
        renderer.setSeriesPaint(1, (Paint)Color.RED);
        CategoryPlot plot = new CategoryPlot(IndexedSeries.asCategoryDataset(series, categories), categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(!isVertical ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL);
        this.init(title, (Plot)plot, true);
    }
}

