/*
 * Decompiled with CFR 0.152.
 */
package genj.applet;

import genj.gedcom.Gedcom;
import genj.util.GridBagHelper;
import genj.util.MnemonicAndText;
import genj.util.WordBuffer;
import genj.util.swing.Action2;
import genj.util.swing.LinkWidget;
import genj.view.ViewFactory;
import genj.view.ViewManager;
import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ControlCenter
extends JPanel {
    private ViewManager viewManager;
    private Gedcom gedcom;

    public ControlCenter(ViewManager vmanager, Gedcom ged) {
        this.viewManager = vmanager;
        this.gedcom = ged;
        GridBagHelper gh = new GridBagHelper(this);
        gh.add(this.getHeaderPanel(), 1, 1);
        gh.add(this.getLinkPanel(), 1, 2);
        this.setBackground(Color.white);
    }

    private JPanel getHeaderPanel() {
        JPanel p = new JPanel(new GridLayout(2, 1));
        p.setOpaque(false);
        p.add(new JLabel(this.gedcom.getOrigin().getFileName(), 0));
        WordBuffer words = new WordBuffer();
        words.append(this.gedcom.getEntities("INDI").size() + " " + Gedcom.getName("INDI", true));
        words.append(this.gedcom.getEntities("FAM").size() + " " + Gedcom.getName("FAM", true));
        p.add(new JLabel(words.toString(), 0));
        return p;
    }

    private JPanel getLinkPanel() {
        ViewFactory[] vfactories = this.viewManager.getFactories();
        JPanel p = new JPanel(new GridLayout(vfactories.length, 1));
        p.setOpaque(false);
        for (int v = 0; v < vfactories.length; ++v) {
            p.add(new LinkWidget(new ActionView(vfactories[v])));
        }
        return p;
    }

    private class ActionView
    extends Action2 {
        private ViewFactory factory;

        private ActionView(ViewFactory vfactory) {
            this.factory = vfactory;
            this.setText(new MnemonicAndText(vfactory.getTitle(false)).getText());
            this.setImage(vfactory.getImage());
        }

        protected void execute() {
            ControlCenter.this.viewManager.openView(ControlCenter.this.gedcom, this.factory);
        }
    }
}

