/*
 * Decompiled with CFR 0.152.
 */
package genj.applet;

import genj.Version;
import genj.applet.ControlCenter;
import genj.gedcom.Gedcom;
import genj.io.GedcomReader;
import genj.option.OptionProvider;
import genj.util.EnvironmentChecker;
import genj.util.Origin;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.Trackable;
import genj.util.swing.Action2;
import genj.util.swing.ProgressWidget;
import genj.view.ViewManager;
import genj.window.DefaultWindowManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class Applet
extends java.applet.Applet {
    private static final Resources RESOURCES = Resources.get(Applet.class);
    private static final Logger LOG = Logger.getLogger("genj");
    private static final String[] FACTORIES = new String[]{"genj.table.TableViewFactory", "genj.tree.TreeViewFactory", "genj.timeline.TimelineViewFactory", "genj.edit.EditViewFactory", "genj.nav.NavigatorViewFactory", "genj.entity.EntityViewFactory", "genj.search.SearchViewFactory"};
    private static final String[] OPTIONPROVIDERS = new String[]{"genj.gedcom.Options", "genj.renderer.Options"};
    private boolean isInitialized = false;
    private static final String[] S404FIX = new String[]{"javax.xml.parsers.SAXParserFactory", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl", "javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", "javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl", "com.sun.org.apache.xalan.internal.xsltc.dom.XSLTCDTMManager", "com.sun.org.apache.xalan.internal.xsltc.dom.XSLTCDTMManager"};

    public String getAppletInfo() {
        return "GenealogyJ " + Version.getInstance().getBuildString();
    }

    public void init() {
        URL url;
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        if (this.getParameter("404FIX") != null) {
            try {
                int i = 0;
                while (i < S404FIX.length) {
                    System.setProperty(S404FIX[i++], S404FIX[i++]);
                }
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Couldn't apply 404FIX", t);
            }
        }
        LOG.info(this.getAppletInfo());
        EnvironmentChecker.log();
        this.setLayout(new BorderLayout());
        String gedcom = this.getParameter("gedcom");
        if (gedcom == null) {
            this.log(RESOURCES.getString("applet.missing"));
            return;
        }
        try {
            this.log("document base=" + this.getDocumentBase());
            this.log("gedcom=" + gedcom);
            url = new URL(this.getDocumentBase(), gedcom);
        }
        catch (MalformedURLException e) {
            this.log(RESOURCES.getString("applet.missing"));
            return;
        }
        this.log(RESOURCES.getString("applet.loading", url));
        new Init(url).trigger();
    }

    private void log(String msg) {
        this.showStatus(msg);
        LOG.info(msg);
    }

    private class Init
    extends Action2
    implements Trackable {
        private URL url;
        private GedcomReader reader;
        private Gedcom gedcom;
        private Registry registry;
        private Throwable throwable;

        private Init(URL url) {
            this.url = url;
            this.setAsync(1);
        }

        protected boolean preExecute() {
            this.throwable = null;
            ProgressWidget progress = new ProgressWidget(this, this.getThread());
            progress.setBackground(Applet.this.getBackground());
            Applet.this.removeAll();
            Applet.this.add("North", new JLabel(Applet.this.getAppletInfo()));
            Applet.this.add("Center", progress);
            return true;
        }

        protected void execute() {
            try {
                Origin origin = Origin.create(this.url);
                try {
                    this.registry = new Registry(origin.open("genj.properties"));
                    OptionProvider.setOptionProviders(OPTIONPROVIDERS);
                    OptionProvider.getAllOptions(this.registry);
                }
                catch (Throwable t) {
                    LOG.log(Level.INFO, "Couldn't load genj.properties from " + origin + " (" + t.getMessage() + ")");
                    this.registry = new Registry();
                }
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.reader = new GedcomReader(origin);
                this.reader.setPassword("PASSWORD_UNKNOWN");
                this.gedcom = this.reader.read();
                Thread.sleep(100L);
            }
            catch (Throwable t) {
                this.throwable = t;
                LOG.log(Level.SEVERE, "Encountered throwable", this.throwable);
            }
        }

        protected void postExecute(boolean preExecuteResult) {
            DefaultWindowManager winMgr = new DefaultWindowManager(this.registry, Gedcom.getImage());
            if (this.throwable != null) {
                Action[] actions = new Action[]{new Action2("Retry"), Action2.cancel()};
                String msg = RESOURCES.getString(this.throwable instanceof FileNotFoundException ? "applet.404" : "applet.ioerror", this.url);
                int rc = winMgr.openDialog(null, "Error", 0, msg, actions, (Component)Applet.this);
                if (rc == 0) {
                    this.trigger();
                }
            } else {
                Applet.this.log(RESOURCES.getString("applet.ready"));
                ViewManager vmanager = new ViewManager(winMgr, FACTORIES);
                Applet.this.removeAll();
                Applet.this.add("Center", new ControlCenter(vmanager, this.gedcom));
                Applet.this.invalidate();
                Applet.this.validate();
                Applet.this.repaint();
            }
        }

        public void cancelTrackable() {
            if (this.reader != null) {
                this.reader.cancelTrackable();
            }
        }

        public int getProgress() {
            return this.reader != null ? this.reader.getProgress() : 0;
        }

        public String getState() {
            return this.reader != null ? this.reader.getState() : RESOURCES.getString("applet.connecting");
        }
    }
}

