/*
 * Decompiled with CFR 0.152.
 */
package genj.app;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.TagPath;
import genj.gedcom.time.PointInTime;
import genj.io.Filter;
import genj.util.Resources;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.DateWidget;
import genj.util.swing.TextFieldWidget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

class SaveOptionsWidget
extends JTabbedPane {
    private JCheckBox[] checkEntities = new JCheckBox[Gedcom.ENTITIES.length];
    private JCheckBox[] checkFilters;
    private JTextField textTags;
    private JTextField textValues;
    private TextFieldWidget textPassword;
    private JComboBox comboEncodings;
    private JCheckBox checkFilterEmpties;
    private Resources resources = Resources.get(this);
    private DateWidget dateEventsAfter;
    private DateWidget dateBirthsAfter;
    private Filter[] filters;

    SaveOptionsWidget(Gedcom gedcom, Filter[] filters) {
        Box options = new Box(1);
        options.add(new JLabel(this.resources.getString("save.options.encoding")));
        this.comboEncodings = new ChoiceWidget(Gedcom.ENCODINGS, "ANSEL");
        this.comboEncodings.setEditable(false);
        this.comboEncodings.setSelectedItem(gedcom.getEncoding());
        options.add(this.comboEncodings);
        options.add(new JLabel(this.resources.getString("save.options.password")));
        this.textPassword = new TextFieldWidget(gedcom.hasPassword() ? gedcom.getPassword() : "", 10);
        this.textPassword.setEditable(gedcom.getPassword() != "PASSWORD_UNKNOWN");
        options.add(this.textPassword);
        Box types = new Box(1);
        for (int t = 0; t < Gedcom.ENTITIES.length; ++t) {
            this.checkEntities[t] = new JCheckBox(Gedcom.getName(Gedcom.ENTITIES[t], true), true);
            types.add(this.checkEntities[t]);
        }
        Box props = new Box(1);
        props.add(new JLabel(this.resources.getString("save.options.exclude.tags")));
        this.textTags = new TextFieldWidget(this.resources.getString("save.options.exclude.tags.eg"), 10).setTemplate(true);
        props.add(this.textTags);
        props.add(new JLabel(this.resources.getString("save.options.exclude.values")));
        this.textValues = new TextFieldWidget(this.resources.getString("save.options.exclude.values.eg"), 10).setTemplate(true);
        props.add(this.textValues);
        props.add(new JLabel(this.resources.getString("save.options.exclude.events")));
        this.dateEventsAfter = new DateWidget();
        props.add(this.dateEventsAfter);
        props.add(new JLabel(this.resources.getString("save.options.exclude.indis")));
        this.dateBirthsAfter = new DateWidget();
        props.add(this.dateBirthsAfter);
        this.checkFilterEmpties = new JCheckBox(this.resources.getString("save.options.exclude.empties"));
        props.add(this.checkFilterEmpties);
        Box others = new Box(1);
        this.filters = filters;
        this.checkFilters = new JCheckBox[filters.length];
        for (int i = 0; i < this.checkFilters.length; ++i) {
            this.checkFilters[i] = new JCheckBox(filters[i].getFilterName(), false);
            others.add(this.checkFilters[i]);
        }
        this.add(this.resources.getString("save.options"), options);
        this.add(this.resources.getString("save.options.filter.entities"), types);
        this.add(this.resources.getString("save.options.filter.properties"), props);
        this.add(this.resources.getString("save.options.filter.views"), others);
    }

    public String getPassword() {
        return this.textPassword.getText();
    }

    public String getEncoding() {
        return this.comboEncodings.getSelectedItem().toString();
    }

    public Filter[] getFilters() {
        PointInTime birthsAfter;
        PointInTime eventsAfter;
        FilterProperties fp;
        ArrayList<Filter> result = new ArrayList<Filter>(10);
        FilterByType fbt = FilterByType.get(this.checkEntities);
        if (fbt != null) {
            result.add(fbt);
        }
        if ((fp = FilterProperties.get(this.textTags.getText(), this.textValues.getText())) != null) {
            result.add(fp);
        }
        if ((eventsAfter = this.dateEventsAfter.getValue()) != null && eventsAfter.isValid()) {
            result.add(new FilterEventsAfter(eventsAfter));
        }
        if ((birthsAfter = this.dateBirthsAfter.getValue()) != null && birthsAfter.isValid()) {
            result.add(new FilterIndividualsBornAfter(birthsAfter));
        }
        if (this.checkFilterEmpties.isSelected()) {
            result.add(new FilterEmpties());
        }
        for (int f = 0; f < this.filters.length; ++f) {
            if (!this.checkFilters[f].isSelected()) continue;
            result.add(this.filters[f]);
        }
        return result.toArray(new Filter[result.size()]);
    }

    private static class FilterByType
    implements Filter {
        private Set types = new HashSet();

        private FilterByType() {
        }

        protected static FilterByType get(JCheckBox[] checks) {
            FilterByType result = new FilterByType();
            for (int t = 0; t < checks.length; ++t) {
                if (!checks[t].isSelected()) continue;
                result.types.add(Gedcom.ENTITIES[t]);
            }
            return result.types.size() < Gedcom.ENTITIES.length ? result : null;
        }

        public boolean checkFilter(Property property) {
            return !(property instanceof Entity) || this.types.contains(property.getTag());
        }

        public String getFilterName() {
            return this.toString();
        }
    }

    private static class FilterProperties
    implements Filter {
        private Set tags;
        private Set paths;
        private String[] values;

        private FilterProperties(Set tags, Set paths, List values) {
            this.tags = tags;
            this.paths = paths;
            this.values = values.toArray(new String[0]);
        }

        protected static FilterProperties get(String sTags, String sValues) {
            HashSet<String> tags = new HashSet<String>();
            HashSet<TagPath> paths = new HashSet<TagPath>();
            StringTokenizer tokens = new StringTokenizer(sTags, ",");
            while (tokens.hasMoreTokens()) {
                String s = tokens.nextToken().trim();
                if (s.indexOf(58) > 0) {
                    try {
                        paths.add(new TagPath(s));
                    }
                    catch (IllegalArgumentException e) {}
                    continue;
                }
                tags.add(s);
            }
            ArrayList<String> values = new ArrayList<String>();
            tokens = new StringTokenizer(sValues, ",");
            while (tokens.hasMoreTokens()) {
                values.add(tokens.nextToken().trim());
            }
            return tags.isEmpty() && paths.isEmpty() && values.isEmpty() ? null : new FilterProperties(tags, paths, values);
        }

        public boolean checkFilter(Property property) {
            if (property instanceof Entity) {
                return true;
            }
            if (this.tags.contains(property.getTag())) {
                return false;
            }
            if (this.paths.contains(property.getPath())) {
                return false;
            }
            return this.accept(property.getValue());
        }

        private boolean accept(String value) {
            if (value == null) {
                return true;
            }
            for (int i = 0; i < this.values.length; ++i) {
                if (value.indexOf(this.values[i]) < 0) continue;
                return false;
            }
            return true;
        }

        public String getFilterName() {
            return this.toString();
        }
    }

    private static class FilterEventsAfter
    implements Filter {
        private PointInTime after;

        private FilterEventsAfter(PointInTime after) {
            this.after = after;
        }

        public boolean checkFilter(Property property) {
            PropertyDate when = property.getWhen();
            return when == null || when.getStart().compareTo(this.after) < 0;
        }

        public String getFilterName() {
            return this.toString();
        }
    }

    private static class FilterIndividualsBornAfter
    implements Filter {
        private PointInTime after;

        private FilterIndividualsBornAfter(PointInTime after) {
            this.after = after;
        }

        public boolean checkFilter(Property property) {
            Indi indi;
            PropertyDate birth;
            if (property instanceof Indi && (birth = (indi = (Indi)property).getBirthDate()) != null) {
                return birth.getStart().compareTo(this.after) < 0;
            }
            return true;
        }

        public String getFilterName() {
            return this.toString();
        }
    }

    private static class FilterEmpties
    implements Filter {
        private FilterEmpties() {
        }

        public boolean checkFilter(Property property) {
            for (int i = 0; i < property.getNoOfProperties(); ++i) {
                if (!this.checkFilter(property.getProperty(i))) continue;
                return true;
            }
            return property.getValue().trim().length() > 0;
        }

        public String getFilterName() {
            return this.toString();
        }
    }
}

