/*
 * Decompiled with CFR 0.152.
 */
package genj.app;

import genj.app.App;
import genj.gedcom.PropertyFile;
import genj.io.FileAssociation;
import genj.lnf.LnF;
import genj.option.Option;
import genj.option.OptionProvider;
import genj.option.OptionUI;
import genj.option.OptionsWidget;
import genj.option.PropertyOption;
import genj.util.EnvironmentChecker;
import genj.util.GridBagHelper;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.FileChooserWidget;
import genj.util.swing.PopupWidget;
import genj.util.swing.TextFieldWidget;
import genj.window.WindowManager;
import java.awt.Component;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Options
extends OptionProvider {
    private static final String SWING_RESOURCES_KEY_PREFIX = "swing.";
    private static final Options instance = new Options();
    private WindowManager windowManager;
    private Resources resources;
    private int maxLogSizeKB = 128;
    private int lookAndFeel = -1;
    private int language = -1;
    public boolean isRestoreViews = true;
    private static String[] languages;
    private static final String[] codes;

    private static String[] findCodes() {
        File[] libs;
        TreeSet<String> result = new TreeSet<String>();
        result.add("en");
        File[] dirs = new File(EnvironmentChecker.getProperty((Object)Options.class, "genj.language.dir", "./language", "Dev-time language directory switch")).listFiles();
        if (dirs != null) {
            for (int i = 0; i < dirs.length; ++i) {
                String dir = dirs[i].getName();
                if ("CVS".equals(dir)) continue;
                result.add(dir);
            }
        }
        if ((libs = new File("./lib").listFiles()) != null) {
            for (int l = 0; l < libs.length; ++l) {
                String name;
                File lib = libs[l];
                if (!lib.isFile() || !(name = lib.getName()).startsWith("genj_") || !name.endsWith(".jar")) continue;
                result.add(name.substring(5, name.length() - 4));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static Options getInstance() {
        return instance;
    }

    public void setWindowManager(WindowManager set) {
        this.windowManager = set;
    }

    public int getLookAndFeel() {
        if (this.lookAndFeel < 0) {
            this.setLookAndFeel(0);
        }
        return this.lookAndFeel;
    }

    public void setLookAndFeel(int set) {
        LnF[] lnfs = LnF.getLnFs();
        if (set < 0 || set > lnfs.length - 1) {
            set = 0;
        }
        lnfs[set].apply(this.windowManager != null ? this.windowManager.getRootComponents() : null);
        this.lookAndFeel = set;
    }

    public LnF[] getLookAndFeels() {
        return LnF.getLnFs();
    }

    public void setLanguage(int language) {
        String lang;
        if (language >= 0 && language < codes.length && (lang = codes[language]).length() > 0) {
            App.LOG.info("Switching language to " + lang);
            String country = Locale.getDefault().getCountry();
            int i = lang.indexOf(95);
            if (i > 0) {
                country = lang.substring(i + 1);
                lang = lang.substring(0, i);
            }
            try {
                Locale.setDefault(new Locale(lang, country));
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.language = language;
        Resources resources = Resources.get(this);
        Iterator keys = resources.getKeys().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (key.indexOf(SWING_RESOURCES_KEY_PREFIX) != 0) continue;
            UIManager.put(key.substring(SWING_RESOURCES_KEY_PREFIX.length()), resources.getString(key));
        }
    }

    public int getLanguage() {
        return this.language;
    }

    public String[] getLanguages() {
        if (languages == null) {
            Resources resources = this.getResources();
            languages = new String[codes.length];
            for (int i = 0; i < languages.length; ++i) {
                String language = resources.getString("option.language." + codes[i], false);
                Options.languages[i] = language != null ? language : codes[i];
            }
        }
        return languages;
    }

    public int getMaxLogSizeKB() {
        return this.maxLogSizeKB;
    }

    public void setMaxLogSizeKB(int set) {
        this.maxLogSizeKB = Math.max(128, set);
    }

    public String getHttpProxy() {
        String host = System.getProperty("http.proxyHost");
        String port = System.getProperty("http.proxyPort");
        if (host == null) {
            return "";
        }
        return port != null && port.length() > 0 ? host + ":" + port : host;
    }

    public void setHttpProxy(String set) {
        String host;
        int colon = set.indexOf(":");
        String port = colon >= 0 ? set.substring(colon + 1) : "";
        String string = host = colon >= 0 ? set.substring(0, colon) : set;
        if (host.length() == 0) {
            port = "";
        }
        System.setProperty("http.proxyHost", host);
        System.setProperty("http.proxyPort", port);
    }

    private Resources getResources() {
        if (this.resources == null) {
            this.resources = Resources.get(this);
        }
        return this.resources;
    }

    public List getOptions() {
        List result = PropertyOption.introspect(instance);
        result.add(new FileAssociationOption());
        result.add(new UserHomeGenJOption());
        return result;
    }

    static {
        codes = Options.findCodes();
    }

    private static class FileAssociationOption
    extends Option
    implements OptionUI {
        private OptionsWidget widget;
        private PopupWidget popup;

        private FileAssociationOption() {
        }

        public String getName() {
            return Options.getInstance().getResources().getString("option.fileassociations");
        }

        public String getToolTip() {
            return Options.getInstance().getResources().getString("option.fileassociations.tip", false);
        }

        public void persist(Registry registry) {
            registry.put("associations", FileAssociation.getAll());
        }

        public void restore(Registry registry) {
            String[] associations = registry.get("associations", new String[0]);
            for (int i = 0; i < associations.length; ++i) {
                FileAssociation.add(new FileAssociation(associations[i]));
            }
        }

        public OptionUI getUI(OptionsWidget widget) {
            this.widget = widget;
            return this;
        }

        public String getTextRepresentation() {
            return null;
        }

        public JComponent getComponentRepresentation() {
            this.popup = new PopupWidget("...");
            this.popup.setActions(this.getActions());
            return this.popup;
        }

        private List getActions() {
            ArrayList<Edit> result = new ArrayList<Edit>(10);
            Iterator it = FileAssociation.getAll().iterator();
            int i = 1;
            while (it.hasNext()) {
                result.add(new Edit(i, (FileAssociation)it.next()));
                ++i;
            }
            result.add(new Edit(0, null));
            return result;
        }

        public void endRepresentation() {
        }

        private class Edit
        extends Action2 {
            private FileAssociation association;

            private Edit(int i, FileAssociation fa) {
                this.association = fa;
                this.setImage(PropertyFile.DEFAULT_IMAGE);
                this.setText(fa != null ? i + " " + fa.getName() + " (" + fa.getSuffixes() + ')' : this.localize("new"));
            }

            private String localize(String key) {
                return Options.getInstance().getResources().getString("option.filesssociations." + key);
            }

            protected void execute() {
                JPanel panel = new JPanel();
                final TextFieldWidget suffixes = new TextFieldWidget();
                final TextFieldWidget name = new TextFieldWidget();
                final FileChooserWidget executable = new FileChooserWidget("exe, bin, sh, cmd, bat");
                GridBagHelper gh = new GridBagHelper(panel);
                gh.add(new JLabel(this.localize("suffix"), 2), 0, 0, 1, 1, 1);
                gh.add(suffixes, 1, 0, 1, 1, 17);
                gh.add(new JLabel(this.localize("name"), 2), 0, 1, 1, 1, 1);
                gh.add(name, 1, 1, 1, 1, 17);
                gh.add(new JLabel(this.localize("exec"), 2), 0, 2, 1, 1, 1);
                gh.add(executable, 1, 2, 1, 1, 17);
                if (this.association != null) {
                    suffixes.setText(this.association.getSuffixes());
                    name.setText(this.association.getName());
                    executable.setFile(this.association.getExecutable());
                }
                final Action ok = Action2.ok();
                Action2 delete = new Action2(this.localize("delete"), this.association != null);
                Action cancel = Action2.cancel();
                ChangeListener l = new ChangeListener(){

                    public void stateChanged(ChangeEvent e) {
                        ok.setEnabled(!suffixes.isEmpty() && !name.isEmpty() && !executable.isEmpty());
                    }
                };
                suffixes.addChangeListener(l);
                name.addChangeListener(l);
                executable.addChangeListener(l);
                l.stateChanged(null);
                WindowManager mgr = FileAssociationOption.this.widget.getWindowManager();
                int rc = mgr.openDialog(null, FileAssociationOption.this.getName(), 3, panel, new Action[]{ok, delete, cancel}, (Component)FileAssociationOption.this.widget);
                if (rc == -1 || rc == 2) {
                    return;
                }
                if (rc == 0) {
                    if (this.association == null) {
                        this.association = FileAssociation.add(new FileAssociation());
                    }
                    this.association.setSuffixes(suffixes.getText());
                    this.association.setName(name.getText());
                    this.association.setExecutable(executable.getFile().toString());
                } else {
                    FileAssociation.del(this.association);
                }
                FileAssociationOption.this.popup.setActions(FileAssociationOption.this.getActions());
            }
        }
    }

    private static class UserHomeGenJOption
    extends Option
    implements OptionUI {
        private UserHomeGenJOption() {
        }

        public String getName() {
            return Options.getInstance().getResources().getString("option.userhomegenj.name");
        }

        public String getToolTip() {
            return Options.getInstance().getResources().getString("option.userhomegenj.name.tip", false);
        }

        public OptionUI getUI(OptionsWidget widget) {
            return this;
        }

        public void persist(Registry registry) {
        }

        public void restore(Registry registry) {
        }

        public void endRepresentation() {
        }

        public JComponent getComponentRepresentation() {
            JButton button = new JButton(new Open());
            button.setMargin(new Insets(2, 2, 2, 2));
            return button;
        }

        public String getTextRepresentation() {
            return null;
        }

        private class Open
        extends Action2 {
            Open() {
                this.setText("...");
            }

            protected void execute() {
                File user_home_genj = new File(EnvironmentChecker.getProperty((Object)UserHomeGenJOption.this, "user.home.genj", null, "trying to open user.home.genj"));
                FileAssociation asso = FileAssociation.get(user_home_genj, "", null);
                if (asso != null) {
                    asso.execute(user_home_genj);
                }
            }
        }
    }
}

