/*
 * Decompiled with CFR 0.152.
 */
package genj.app;

import genj.app.App;
import genj.util.EnvironmentChecker;
import genj.util.Resources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Level;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

class HelpWidget
extends JPanel {
    private static final Resources RESOURCES = Resources.get(HelpWidget.class);

    public HelpWidget() {
        super(new BorderLayout());
        JComponent pCenter = this.getContent();
        if (pCenter == null) {
            pCenter = new JLabel(RESOURCES.getString("cc.help.help_file_missing", Locale.getDefault().getLanguage().toLowerCase()), 0);
            pCenter.setBorder(new EmptyBorder(16, 16, 16, 16));
        }
        this.add((Component)pCenter, "Center");
    }

    public Dimension getPreferredSize() {
        return new Dimension(480, 480);
    }

    private JComponent getContent() {
        String file = this.calcHelpBase() + "/helpset.xml";
        App.LOG.info("Trying to use help in " + file);
        if (!new File(file).exists()) {
            App.LOG.log(Level.WARNING, "No help found in " + file);
            return null;
        }
        try {
            HelpSet set = (HelpSet)HelpSet.class.getConstructor(ClassLoader.class, URL.class).newInstance(null, new URL("file", "", file));
            return (JComponent)JHelp.class.getConstructor(set.getClass()).newInstance(set);
        }
        catch (Throwable t) {
            App.LOG.log(Level.WARNING, "Problem reading help", t);
            return null;
        }
    }

    private String calcHelpBase() {
        String dir = EnvironmentChecker.getProperty((Object)this, new String[]{"genj.help.dir", "user.dir/help"}, ".", "read help");
        String local = dir + "/" + Locale.getDefault().getLanguage();
        if (new File(local).exists()) {
            return local;
        }
        return dir + "/en";
    }
}

