/*
 * Decompiled with CFR 0.152.
 */
package genj.app;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomMetaListener;
import genj.gedcom.Property;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.SortableTableModel;
import genj.view.ContextProvider;
import genj.view.ContextSelectionEvent;
import genj.view.ViewContext;
import genj.view.ViewManager;
import genj.window.WindowBroadcastEvent;
import genj.window.WindowBroadcastListener;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import spin.Spin;

class GedcomTableWidget
extends JTable
implements ContextProvider,
WindowBroadcastListener {
    private static final int[] defaultWidths = new int[]{96, 24, 24, 24, 24, 24, 24, 24};
    private Registry registry;
    private Model model = new Model();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public GedcomTableWidget(ViewManager mgr, Registry reGistry) {
        this.registry = reGistry;
        DefaultTableColumnModel cm = new DefaultTableColumnModel();
        for (int h = 0; h < Gedcom.ENTITIES.length + 1; ++h) {
            TableColumn col = new TableColumn(h);
            if (h == 0) {
                col.setHeaderValue(Resources.get(this).getString("cc.column_header.name"));
            } else {
                col.setHeaderValue(Gedcom.getEntityImage(Gedcom.ENTITIES[h - 1]));
            }
            col.setWidth(defaultWidths[h]);
            col.setPreferredWidth(defaultWidths[h]);
            cm.addColumn(col);
        }
        this.setModel(new SortableTableModel(this.model, this.getTableHeader()));
        this.setColumnModel(cm);
        this.setSelectionMode(0);
        this.setAutoResizeMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        int[] widths = this.registry.get("columns", new int[0]);
        int max = this.getColumnModel().getColumnCount();
        for (int c = 0; c < widths.length && c < max; ++c) {
            TableColumn col = this.getColumnModel().getColumn(c);
            col.setPreferredWidth(widths[c]);
            col.setWidth(widths[c]);
        }
        this.getTableHeader().addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                int col = GedcomTableWidget.this.getColumnModel().getColumnIndexAtX(e.getX());
                String tip = col <= 0 || col > Gedcom.ENTITIES.length ? null : Gedcom.getName(Gedcom.ENTITIES[col - 1]);
                GedcomTableWidget.this.getTableHeader().setToolTipText(tip);
            }
        });
    }

    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(Math.max(128, this.getColumnModel().getTotalColumnWidth()), Math.max(4, this.getModel().getRowCount()) * this.getRowHeight());
    }

    public ViewContext getContext() {
        int row = this.getSelectedRow();
        return row < 0 ? null : new ViewContext(this.model.getGedcom(row));
    }

    public boolean handleBroadcastEvent(WindowBroadcastEvent event) {
        int row;
        ContextSelectionEvent cse = ContextSelectionEvent.narrow(event);
        if (cse != null && (row = this.model.getRowFor(cse.getContext().getGedcom())) >= 0) {
            this.getSelectionModel().setSelectionInterval(row, row);
        }
        return true;
    }

    public Gedcom getGedcomAt(Point pos) {
        int row = this.rowAtPoint(pos);
        return row < 0 ? null : this.model.getGedcom(row);
    }

    public void removeNotify() {
        int[] widths = new int[this.getColumnModel().getColumnCount()];
        for (int c = 0; c < widths.length; ++c) {
            widths[c] = this.getColumnModel().getColumn(c).getWidth();
        }
        this.registry.put("columns", widths);
        super.removeNotify();
    }

    public Gedcom getGedcom(String name) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Gedcom gedcom = this.model.getGedcom(i);
            if (!gedcom.getName().equals(name)) continue;
            return gedcom;
        }
        return null;
    }

    public List getAllGedcoms() {
        return this.model.getAllGedcoms();
    }

    public Gedcom getSelectedGedcom() {
        return this.model.getSelectedGedcom();
    }

    public void addGedcom(Gedcom gedcom) {
        this.model.addGedcom(gedcom);
        int row = this.model.getRowFor(gedcom);
        this.getSelectionModel().setSelectionInterval(row, row);
    }

    public void removeGedcom(Gedcom gedcom) {
        this.model.removeGedcom(gedcom);
    }

    private class Model
    extends AbstractTableModel
    implements GedcomMetaListener {
        private List gedcoms = new ArrayList(10);

        private Model() {
        }

        public Gedcom getSelectedGedcom() {
            int row = GedcomTableWidget.this.getSelectedRow();
            if (row == -1) {
                return null;
            }
            return this.getGedcom(row);
        }

        public Gedcom getGedcom(int row) {
            return (Gedcom)this.gedcoms.get(row);
        }

        public List getAllGedcoms() {
            return this.gedcoms;
        }

        public void addGedcom(Gedcom gedcom) {
            this.gedcoms.add(gedcom);
            Collections.sort(this.gedcoms);
            gedcom.addGedcomListener((GedcomListener)Spin.over(this));
            this.fireTableDataChanged();
        }

        public void removeGedcom(Gedcom gedcom) {
            this.gedcoms.remove(gedcom);
            gedcom.removeGedcomListener((GedcomListener)Spin.over(this));
            this.fireTableDataChanged();
        }

        public int getRowFor(Gedcom gedcom) {
            return this.gedcoms.indexOf(gedcom);
        }

        public int getColumnCount() {
            return Gedcom.ENTITIES.length + 1;
        }

        public int getRowCount() {
            return this.gedcoms.size();
        }

        public Object getValueAt(int row, int col) {
            Gedcom gedcom = this.getGedcom(row);
            if (col == 0) {
                return gedcom.getName() + (gedcom.hasChanged() ? "*" : "");
            }
            return new Integer(gedcom.getEntities(Gedcom.ENTITIES[col - 1]).size());
        }

        public Class getColumnClass(int col) {
            Class clazz = col == 0 ? (class$java$lang$String == null ? (class$java$lang$String = GedcomTableWidget.class$("java.lang.String")) : class$java$lang$String) : (class$java$lang$Integer == null ? (class$java$lang$Integer = GedcomTableWidget.class$("java.lang.Integer")) : class$java$lang$Integer);
            return clazz;
        }

        public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        }

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
        }

        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
        }

        public void gedcomPropertyChanged(Gedcom gedcom, Property prop) {
        }

        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property removed) {
        }

        public void gedcomHeaderChanged(Gedcom gedcom) {
        }

        public void gedcomWriteLockAcquired(Gedcom gedcom) {
        }

        public void gedcomBeforeUnitOfWork(Gedcom gedcom) {
        }

        public void gedcomAfterUnitOfWork(Gedcom gedcom) {
        }

        public void gedcomWriteLockReleased(Gedcom gedcom) {
            int i = this.getRowFor(gedcom);
            if (i >= 0) {
                this.fireTableRowsUpdated(i, i);
            }
        }
    }
}

