/*
 * Decompiled with CFR 0.152.
 */
package genj.app;

import genj.app.AboutWidget;
import genj.app.App;
import genj.app.GedcomTableWidget;
import genj.app.HelpWidget;
import genj.app.Images;
import genj.app.Options;
import genj.app.SaveOptionsWidget;
import genj.common.ContextListWidget;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomMetaListener;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.Submitter;
import genj.gedcom.UnitOfWork;
import genj.io.Filter;
import genj.io.GedcomEncodingException;
import genj.io.GedcomEncryptionException;
import genj.io.GedcomIOException;
import genj.io.GedcomReader;
import genj.io.GedcomWriter;
import genj.option.OptionProvider;
import genj.option.OptionsWidget;
import genj.util.DirectAccessTokenizer;
import genj.util.EnvironmentChecker;
import genj.util.MnemonicAndText;
import genj.util.Origin;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.WordBuffer;
import genj.util.swing.Action2;
import genj.util.swing.ButtonHelper;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.FileChooser;
import genj.util.swing.HeapStatusWidget;
import genj.util.swing.MenuHelper;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.ProgressWidget;
import genj.view.ViewContext;
import genj.view.ViewFactory;
import genj.view.ViewHandle;
import genj.view.ViewManager;
import genj.window.WindowManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import spin.Spin;

public class ControlCenter
extends JPanel {
    private static final String ACC_SAVE = "ctrl S";
    private static final String ACC_EXIT = "ctrl X";
    private static final String ACC_NEW = "ctrl N";
    private static final String ACC_OPEN = "ctrl O";
    private JMenuBar menuBar;
    private GedcomTableWidget tGedcoms;
    private Registry registry;
    private Resources resources = Resources.get(this);
    private WindowManager windowManager;
    private ViewManager viewManager;
    private List gedcomActions = new ArrayList();
    private List toolbarActions = new ArrayList();
    private Stats stats = new Stats();
    private ActionExit exit = new ActionExit();
    static /* synthetic */ Class class$genj$io$Filter;

    public ControlCenter(Registry setRegistry, WindowManager winManager) {
        this.registry = new Registry(setRegistry, "cc");
        this.windowManager = winManager;
        this.viewManager = new ViewManager(this.windowManager);
        this.tGedcoms = new GedcomTableWidget(this.viewManager, this.registry){

            public ViewContext getContext() {
                ViewContext result = super.getContext();
                if (result != null) {
                    result.addAction(new ActionSave(false, true));
                    result.addAction(new ActionClose(true));
                }
                return result;
            }
        };
        this.tGedcoms.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                for (int i = 0; i < ControlCenter.this.gedcomActions.size(); ++i) {
                    ((Action2)ControlCenter.this.gedcomActions.get(i)).setEnabled(ControlCenter.this.tGedcoms.getSelectedGedcom() != null);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.createToolBar(), "North");
        this.add((Component)new JScrollPane(this.tGedcoms), "Center");
        this.add((Component)this.createStatusBar(), "South");
        this.menuBar = this.createMenuBar();
    }

    public void load(String[] files) {
        SwingUtilities.invokeLater(new ActionAutoOpen(files));
    }

    void addGedcom(Gedcom gedcom) {
        this.tGedcoms.addGedcom(gedcom);
        gedcom.addGedcomListener((GedcomListener)Spin.over(this.stats));
    }

    void removeGedcom(Gedcom gedcom) {
        this.viewManager.closeViews(gedcom);
        this.tGedcoms.removeGedcom(gedcom);
        gedcom.removeGedcomListener((GedcomListener)Spin.over(this.stats));
    }

    Action2 getExitAction() {
        return this.exit;
    }

    JMenuBar getMenuBar() {
        return this.menuBar;
    }

    private JPanel createStatusBar() {
        HeapStatusWidget mem = new HeapStatusWidget();
        mem.setToolTipText(this.resources.getString("cc.heap"));
        JPanel result = new JPanel(new NestedBlockLayout("<row><info wx=\"1\" gx=\"1\"/><mem/></row>"));
        result.add(this.stats);
        result.add(mem);
        return result;
    }

    private JToolBar createToolBar() {
        JToolBar result = new JToolBar();
        result.setFloatable(false);
        ButtonHelper bh = new ButtonHelper().setInsets(4).setContainer(result).setFontSize(10);
        ActionNew actionNew = new ActionNew();
        ActionOpen actionOpen = new ActionOpen();
        ActionSave actionSave = new ActionSave(false, false);
        actionNew.setText(null);
        actionOpen.setText(null);
        actionSave.setText(null);
        this.gedcomActions.add(actionSave);
        this.toolbarActions.add(actionNew);
        this.toolbarActions.add(actionOpen);
        this.toolbarActions.add(actionSave);
        bh.create(actionNew);
        bh.create(actionOpen);
        bh.create(actionSave);
        result.addSeparator();
        ViewFactory[] factories = this.viewManager.getFactories();
        for (int i = 0; i < factories.length; ++i) {
            ActionView action = new ActionView(-1, factories[i]);
            action.setText(null);
            bh.create(action);
            this.toolbarActions.add(action);
            this.gedcomActions.add(action);
        }
        result.add(Box.createGlue());
        return result;
    }

    private JMenuBar createMenuBar() {
        MenuHelper mh = new MenuHelper();
        JMenuBar result = mh.createBar();
        mh.createMenu(this.resources.getString("cc.menu.file"));
        mh.createItem(new ActionNew());
        mh.createItem(new ActionOpen());
        mh.createSeparator();
        ActionSave save = new ActionSave(false, false);
        ActionSave saveAs = new ActionSave(true, false);
        ActionClose close = new ActionClose(false);
        this.gedcomActions.add(save);
        this.gedcomActions.add(saveAs);
        this.gedcomActions.add(close);
        mh.createItem(save);
        mh.createItem(saveAs);
        mh.createItem(close);
        if (!EnvironmentChecker.isMac()) {
            mh.createSeparator();
            mh.createItem(this.exit);
        }
        mh.popMenu().createMenu(this.resources.getString("cc.menu.view"));
        ViewFactory[] factories = this.viewManager.getFactories();
        for (int i = 0; i < factories.length; ++i) {
            ActionView action = new ActionView(i + 1, factories[i]);
            this.gedcomActions.add(action);
            mh.createItem(action);
        }
        mh.createSeparator();
        mh.createItem(new ActionOptions());
        mh.popMenu().createMenu(this.resources.getString("cc.menu.help"));
        mh.createItem(new ActionHelp());
        mh.createItem(new ActionAbout());
        return result;
    }

    private File chooseFile(String title, String action, JComponent accessory) {
        FileChooser chooser = new FileChooser(this, title, action, "ged", EnvironmentChecker.getProperty((Object)this, new String[]{"genj.gedcom.dir", "user.home"}, ".", "choose gedcom file"));
        chooser.setCurrentDirectory(new File(this.registry.get("last.dir", "user.home")));
        if (accessory != null) {
            chooser.setAccessory(accessory);
        }
        if (0 != chooser.showDialog()) {
            return null;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            return null;
        }
        this.registry.put("last.dir", file.getParentFile().getAbsolutePath());
        return file;
    }

    private class Stats
    extends JLabel
    implements GedcomMetaListener {
        private int commits;
        private int read;
        private int written;

        private Stats() {
            this.setHorizontalAlignment(2);
        }

        public void gedcomWriteLockReleased(Gedcom gedcom) {
            ++this.commits;
            this.update();
        }

        public synchronized void handleRead(int lines) {
            this.read += lines;
            this.update();
        }

        public synchronized void handleWrite(int lines) {
            this.written += lines;
            this.update();
        }

        private void update() {
            WordBuffer buf = new WordBuffer(", ");
            if (this.commits > 0) {
                buf.append(ControlCenter.this.resources.getString("stat.commits", new Integer(this.commits)));
            }
            if (this.read > 0) {
                buf.append(ControlCenter.this.resources.getString("stat.lines.read", new Integer(this.read)));
            }
            if (this.written > 0) {
                buf.append(ControlCenter.this.resources.getString("stat.lines.written", new Integer(this.written)));
            }
            this.setText(buf.toString());
        }

        public void gedcomHeaderChanged(Gedcom gedcom) {
        }

        public void gedcomBeforeUnitOfWork(Gedcom gedcom) {
        }

        public void gedcomAfterUnitOfWork(Gedcom gedcom) {
        }

        public void gedcomWriteLockAcquired(Gedcom gedcom) {
        }

        public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        }

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
        }

        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
        }

        public void gedcomPropertyChanged(Gedcom gedcom, Property prop) {
        }

        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property removed) {
        }
    }

    private class ActionOptions
    extends Action2 {
        protected ActionOptions() {
            this.setText(ControlCenter.this.resources.getString("cc.menu.options"));
            this.setImage(OptionsWidget.IMAGE);
        }

        protected void execute() {
            Options.getInstance().setWindowManager(ControlCenter.this.windowManager);
            OptionsWidget widget = new OptionsWidget(this.getText());
            widget.setOptions(OptionProvider.getAllOptions());
            ControlCenter.this.windowManager.openDialog("options", this.getText(), 1, widget, Action2.okOnly(), (Component)ControlCenter.this);
        }
    }

    private class ActionView
    extends Action2 {
        private ViewFactory factory;

        protected ActionView(int i, ViewFactory vw) {
            this.factory = vw;
            if (i > 0) {
                this.setText(Integer.toString(i) + " " + new MnemonicAndText(this.factory.getTitle(false)).getText());
            } else {
                this.setText(this.factory.getTitle(true));
            }
            this.setTip(ControlCenter.this.resources.getString("cc.tip.open_view", this.factory.getTitle(false)));
            this.setImage(this.factory.getImage());
            this.setEnabled(false);
        }

        protected void execute() {
            Gedcom gedcom = ControlCenter.this.tGedcoms.getSelectedGedcom();
            if (gedcom == null) {
                return;
            }
            ViewHandle handle = ControlCenter.this.viewManager.openView(gedcom, this.factory);
            new ActionSave(gedcom).setTarget(handle.getView()).install(handle.getView(), 2);
        }
    }

    private class ActionClose
    extends Action2 {
        protected ActionClose(boolean enabled) {
            this.setText(ControlCenter.this.resources.getString("cc.menu.close"));
            this.setImage(Images.imgClose);
            this.setEnabled(enabled);
        }

        protected void execute() {
            Gedcom gedcom = ControlCenter.this.tGedcoms.getSelectedGedcom();
            if (gedcom == null) {
                return;
            }
            if (gedcom.hasChanged()) {
                int rc = ControlCenter.this.windowManager.openDialog(null, null, 2, ControlCenter.this.resources.getString("cc.savechanges?", gedcom.getName()), Action2.yesNoCancel(), (Component)ControlCenter.this);
                if (rc == 2) {
                    return;
                }
                if (rc == 0) {
                    ControlCenter.this.removeGedcom(gedcom);
                    new ActionSave(gedcom){

                        protected void postExecute(boolean preExecuteResult) {
                            super.postExecute(preExecuteResult);
                            if (this.gedcomBeingSaved.hasChanged()) {
                                ControlCenter.this.addGedcom(this.gedcomBeingSaved);
                            }
                        }
                    }.trigger();
                    return;
                }
            }
            ControlCenter.this.removeGedcom(gedcom);
        }
    }

    private class ActionSave
    extends Action2 {
        private boolean ask;
        protected Gedcom gedcomBeingSaved;
        private GedcomWriter gedWriter;
        private Origin newOrigin;
        private Filter[] filters;
        private String progress;
        private GedcomIOException ioex = null;
        private File temp;
        private File file;
        private String password;

        protected ActionSave(Gedcom gedcom) {
            this(false, true);
            this.gedcomBeingSaved = gedcom;
        }

        protected ActionSave(boolean ask, boolean enabled) {
            this.setTarget(ControlCenter.this);
            if (!ask) {
                this.setAccelerator(ControlCenter.ACC_SAVE);
            }
            this.ask = ask;
            if (ask) {
                this.setText(ControlCenter.this.resources.getString("cc.menu.saveas"));
            } else {
                this.setText(ControlCenter.this.resources.getString("cc.menu.save"));
            }
            this.setTip(ControlCenter.this.resources, "cc.tip.save_file");
            this.setImage(Images.imgSave);
            this.setAsync(2);
            this.setEnabled(enabled);
        }

        protected boolean preExecute() {
            int rc;
            if (this.gedcomBeingSaved == null) {
                this.gedcomBeingSaved = ControlCenter.this.tGedcoms.getSelectedGedcom();
                if (this.gedcomBeingSaved == null) {
                    return false;
                }
            }
            Origin origin = this.gedcomBeingSaved.getOrigin();
            String encoding = this.gedcomBeingSaved.getEncoding();
            this.password = this.gedcomBeingSaved.getPassword();
            if (this.ask || origin == null || origin.getFile() == null) {
                SaveOptionsWidget options = new SaveOptionsWidget(this.gedcomBeingSaved, (Filter[])ControlCenter.this.viewManager.getViews(class$genj$io$Filter == null ? (class$genj$io$Filter = ControlCenter.class$("genj.io.Filter")) : class$genj$io$Filter, this.gedcomBeingSaved));
                this.file = ControlCenter.this.chooseFile(ControlCenter.this.resources.getString("cc.save.title"), ControlCenter.this.resources.getString("cc.save.action"), options);
                if (this.file == null) {
                    return false;
                }
                if (!this.file.getName().endsWith(".ged")) {
                    this.file = new File(this.file.getAbsolutePath() + ".ged");
                }
                this.filters = options.getFilters();
                if (this.gedcomBeingSaved.hasPassword()) {
                    this.password = options.getPassword();
                }
                encoding = options.getEncoding();
                try {
                    this.newOrigin = Origin.create(new URL("file", "", this.file.getAbsolutePath()));
                }
                catch (Throwable t) {}
            } else {
                this.file = origin.getFile();
            }
            if (this.file.exists() && this.ask && (rc = ControlCenter.this.windowManager.openDialog(null, ControlCenter.this.resources.getString("cc.save.title"), 2, ControlCenter.this.resources.getString("cc.open.file_exists", this.file.getName()), Action2.yesNo(), (Component)ControlCenter.this)) != 0) {
                this.newOrigin = null;
                return false;
            }
            try {
                this.file = this.file.getCanonicalFile();
                this.temp = File.createTempFile("genj", ".ged", this.file.getParentFile());
                this.gedWriter = new GedcomWriter(this.gedcomBeingSaved, this.file.getName(), encoding, new FileOutputStream(this.temp));
                this.gedWriter.setFilters(this.filters);
                this.gedWriter.setPassword(this.password);
            }
            catch (IOException ex) {
                ControlCenter.this.windowManager.openDialog(null, this.gedcomBeingSaved.getName(), 0, ControlCenter.this.resources.getString("cc.save.open_error", this.file.getAbsolutePath()), Action2.okOnly(), (Component)ControlCenter.this);
                return false;
            }
            this.progress = ControlCenter.this.windowManager.openNonModalDialog(null, ControlCenter.this.resources.getString("cc.save.saving", this.file.getName()), 1, new ProgressWidget(this.gedWriter, this.getThread()), Action2.cancelOnly(), this.getTarget());
            return true;
        }

        protected void execute() {
            try {
                this.gedWriter.write();
                if (this.file.exists()) {
                    File bak = new File(this.file.getAbsolutePath() + "~");
                    if (bak.exists()) {
                        bak.delete();
                    }
                    this.file.renameTo(bak);
                }
                if (!this.temp.renameTo(this.file)) {
                    throw new GedcomIOException("Couldn't move temporary " + this.temp.getName() + " to " + this.file.getName(), -1);
                }
                if (this.newOrigin == null) {
                    this.gedcomBeingSaved.doMuteUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            ActionSave.this.gedcomBeingSaved.setUnchanged();
                        }
                    });
                }
            }
            catch (GedcomIOException ex) {
                this.ioex = ex;
            }
        }

        protected void postExecute(boolean preExecuteResult) {
            ControlCenter.this.windowManager.close(this.progress);
            if (this.ioex != null) {
                if (this.ioex instanceof GedcomEncodingException) {
                    ControlCenter.this.windowManager.openDialog(null, this.gedcomBeingSaved.getName(), 0, ControlCenter.this.resources.getString("cc.save.write_encoding_error", this.ioex.getMessage()), Action2.okOnly(), (Component)ControlCenter.this);
                } else {
                    ControlCenter.this.windowManager.openDialog(null, this.gedcomBeingSaved.getName(), 0, ControlCenter.this.resources.getString("cc.save.write_error", "" + this.ioex.getLine()) + ":\n" + this.ioex.getMessage(), Action2.okOnly(), (Component)ControlCenter.this);
                }
            } else if (this.newOrigin != null) {
                Gedcom alreadyOpen = ControlCenter.this.tGedcoms.getGedcom(this.newOrigin.getName());
                if (alreadyOpen != null) {
                    ControlCenter.this.removeGedcom(alreadyOpen);
                }
                ActionOpen open = new ActionOpen(this.newOrigin){

                    protected void postExecute(boolean preExecuteResult) {
                        super.postExecute(preExecuteResult);
                        if (this.gedcomBeingLoaded != null) {
                            ViewManager.getRegistry(this.gedcomBeingLoaded).set(ViewManager.getRegistry(ActionSave.this.gedcomBeingSaved));
                        }
                    }
                };
                open.password = this.password;
                open.trigger();
            }
            if (this.gedWriter != null) {
                ControlCenter.this.stats.handleWrite(this.gedWriter.getLines());
            }
        }

        static /* synthetic */ ControlCenter access$1100(ActionSave x0) {
            return x0.ControlCenter.this;
        }
    }

    private class ActionAutoOpen
    extends Action2 {
        private Collection files;

        private ActionAutoOpen(String[] args) {
            if (args.length > 0) {
                this.files = Arrays.asList(args);
                return;
            }
            HashSet<URL> deflt = new HashSet<URL>();
            if (args.length == 0) {
                try {
                    deflt.add(new File("gedcom/example.ged").toURL());
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            this.files = (Set)ControlCenter.this.registry.get("open", deflt);
        }

        public void execute() {
            Iterator it = this.files.iterator();
            while (it.hasNext()) {
                String restore = it.next().toString();
                try {
                    File local = new File(restore);
                    if (local.exists()) {
                        restore = local.toURL().toString();
                    }
                    ActionOpen open = new ActionOpen(restore);
                    open.trigger();
                }
                catch (Throwable t) {
                    App.LOG.log(Level.WARNING, "cannot restore " + restore, t);
                }
            }
        }
    }

    private class ActionOpen
    extends Action2 {
        private Origin origin;
        private GedcomReader reader;
        private GedcomIOException exception;
        protected Gedcom gedcomBeingLoaded;
        private String progress;
        private String password = "PASSWORD_NOT_SET";
        private List views2restore = new ArrayList();

        protected ActionOpen(String restore) throws MalformedURLException {
            String token;
            this.setAsync(1);
            DirectAccessTokenizer tokens = new DirectAccessTokenizer(restore, ",", false);
            String url = tokens.get(0);
            String pwd = tokens.get(1);
            if (url == null) {
                throw new IllegalArgumentException("can't restore " + restore);
            }
            this.origin = Origin.create(url);
            if (pwd != null && pwd.length() > 0) {
                this.password = pwd;
            }
            int i = 2;
            while ((token = tokens.get(i)) != null) {
                if (token.length() > 0) {
                    this.views2restore.add(tokens.get(i));
                }
                ++i;
            }
        }

        protected ActionOpen() {
            this.setAccelerator(ControlCenter.ACC_OPEN);
            this.setTip(ControlCenter.this.resources, "cc.tip.open_file");
            this.setText(ControlCenter.this.resources, "cc.menu.open");
            this.setImage(Images.imgOpen);
            this.setAsync(2);
        }

        protected ActionOpen(Origin setOrigin) {
            this.setAsync(1);
            this.origin = setOrigin;
        }

        protected boolean preExecute() {
            if (this.origin == null) {
                Action[] actions = new Action[]{new Action2(ControlCenter.this.resources, "cc.open.choice.local"), new Action2(ControlCenter.this.resources, "cc.open.choice.inet"), Action2.cancel()};
                int rc = ControlCenter.this.windowManager.openDialog(null, ControlCenter.this.resources.getString("cc.open.title"), 3, ControlCenter.this.resources.getString("cc.open.choice"), actions, (Component)ControlCenter.this);
                switch (rc) {
                    case 0: {
                        this.origin = this.chooseExisting();
                        break;
                    }
                    case 1: {
                        this.origin = this.chooseURL();
                    }
                }
            }
            return this.origin == null ? false : this.open(this.origin);
        }

        protected void execute() {
            try {
                this.gedcomBeingLoaded = this.reader.read();
            }
            catch (GedcomIOException ex) {
                this.exception = ex;
            }
        }

        protected void postExecute(boolean preExecuteResult) {
            ControlCenter.this.windowManager.close(this.progress);
            if (this.exception != null) {
                if (this.exception instanceof GedcomEncryptionException) {
                    this.password = ControlCenter.this.windowManager.openDialog(null, this.origin.getName(), 3, ControlCenter.this.resources.getString("cc.provide_password"), "", (Component)ControlCenter.this);
                    if (this.password == null) {
                        this.password = "PASSWORD_UNKNOWN";
                    }
                    this.exception = null;
                    this.trigger();
                    return;
                }
                ControlCenter.this.windowManager.openDialog(null, this.origin.getName(), 0, ControlCenter.this.resources.getString("cc.open.read_error", "" + this.exception.getLine()) + ":\n" + this.exception.getMessage(), Action2.okOnly(), (Component)ControlCenter.this);
                return;
            }
            if (this.gedcomBeingLoaded != null) {
                ControlCenter.this.addGedcom(this.gedcomBeingLoaded);
                if (Options.getInstance().isRestoreViews) {
                    for (int i = 0; i < this.views2restore.size(); ++i) {
                        ViewHandle handle = ViewHandle.restore(ControlCenter.this.viewManager, this.gedcomBeingLoaded, (String)this.views2restore.get(i));
                        if (handle == null) continue;
                        new ActionSave(this.gedcomBeingLoaded).setTarget(handle.getView()).install(handle.getView(), 2);
                    }
                }
            }
            if (this.reader != null) {
                ControlCenter.this.stats.handleRead(this.reader.getLines());
                List warnings = this.reader.getWarnings();
                if (!warnings.isEmpty()) {
                    ControlCenter.this.windowManager.openNonModalDialog(null, ControlCenter.this.resources.getString("cc.open.warnings", this.gedcomBeingLoaded.getName()), 2, new JScrollPane(new ContextListWidget(this.gedcomBeingLoaded, warnings)), Action2.okOnly(), ControlCenter.this);
                }
            }
        }

        private Origin chooseExisting() {
            File file = ControlCenter.this.chooseFile(ControlCenter.this.resources.getString("cc.open.title"), ControlCenter.this.resources.getString("cc.open.action"), null);
            if (file == null) {
                return null;
            }
            ControlCenter.this.registry.put("last.dir", file.getParentFile().getAbsolutePath());
            try {
                return Origin.create(new URL("file", "", file.getAbsolutePath()));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        private Origin chooseURL() {
            Origin origin;
            Object[] choices = ControlCenter.this.registry.get("urls", new String[0]);
            ChoiceWidget choice = new ChoiceWidget(choices, "");
            JLabel label = new JLabel(ControlCenter.this.resources.getString("cc.open.enter_url"));
            int rc = ControlCenter.this.windowManager.openDialog(null, ControlCenter.this.resources.getString("cc.open.title"), 3, new JComponent[]{label, choice}, Action2.okCancel(), (Component)ControlCenter.this);
            String item = choice.getText();
            if (rc != 0 || item.length() == 0) {
                return null;
            }
            try {
                origin = Origin.create(item);
            }
            catch (MalformedURLException ex) {
                ControlCenter.this.windowManager.openDialog(null, item, 0, ControlCenter.this.resources.getString("cc.open.invalid_url"), Action2.okCancel(), (Component)ControlCenter.this);
                return null;
            }
            HashSet<Object> remember = new HashSet<Object>();
            remember.add(item);
            for (int c = 0; c < choices.length && c < 9; ++c) {
                remember.add(choices[c]);
            }
            ControlCenter.this.registry.put("urls", remember);
            return origin;
        }

        private boolean open(Origin origin) {
            if (ControlCenter.this.tGedcoms.getGedcom(origin.getName()) != null) {
                ControlCenter.this.windowManager.openDialog(null, origin.getName(), 0, ControlCenter.this.resources.getString("cc.open.already_open", origin.getName()), Action2.okOnly(), (Component)ControlCenter.this);
                return false;
            }
            try {
                this.reader = new GedcomReader(origin);
                this.reader.setPassword(this.password);
            }
            catch (IOException ex) {
                String txt = ControlCenter.this.resources.getString("cc.open.no_connect_to", origin) + "\n[" + ex.getMessage() + "]";
                ControlCenter.this.windowManager.openDialog(null, origin.getName(), 0, txt, Action2.okOnly(), (Component)ControlCenter.this);
                return false;
            }
            this.progress = ControlCenter.this.windowManager.openNonModalDialog(null, ControlCenter.this.resources.getString("cc.open.loading", origin.getName()), 1, new ProgressWidget(this.reader, this.getThread()), Action2.cancelOnly(), ControlCenter.this);
            return true;
        }
    }

    private class ActionNew
    extends Action2 {
        ActionNew() {
            this.setAccelerator(ControlCenter.ACC_NEW);
            this.setText(ControlCenter.this.resources, "cc.menu.new");
            this.setTip(ControlCenter.this.resources, "cc.tip.create_file");
            this.setImage(Images.imgNew);
        }

        protected void execute() {
            int rc;
            File file = ControlCenter.this.chooseFile(ControlCenter.this.resources.getString("cc.create.title"), ControlCenter.this.resources.getString("cc.create.action"), null);
            if (file == null) {
                return;
            }
            if (!file.getName().endsWith(".ged")) {
                file = new File(file.getAbsolutePath() + ".ged");
            }
            if (file.exists() && (rc = ControlCenter.this.windowManager.openDialog(null, ControlCenter.this.resources.getString("cc.create.title"), 2, ControlCenter.this.resources.getString("cc.open.file_exists", file.getName()), Action2.yesNo(), (Component)ControlCenter.this)) != 0) {
                return;
            }
            try {
                Gedcom gedcom = new Gedcom(Origin.create(new URL("file", "", file.getAbsolutePath())));
                try {
                    Indi adam = (Indi)gedcom.createEntity("INDI");
                    adam.addDefaultProperties();
                    adam.setName("Adam", "");
                    adam.setSex(1);
                    Submitter submitter = (Submitter)gedcom.createEntity("SUBM");
                    submitter.setName(EnvironmentChecker.getProperty((Object)this, "user.name", "?", "user name used as submitter in new gedcom"));
                }
                catch (GedcomException gedcomException) {
                    // empty catch block
                }
                ControlCenter.this.addGedcom(gedcom);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    private class ActionExit
    extends Action2 {
        protected ActionExit() {
            this.setAccelerator(ControlCenter.ACC_EXIT);
            this.setText(ControlCenter.this.resources, "cc.menu.exit");
            this.setImage(Images.imgExit);
            this.setTarget(ControlCenter.this);
        }

        protected void execute() {
            ArrayList<StringBuffer> save = new ArrayList<StringBuffer>();
            Iterator gedcoms = ControlCenter.this.tGedcoms.getAllGedcoms().iterator();
            while (gedcoms.hasNext()) {
                File file;
                Gedcom gedcom = (Gedcom)gedcoms.next();
                if (gedcom.hasChanged()) {
                    int rc = ControlCenter.this.windowManager.openDialog("confirm-exit", null, 2, ControlCenter.this.resources.getString("cc.savechanges?", gedcom.getName()), Action2.yesNoCancel(), (Component)ControlCenter.this);
                    if (rc == 2) {
                        return;
                    }
                    if (rc == 0) {
                        this.setEnabled(false);
                        new ActionSave(gedcom){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            protected void postExecute(boolean preExecuteResult) {
                                try {
                                    super.postExecute(preExecuteResult);
                                    if (this.gedcomBeingSaved.hasChanged()) {
                                        return;
                                    }
                                }
                                finally {
                                    ActionExit.this.setEnabled(true);
                                }
                                ActionExit.this.trigger();
                            }
                        }.trigger();
                        return;
                    }
                }
                if ((file = gedcom.getOrigin().getFile()) != null && !file.exists()) continue;
                StringBuffer restore = new StringBuffer();
                restore.append(gedcom.getOrigin());
                restore.append(",");
                if (gedcom.hasPassword()) {
                    restore.append(gedcom.getPassword());
                }
                restore.append(",");
                ViewHandle[] views = ControlCenter.this.viewManager.getViews(gedcom);
                int j = 0;
                for (int i = 0; i < views.length; ++i) {
                    if (j++ > 0) {
                        restore.append(",");
                    }
                    restore.append(views[i].persist());
                }
                save.add(restore);
            }
            ControlCenter.this.registry.put("open", save);
            ControlCenter.this.windowManager.closeAll();
            System.exit(0);
        }

        static /* synthetic */ ControlCenter access$700(ActionExit x0) {
            return x0.ControlCenter.this;
        }
    }

    private class ActionHelp
    extends Action2 {
        protected ActionHelp() {
            this.setText(ControlCenter.this.resources, "cc.menu.contents");
            this.setImage(Images.imgHelp);
        }

        protected void execute() {
            if (ControlCenter.this.windowManager.show("help")) {
                return;
            }
            ControlCenter.this.windowManager.openWindow("help", ControlCenter.this.resources.getString("cc.menu.help"), Images.imgHelp, new HelpWidget(), null, null);
        }
    }

    private class ActionAbout
    extends Action2 {
        protected ActionAbout() {
            this.setText(ControlCenter.this.resources, "cc.menu.about");
            this.setImage(Images.imgAbout);
        }

        protected void execute() {
            if (ControlCenter.this.windowManager.show("about")) {
                return;
            }
            ControlCenter.this.windowManager.openDialog("about", ControlCenter.this.resources.getString("cc.menu.about"), 1, new AboutWidget(ControlCenter.this.viewManager), Action2.okOnly(), (Component)ControlCenter.this);
        }
    }
}

