/*
 * Decompiled with CFR 0.152.
 */
package genj.app;

import genj.Version;
import genj.app.ControlCenter;
import genj.app.Options;
import genj.gedcom.Gedcom;
import genj.option.OptionProvider;
import genj.util.EnvironmentChecker;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.window.DefaultWindowManager;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import javax.swing.SwingUtilities;

public class App {
    static Logger LOG;
    static File LOGFILE;
    private static Startup startup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(final String[] args) {
        Object object = App.class;
        synchronized (object) {
            if (startup == null) {
                startup = new Startup();
                SwingUtilities.invokeLater(startup);
            }
        }
        object = startup;
        synchronized (object) {
            if (App.startup.center == null) {
                try {
                    startup.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                startup.center.load(args);
            }
        });
    }

    public static class PatchedLogManager
    extends LogManager {
        public void reset() throws SecurityException {
        }

        public void doReset() throws SecurityException {
            super.reset();
        }
    }

    private static class LogOutputStream
    extends OutputStream {
        private char[] buffer = new char[256];
        private int size = 0;
        private Level level;
        private String sourceClass;
        private String sourceMethod;

        public LogOutputStream(Level level, String sourceClass, String sourceMethod) {
            this.level = level;
            this.sourceClass = sourceClass;
            this.sourceMethod = sourceMethod;
        }

        public void write(int b) throws IOException {
            if (b != 10) {
                this.buffer[this.size++] = (char)b;
                if (this.size < this.buffer.length) {
                    return;
                }
            }
            this.flush();
        }

        public void flush() throws IOException {
            if (this.size > 0) {
                LOG.logp(this.level, this.sourceClass, this.sourceMethod, String.valueOf(this.buffer, 0, this.size).trim());
                this.size = 0;
            }
        }
    }

    private static class LogFormatter
    extends Formatter {
        private LogFormatter() {
        }

        public String format(LogRecord record) {
            StringBuffer result = new StringBuffer(80);
            result.append(record.getLevel());
            result.append(":");
            result.append(record.getSourceClassName());
            result.append(".");
            result.append(record.getSourceMethodName());
            result.append(":");
            String msg = record.getMessage();
            Object[] parms = record.getParameters();
            if (parms == null || parms.length == 0) {
                result.append(record.getMessage());
            } else {
                result.append(MessageFormat.format(msg, parms));
            }
            result.append(System.getProperty("line.separator"));
            if (record.getThrown() != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                try {
                    record.getThrown().printStackTrace(pw);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                pw.close();
                result.append(sw.toString());
            }
            return result.toString();
        }
    }

    private static class FlushingHandler
    extends Handler {
        private Handler wrapped;

        private FlushingHandler(Handler wrapped) {
            this.wrapped = wrapped;
            wrapped.setLevel(Level.ALL);
            this.setLevel(Level.ALL);
        }

        public void publish(LogRecord record) {
            this.wrapped.publish(record);
            this.flush();
        }

        public void flush() {
            this.wrapped.flush();
        }

        public void close() throws SecurityException {
            this.flush();
            this.wrapped.close();
        }
    }

    private static class Shutdown
    implements Runnable {
        private Registry registry;

        private Shutdown(Registry registry) {
            this.registry = registry;
        }

        public void run() {
            LOG.info("Shutdown");
            OptionProvider.persistAll(this.registry);
            Registry.persist();
            LOG.info("/Shutdown");
            LogManager mgr = LogManager.getLogManager();
            if (mgr instanceof PatchedLogManager) {
                ((PatchedLogManager)mgr).doReset();
            }
        }
    }

    private static class Startup
    implements Runnable {
        ControlCenter center;

        private Startup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                File home = new File(EnvironmentChecker.getProperty((Object)(class$genj$app$App == null ? (class$genj$app$App = App.class$("genj.app.App")) : class$genj$app$App), "user.home.genj", null, "determining home directory"));
                home.mkdirs();
                if (!home.exists() || !home.isDirectory()) {
                    throw new IOException("Can't initialize home directoy " + home);
                }
                System.setProperty("java.util.logging.manager", "genj.app.App$PatchedLogManager");
                LOG = Logger.getLogger("genj");
                LogFormatter formatter = new LogFormatter();
                Logger root = Logger.getLogger("");
                try {
                    Level level = Level.parse(System.getProperty("genj.debug.level"));
                    LOG.setLevel(level);
                    if (Integer.MAX_VALUE != level.intValue()) {
                        root.setLevel(new Level("genj.debug.level+1", level.intValue() + 1){});
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                Handler[] handlers = root.getHandlers();
                for (int i = 0; i < handlers.length; ++i) {
                    root.removeHandler(handlers[i]);
                }
                root.addHandler(new FlushingHandler(new StreamHandler(System.out, formatter)));
                System.setOut(new PrintStream(new LogOutputStream(Level.INFO, "System", "out")));
                System.setErr(new PrintStream(new LogOutputStream(Level.WARNING, "System", "err")));
                LOG.info("Startup");
                Registry registry = new Registry("genj");
                OptionProvider.getAllOptions(registry);
                LOGFILE = new File(home, "genj.log");
                FileHandler handler = new FileHandler(LOGFILE.getAbsolutePath(), Options.getInstance().getMaxLogSizeKB() * 1024, 1, true);
                handler.setLevel(Level.ALL);
                handler.setFormatter(formatter);
                LOG.addHandler(handler);
                LOG.info("version = " + Version.getInstance().getBuildString());
                LOG.info("date = " + new Date());
                EnvironmentChecker.log();
                if (EnvironmentChecker.isMac()) {
                    LOG.info("Setting up MacOs adjustments");
                    System.setProperty("apple.laf.useScreenMenuBar", "true");
                    System.setProperty("com.apple.mrj.application.apple.menu.about.name", "GenealogyJ");
                }
                if (!EnvironmentChecker.isJava14(class$genj$app$App == null ? (class$genj$app$App = App.class$("genj.app.App")) : class$genj$app$App) && EnvironmentChecker.getProperty((Object)(class$genj$app$App == null ? (class$genj$app$App = App.class$("genj.app.App")) : class$genj$app$App), "genj.forcevm", null, "Check force of VM") == null) {
                    LOG.severe("Need Java 1.4 to run GenJ");
                    System.exit(1);
                    return;
                }
                Resources resources = Resources.get(class$genj$app$App == null ? (class$genj$app$App = App.class$("genj.app.App")) : class$genj$app$App);
                DefaultWindowManager winMgr = new DefaultWindowManager(new Registry(registry, "window"), Gedcom.getImage());
                String version = Version.getInstance().getVersionString();
                if (!version.equals(registry.get("disclaimer", ""))) {
                    registry.put("disclaimer", version);
                    winMgr.openDialog("disclaimer", "Disclaimer", 1, resources.getString("app.disclaimer"), Action2.okOnly(), null);
                }
                this.center = new ControlCenter(registry, winMgr);
                winMgr.openWindow("cc", resources.getString("app.title"), Gedcom.getImage(), this.center, this.center.getMenuBar(), this.center.getExitAction());
                Runtime.getRuntime().addShutdownHook(new Thread(new Shutdown(registry)));
                LOG.info("/Startup");
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Cannot instantiate App", t);
                System.exit(1);
                return;
            }
            Startup startup = this;
            synchronized (startup) {
                this.notifyAll();
            }
        }
    }
}

