/*
 * Decompiled with CFR 0.152.
 */
package genj.app;

import genj.Version;
import genj.app.App;
import genj.io.FileAssociation;
import genj.util.EnvironmentChecker;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.view.ViewManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class AboutWidget
extends JPanel {
    private static final int DEFAULT_ROWS = 16;
    private static final int DEFAULT_COLS = 40;
    private ViewManager viewManager;
    private Resources resources = Resources.get(AboutWidget.class);

    public AboutWidget(ViewManager setManager) {
        this.viewManager = setManager;
        JLabel pNorth = new JLabel(this.resources.getString("cc.about.dialog.northpanel.label"), null, 0);
        JTabbedPane pCenter = new JTabbedPane(1);
        pCenter.addTab(this.resources.getString("cc.about.dialog.tab1.title"), null, new WelcomePanel());
        pCenter.addTab(this.resources.getString("cc.about.dialog.tab2.title"), null, new AuthorsPanel());
        pCenter.addTab(this.resources.getString("cc.about.dialog.tab3.title"), null, new CopyrightPanel());
        this.setLayout(new BorderLayout());
        this.add((Component)pNorth, "North");
        this.add((Component)pCenter, "Center");
    }

    protected void readTextFile(JTextArea ta, String file, String fallback) {
        try {
            FileInputStream fin = new FileInputStream(file);
            InputStreamReader in = new InputStreamReader(fin);
            ta.read(in, null);
            fin.close();
        }
        catch (Throwable t) {
            ta.setText(fallback);
        }
    }

    private class Log
    extends Action2 {
        Log() {
            this.setText("Log");
        }

        protected void execute() {
            FileAssociation asso = FileAssociation.get(App.LOGFILE, "GenJ Log", AboutWidget.this);
            if (asso != null) {
                asso.execute(App.LOGFILE);
            }
        }
    }

    private class WelcomePanel
    extends JPanel {
        protected WelcomePanel() {
            super(new BorderLayout());
            String msg = AboutWidget.this.resources.getString("cc.about.tab1.text1", Version.getInstance().getVersionString());
            JTextArea text = new JTextArea(msg, 16, 40);
            text.setBorder(new EmptyBorder(3, 3, 3, 3));
            text.setLineWrap(true);
            text.setWrapStyleWord(true);
            text.setEditable(false);
            this.add((Component)text, "Center");
            this.add((Component)new JButton(new Log()), "South");
        }
    }

    private class CopyrightPanel
    extends JPanel {
        protected CopyrightPanel() {
            super(new BorderLayout());
            this.add((Component)this.getNorth(), "North");
            this.add((Component)this.getCenter(), "Center");
        }

        private JComponent getNorth() {
            JTextArea text = new JTextArea(AboutWidget.this.resources.getString("cc.about.tab3.text1"), 3, 40);
            text.setLineWrap(true);
            text.setWrapStyleWord(true);
            text.setEditable(false);
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(AboutWidget.this.resources.getString("cc.about.tab3.text1.title")), new EmptyBorder(3, 3, 3, 3)));
            panel.add((Component)text, "Center");
            return panel;
        }

        private JComponent getCenter() {
            JTextArea text = new JTextArea(16, 40);
            String dir = EnvironmentChecker.getProperty((Object)this, new String[]{"user.dir"}, ".", "read gpl.txt");
            String path = dir + File.separatorChar + "doc" + File.separatorChar + "gpl.txt";
            AboutWidget.this.readTextFile(text, path, AboutWidget.this.resources.getString("cc.about.file_missing.text") + path);
            text.setLineWrap(false);
            text.setEditable(false);
            text.setBorder(new EmptyBorder(3, 3, 3, 3));
            JScrollPane scroll = new JScrollPane(text);
            scroll.setVerticalScrollBarPolicy(20);
            scroll.setHorizontalScrollBarPolicy(30);
            scroll.setBorder(BorderFactory.createTitledBorder(AboutWidget.this.resources.getString("cc.about.tab3.text2.title")));
            return scroll;
        }
    }

    private class AuthorsPanel
    extends JScrollPane {
        protected AuthorsPanel() {
            JTextArea text = new JTextArea(16, 40);
            text.setLineWrap(false);
            text.setWrapStyleWord(true);
            text.setEditable(false);
            String dir = EnvironmentChecker.getProperty((Object)this, new String[]{"user.dir"}, ".", "get authors.txt");
            String path = dir + File.separatorChar + "doc" + File.separatorChar + "authors.txt";
            AboutWidget.this.readTextFile(text, path, AboutWidget.this.resources.getString("cc.about.file_missing.text") + path);
            this.setViewportView(text);
            this.setVerticalScrollBarPolicy(20);
            this.setHorizontalScrollBarPolicy(30);
        }
    }
}

