/*
 * Decompiled with CFR 0.152.
 */
package genj.almanac;

import genj.gedcom.GedcomException;
import genj.gedcom.time.PointInTime;
import genj.util.WordBuffer;
import java.util.List;
import java.util.Set;

public class Event
implements Comparable {
    private PointInTime pit;
    private String desc;
    private List cats;
    private long julianDay;

    public Event(List setCats, PointInTime setTime, String setText) throws GedcomException {
        this.pit = setTime;
        this.cats = setCats;
        this.desc = setText;
        this.julianDay = this.pit.getJulianDay();
    }

    protected long getJulian() {
        return this.julianDay;
    }

    protected boolean isCategory(Set criteria) {
        for (int c = 0; c < this.cats.size(); ++c) {
            if (!criteria.contains(this.cats.get(c))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        WordBuffer result = new WordBuffer();
        result.append(this.pit.toString());
        result.append(this.desc);
        return result.toString();
    }

    public int compareTo(Object o) {
        Event that = (Event)o;
        return this.pit.compareTo(that.pit);
    }

    public PointInTime getTime() {
        return this.pit;
    }

    public List getCategories() {
        return this.cats;
    }

    public String getDescription() {
        return this.desc;
    }
}

