/*
 * Decompiled with CFR 0.152.
 */
package genj.almanac;

import genj.almanac.Event;
import genj.gedcom.GedcomException;
import genj.gedcom.time.PointInTime;
import genj.util.EnvironmentChecker;
import genj.util.Resources;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Almanac {
    private static final Logger LOG = Logger.getLogger("genj.almanac");
    private static final Resources RESOURCES = Resources.get(Almanac.class);
    private static final String LANG = Locale.getDefault().getLanguage();
    private List listeners = new ArrayList(10);
    private static Almanac instance;
    private List events = new ArrayList();
    private Set categories = new HashSet();
    private boolean isLoaded = false;

    public static Almanac getInstance() {
        if (instance == null) {
            instance = new Almanac();
        }
        return instance;
    }

    private Almanac() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if ("fr".equals(Locale.getDefault().getLanguage())) {
                        new AlmanacLoader().load();
                    } else {
                        new WikipediaLoader().load();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                LOG.info("Loaded " + Almanac.this.events.size() + " events");
                List list = Almanac.this.events;
                synchronized (list) {
                    Almanac.this.isLoaded = true;
                    Almanac.this.events.notifyAll();
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitLoaded() {
        List list = this.events;
        synchronized (list) {
            while (!this.isLoaded) {
                try {
                    this.events.wait();
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
        }
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addCategory(String name) {
        Set set = this.categories;
        synchronized (set) {
            this.categories.add(name);
        }
        return name;
    }

    protected void fireStateChanged() {
        ChangeEvent e = new ChangeEvent(this);
        ChangeListener[] ls = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        for (int l = 0; l < ls.length; ++l) {
            ls[l].stateChanged(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCategories() {
        Set set = this.categories;
        synchronized (set) {
            return new ArrayList(this.categories);
        }
    }

    public Iterator getEvents(PointInTime when, int days, Set cats) throws GedcomException {
        return new Range(when, days, cats);
    }

    public Iterator getEvents(PointInTime from, PointInTime to, Set cats) {
        return new Range(from, to, cats);
    }

    private class Range
    implements Iterator {
        private int start;
        private int end;
        private PointInTime earliest;
        private PointInTime latest;
        private long origin = -1L;
        private long originDelta;
        private Event next;
        private Set cats;

        Range(PointInTime when, int days, Set cats) throws GedcomException {
            this.earliest = new PointInTime(0, 0, when.getYear() - 1);
            this.latest = new PointInTime(30, 11, when.getYear() + 1);
            this.origin = when.getJulianDay();
            this.originDelta = days;
            this.init(cats);
        }

        Range(PointInTime from, PointInTime to, Set cats) {
            if (!from.isValid() || !to.isValid()) {
                throw new IllegalArgumentException();
            }
            this.earliest = from;
            this.latest = to;
            this.init(cats);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init(Set cats) {
            this.cats = cats;
            List list = Almanac.this.events;
            synchronized (list) {
                this.end = Almanac.this.events.size();
                this.start = this.getStartIndex(this.earliest.getYear());
                this.hasNext();
            }
        }

        boolean end() {
            this.next = null;
            this.start = this.end;
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            List list = Almanac.this.events;
            synchronized (list) {
                if (Almanac.this.events.size() != this.end) {
                    return this.end();
                }
                while (true) {
                    PointInTime time;
                    if (this.start == this.end) {
                        return this.end();
                    }
                    this.next = (Event)Almanac.this.events.get(this.start++);
                    if (this.cats != null && !this.next.isCategory(this.cats) || (time = this.next.getTime()).compareTo(this.earliest) < 0) continue;
                    if (time.compareTo(this.latest) > 0) {
                        return this.end();
                    }
                    if (this.origin <= 0L) break;
                    long delta = this.next.getJulian() - this.origin;
                    if (delta > this.originDelta) {
                        return this.end();
                    }
                    if (delta >= -this.originDelta) break;
                }
                return true;
            }
        }

        public Object next() {
            if (this.next == null && !this.hasNext()) {
                throw new IllegalArgumentException("no next");
            }
            Event result = this.next;
            this.next = null;
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private int getStartIndex(int year) {
            if (Almanac.this.events.isEmpty()) {
                return 0;
            }
            return this.getStartIndex(year, 0, Almanac.this.events.size() - 1);
        }

        private int getStartIndex(int year, int start, int end) {
            if (end == start) {
                return start;
            }
            int pivot = (start + end) / 2;
            int y = ((Event)Almanac.this.events.get(pivot)).getTime().getYear();
            if (y < year) {
                return this.getStartIndex(year, pivot + 1, end);
            }
            return this.getStartIndex(year, start, pivot);
        }
    }

    private class WikipediaLoader
    extends Loader {
        private Pattern REGEX_LINE;
        private String SUFFIX;
        private String file;

        private WikipediaLoader() {
            this.REGEX_LINE = Pattern.compile("(.*?)\\\\(.*?)\\\\(.*)");
            this.SUFFIX = ".wikipedia.zip";
        }

        protected File getDirectory() {
            File result = new File(EnvironmentChecker.getProperty((Object)this, new String[]{"genj.wikipedia.dir", "user.dir/contrib/wikipedia"}, "contrib/wikipedia", "find wikipedia files"));
            String lang = Locale.getDefault().getLanguage();
            String[] list = result.list(this);
            if (list != null) {
                List<String> files = Arrays.asList(list);
                if (files.contains(lang + this.SUFFIX)) {
                    this.file = lang + this.SUFFIX;
                } else if (files.contains("en" + this.SUFFIX)) {
                    this.file = "en" + this.SUFFIX;
                } else if (!files.isEmpty()) {
                    this.file = files.get(0);
                }
            }
            return result;
        }

        public boolean accept(File dir, String name) {
            return this.file == null ? name.endsWith(this.SUFFIX) : this.file.equals(name);
        }

        protected BufferedReader open(File file) throws IOException {
            ZipInputStream in = new ZipInputStream(new FileInputStream(file));
            ZipEntry entry = in.getNextEntry();
            if (!file.getName().startsWith(entry.getName())) {
                throw new IOException("Unexpected entry " + entry + " in " + file);
            }
            return new BufferedReader(new InputStreamReader((InputStream)in, Charset.forName("UTF-8")));
        }

        protected Event load(String line) throws GedcomException {
            if (line.startsWith("#")) {
                return null;
            }
            Matcher match = this.REGEX_LINE.matcher(line);
            if (!match.matches()) {
                return null;
            }
            String yyyymmdd = match.group(1);
            String group = match.group(2) + " (Wikipedia)";
            String text = match.group(3);
            PointInTime pit = new PointInTime(yyyymmdd);
            if (!pit.isValid()) {
                return null;
            }
            List<String> cats = Collections.singletonList(Almanac.this.addCategory(group));
            return new Event(cats, pit, text);
        }
    }

    private class AlmanacLoader
    extends Loader {
        private AlmanacLoader() {
        }

        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".almanac");
        }

        protected File getDirectory() {
            return new File(EnvironmentChecker.getProperty((Object)this, new String[]{"genj.almanac.dir", "user.dir/contrib/almanac"}, "contrib/almanac", "find almanac files"));
        }

        protected BufferedReader open(File file) throws IOException {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8")));
        }

        protected Event load(String line) throws GedcomException {
            String country;
            if (line.startsWith("#")) {
                return null;
            }
            StringTokenizer cols = new StringTokenizer(line, ";", true);
            String date = cols.nextToken().trim();
            cols.nextToken();
            if (date.length() < 4) {
                return null;
            }
            int year = Integer.parseInt(date.substring(0, 4));
            int month = date.length() >= 6 ? Integer.parseInt(date.substring(4, 6)) - 1 : Integer.MAX_VALUE;
            int day = date.length() >= 8 ? Integer.parseInt(date.substring(6, 8)) - 1 : Integer.MAX_VALUE;
            PointInTime time = new PointInTime(day, month, year);
            if (!time.isValid()) {
                return null;
            }
            String date2 = cols.nextToken();
            if (!date2.equals(";")) {
                cols.nextToken();
            }
            if (!(country = cols.nextToken().trim()).equals(";")) {
                cols.nextToken();
            }
            int sig = Integer.parseInt(cols.nextToken());
            cols.nextToken();
            List cats = this.getCategories(cols.nextToken().trim());
            if (cats.isEmpty()) {
                return null;
            }
            cols.nextToken();
            String desc = null;
            while (cols.hasMoreTokens()) {
                int i;
                String translation = cols.nextToken().trim();
                if (translation.equals(";") || (i = translation.indexOf(61)) < 0) continue;
                String lang = translation.substring(0, i);
                if (desc != null && !LANG.equals(lang)) continue;
                desc = translation.substring(i + 1);
            }
            if (desc == null) {
                return null;
            }
            return new Event(cats, time, desc);
        }

        private List getCategories(String cats) {
            ArrayList<String> result = new ArrayList<String>();
            for (int c = 0; c < cats.length(); ++c) {
                String key = cats.substring(c, c + 1);
                String cat = RESOURCES.getString("category." + key, false);
                if (cat == null) {
                    cat = RESOURCES.getString("category.*");
                }
                result.add(Almanac.this.addCategory(cat));
            }
            return result;
        }
    }

    private abstract class Loader
    implements FilenameFilter {
        private Loader() {
        }

        protected void load() {
            File dir = this.getDirectory();
            File[] files = !dir.exists() || !dir.isDirectory() ? new File[]{} : dir.listFiles();
            if (files.length == 0) {
                LOG.info("Found no file(s) in " + dir.getAbsoluteFile());
                return;
            }
            for (int f = 0; f < files.length; ++f) {
                File file = files[f];
                if (!this.accept(dir, file.getName())) continue;
                LOG.info("Loading " + file.getAbsoluteFile());
                try {
                    this.load(file);
                    continue;
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "IO Problem reading " + file.getAbsoluteFile(), e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void load(File file) throws IOException {
            BufferedReader in = this.open(file);
            String line = in.readLine();
            while (line != null) {
                block7: {
                    try {
                        Event event = this.load(line);
                        if (event == null) break block7;
                        int index = Collections.binarySearch(Almanac.this.events, event);
                        if (index < 0) {
                            index = -index - 1;
                        }
                        List list = Almanac.this.events;
                        synchronized (list) {
                            Almanac.this.events.add(index, event);
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                line = in.readLine();
            }
            Almanac.this.fireStateChanged();
        }

        protected abstract BufferedReader open(File var1) throws IOException;

        protected abstract Event load(String var1) throws GedcomException;

        protected abstract File getDirectory();
    }
}

