/*
 * Decompiled with CFR 0.152.
 */
package com.nm.resedit;

import com.nm.resedit.ResourceFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipOutputStream;
import javax.swing.tree.TreeNode;

class ResourceDir
implements TreeNode {
    String name = "";
    ResourceFile file = null;
    Vector dirs = new Vector();

    ResourceDir(String string) {
        this.name = string;
    }

    void writeTo(ZipOutputStream zipOutputStream, boolean bl, String string) throws IOException {
        if (this.file != null) {
            this.file.writeTo(zipOutputStream, bl, string);
        }
        Enumeration enumeration = this.dirs.elements();
        while (enumeration.hasMoreElements()) {
            ResourceDir resourceDir = (ResourceDir)enumeration.nextElement();
            resourceDir.writeTo(zipOutputStream, bl, string);
        }
    }

    ResourceFile getResourceFile() {
        return this.file;
    }

    void setTranslation(String string, InputStream inputStream, boolean bl) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/", false);
        this.setTranslation(stringTokenizer, inputStream, bl);
    }

    private void setTranslation(StringTokenizer stringTokenizer, InputStream inputStream, boolean bl) throws IOException {
        String string = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            this.file.setTranslation(inputStream, bl);
            return;
        }
        Enumeration enumeration = this.dirs.elements();
        while (enumeration.hasMoreElements()) {
            ResourceDir resourceDir = (ResourceDir)enumeration.nextElement();
            if (!resourceDir.name.equals(string)) continue;
            resourceDir.setTranslation(stringTokenizer, inputStream, bl);
            return;
        }
    }

    void put(ResourceFile resourceFile) {
        StringTokenizer stringTokenizer = new StringTokenizer(resourceFile.getPath(), "/", false);
        this.put(resourceFile, stringTokenizer);
    }

    private void put(ResourceFile resourceFile, StringTokenizer stringTokenizer) {
        ResourceDir resourceDir;
        if (!stringTokenizer.hasMoreTokens()) {
            if (this.file != null) {
                System.out.println("*** Warning : Directory " + this + " has multiple resource entries");
                return;
            }
            this.file = resourceFile;
            resourceFile.setParent(this);
            return;
        }
        String string = stringTokenizer.nextToken();
        Enumeration enumeration = this.dirs.elements();
        while (enumeration.hasMoreElements()) {
            resourceDir = (ResourceDir)enumeration.nextElement();
            if (!resourceDir.name.equals(string)) continue;
            resourceDir.put(resourceFile, stringTokenizer);
            return;
        }
        resourceDir = new ResourceDir(string);
        this.dirs.addElement(resourceDir);
        resourceDir.put(resourceFile, stringTokenizer);
    }

    public String toString() {
        return this.name;
    }

    public boolean isTranslated() {
        if (this.file != null) {
            return this.file.isTranslated();
        }
        return true;
    }

    public TreeNode getChildAt(int n) {
        return (ResourceDir)this.dirs.elementAt(n);
    }

    public int getChildCount() {
        return this.dirs.size();
    }

    public TreeNode getParent() {
        return null;
    }

    public int getIndex(TreeNode treeNode) {
        int n = 0;
        while (n < this.dirs.size()) {
            if (this.dirs.elementAt(n) == treeNode) {
                return n;
            }
            ++n;
        }
        throw new IllegalArgumentException();
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public boolean isLeaf() {
        return false;
    }

    public Enumeration children() {
        return this.dirs.elements();
    }
}

