/*
 * Decompiled with CFR 0.152.
 */
package com.nm.resedit;

import com.nm.resedit.ResourceArchive;
import com.nm.resedit.ResourceArchiveView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class Main
implements ActionListener {
    private static final String product = "ResEdit";
    private static final String version = "1.0.1";
    private static final String disclaimer = "(C) 1999 by Nils Meier";
    private JFrame frame;
    private ResourceArchive archive;
    private ResourceArchiveView view;
    private static final String[] locales = new String[]{Locale.GERMAN.getLanguage(), Locale.ENGLISH.getLanguage(), Locale.FRENCH.getLanguage()};
    private static final String[][] init_buttons = new String[][]{{"open.gif", "Open", "OPEN", "True"}, {"translate.gif", "Translate", "TRANS", "False"}, {"save.gif", "Save", "SAVE", "False"}, {"quit.gif", "Quit", "QUIT", "True"}};
    private static final int OPEN = 0;
    private static final int TRANSLATE = 1;
    private static final int SAVE = 2;
    private static final int QUIT = 3;
    private JButton[] buttons;

    public static void main(String[] stringArray) {
        System.out.println("ResEdit v1.0.1");
        System.out.println(disclaimer);
        new Main();
    }

    private Main() {
        JPanel jPanel = this.getActionPanel();
        this.view = new ResourceArchiveView();
        this.view.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("translation")) {
                    Main.this.buttons[2].setEnabled(true);
                }
            }
        });
        this.frame = new JFrame(){

            public void dispose() {
                int n;
                if (Main.this.buttons[2].isEnabled() && (n = JOptionPane.showConfirmDialog(Main.this.frame, "Quit without saving?", "Quitting", 0)) == 1) {
                    return;
                }
                super.dispose();
                System.exit(0);
            }

            protected void processWindowEvent(WindowEvent windowEvent) {
                if (windowEvent.getID() == 201) {
                    this.dispose();
                }
            }
        };
        this.frame.setDefaultCloseOperation(0);
        Container container = this.frame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add("Center", this.view);
        container.add("North", jPanel);
        ((Component)this.frame).setSize(new Dimension(480, 256));
        this.frame.show();
        this.updateTitleBar();
    }

    private JPanel getActionPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        this.buttons = new JButton[init_buttons.length];
        int n = 0;
        while (n < init_buttons.length) {
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("images/" + init_buttons[n][0]));
            String string = init_buttons[n][1];
            String string2 = init_buttons[n][2];
            Boolean bl = new Boolean(init_buttons[n][3]);
            JButton jButton = new JButton(string, imageIcon);
            jButton.setActionCommand(string2);
            jButton.addActionListener(this);
            jButton.setMargin(new Insets(0, 4, 0, 4));
            jButton.setEnabled(bl);
            jPanel.add(jButton);
            this.buttons[n] = jButton;
            ++n;
        }
        return jPanel;
    }

    private void updateTitleBar() {
        this.frame.setTitle("ResEdit 1.0.1" + (this.archive == null ? "" : " - " + this.archive.getName()));
    }

    private void addMenuItem(JMenu jMenu, String string, char c, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string, c);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("QUIT")) {
            this.quit();
        }
        if (actionEvent.getActionCommand().equals("OPEN")) {
            this.open();
        }
        if (actionEvent.getActionCommand().equals("TRANS")) {
            this.translate();
        }
        if (actionEvent.getActionCommand().equals("SAVE")) {
            this.save();
        }
    }

    private Selection choose(String string, String string2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JCheckBox jCheckBox = new JCheckBox("Translate Unicode", true);
        final JComboBox<String> jComboBox = new JComboBox<String>(locales);
        jComboBox.setEditable(true);
        jComboBox.setEnabled(false);
        jComboBox.setPreferredSize(new Dimension(0, 0));
        jComboBox.setBorder(new CompoundBorder(new EmptyBorder(0, 16, 0, 0), jComboBox.getBorder()));
        final JCheckBox jCheckBox2 = new JCheckBox("Default locale or", true);
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jComboBox.setEnabled(!jCheckBox2.isSelected());
            }
        });
        jPanel.add(jCheckBox);
        jPanel.add(jCheckBox2);
        jPanel.add(jComboBox);
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".jar") || file.getName().endsWith(".zip");
            }

            public String getDescription() {
                return "Archive (*.zip,*.jar)";
            }
        };
        JFileChooser jFileChooser = new JFileChooser(new File("."));
        jFileChooser.setFileFilter(fileFilter);
        jFileChooser.addChoosableFileFilter(fileFilter);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setAccessory(jPanel);
        int n = jFileChooser.showDialog(this.frame, string2);
        if (n == 1) {
            return null;
        }
        Selection selection = new Selection();
        selection.file = jFileChooser.getSelectedFile();
        selection.locale = jCheckBox2.isSelected() ? null : jComboBox.getEditor().getItem().toString();
        selection.unicode = jCheckBox.isSelected();
        return selection;
    }

    private void open() {
        Selection selection = this.choose("Choose resource", "Open");
        if (selection == null) {
            return;
        }
        try {
            this.archive = new ResourceArchive(selection.file.getName(), selection.locale, selection.unicode, new FileInputStream(selection.file));
        }
        catch (Exception exception) {
            this.archive = null;
            JOptionPane.showMessageDialog(this.frame, "Error opening " + selection.file + "\n<" + exception.getMessage() + ">", "Error", 0);
        }
        this.view.setArchive(this.archive);
        this.buttons[1].setEnabled(this.archive != null);
        this.updateTitleBar();
    }

    private void translate() {
        Selection selection = this.choose("Choose translation", "Translate");
        if (selection == null) {
            return;
        }
        if (selection.file.getName().equals(this.archive.getName())) {
            JOptionPane.showMessageDialog(this.frame, "Can't translate resource archive with same file", "Error", 0);
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(selection.file.getName());
            this.archive.setTranslation(fileInputStream, selection.locale, selection.unicode);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.frame, "Error translating from " + selection.file + "\n<" + exception.getMessage() + ">", "Error", 0);
        }
        this.view.repaint();
    }

    private void save() {
        int n;
        Selection selection = this.choose("Choose destination", "Save");
        if (selection == null) {
            return;
        }
        if (selection.file.exists() && (n = JOptionPane.showConfirmDialog(this.frame, "O.K. to overwrite " + selection.file.getName() + "?", "Quitting", 0)) == 1) {
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(selection.file);
            this.archive.writeTo(fileOutputStream, selection.unicode, selection.locale);
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.frame, "Error saving to " + selection.file + "\n<" + exception.getMessage() + ">", "Error", 0);
            return;
        }
        this.buttons[2].setEnabled(false);
    }

    private void quit() {
        this.frame.dispose();
    }

    private class Selection {
        File file;
        boolean unicode;
        String locale;

        private Selection() {
        }
    }
}

