/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.shapefile;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jump.io.EndianDataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.geotools.shapefile.MultiLineHandler;
import org.geotools.shapefile.MultiPointHandler;
import org.geotools.shapefile.PointHandler;
import org.geotools.shapefile.PolygonHandler;
import org.geotools.shapefile.ShapeHandler;
import org.geotools.shapefile.ShapeTypeNotSupportedException;
import org.geotools.shapefile.ShapefileException;
import org.geotools.shapefile.ShapefileHeader;

public class Shapefile {
    static final int SHAPEFILE_ID = 9994;
    static final int VERSION = 1000;
    public static final int NULL = 0;
    public static final int POINT = 1;
    public static final int POINTZ = 11;
    public static final int POINTM = 21;
    public static final int ARC = 3;
    public static final int ARCM = 23;
    public static final int ARCZ = 13;
    public static final int POLYGON = 5;
    public static final int POLYGONM = 25;
    public static final int POLYGONZ = 15;
    public static final int MULTIPOINT = 8;
    public static final int MULTIPOINTM = 28;
    public static final int MULTIPOINTZ = 18;
    public static final int UNDEFINED = -1;
    private URL baseURL;
    private InputStream myInputStream;

    public Shapefile(InputStream inputStream) {
        this.myInputStream = inputStream;
    }

    private EndianDataInputStream getInputStream() throws IOException {
        return new EndianDataInputStream(this.myInputStream);
    }

    /*
     * Unable to fully structure code
     */
    public GeometryCollection read(GeometryFactory var1_1) throws IOException, ShapefileException, Exception {
        var2_2 = this.getInputStream();
        if (var2_2 == null) {
            throw new IOException("Failed connection or no content for " + this.baseURL);
        }
        var3_3 = new ShapefileHeader(var2_2);
        if (var3_3.getVersion() < 1000) {
            System.err.println("Sf-->Warning, Shapefile format (" + var3_3.getVersion() + ") older that supported (" + 1000 + "), attempting to read anyway");
        }
        if (var3_3.getVersion() > 1000) {
            System.err.println("Sf-->Warning, Shapefile format (" + var3_3.getVersion() + ") newer that supported (" + 1000 + "), attempting to read anyway");
        }
        var5_4 = new ArrayList<Geometry>();
        var6_5 = var3_3.getShapeType();
        var7_6 = Shapefile.getShapeHandler(var6_5);
        if (var7_6 == null) {
            throw new ShapeTypeNotSupportedException("Unsuported shape type:" + var6_5);
        }
        var8_7 = 0;
        var9_8 = 0;
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                var8_7 = var2_2.readIntBE();
                var9_8 = var2_2.readIntBE();
                try {
                    var4_9 = var7_6.read(var2_2, var1_1, var9_8);
                    var5_4.add(var4_9);
                    continue;
                }
                catch (IllegalArgumentException var10_10) {
                    throw new ShapefileException(var10_10.getMessage());
                }
                catch (Exception var10_11) {
                    System.out.println("Error processing record (a):" + var8_7);
                    System.out.println(var10_11.getMessage());
                    var10_11.printStackTrace();
                    throw new ShapefileException(var10_11.getMessage());
                }
                break;
            }
        }
        catch (EOFException var10_12) {
            return var1_1.createGeometryCollection(var5_4.toArray(new Geometry[0]));
        }
        {
            ** while (true)
        }
    }

    public static String getShapeTypeDescription(int n) {
        switch (n) {
            case 0: {
                return "Null";
            }
            case 1: {
                return "Points";
            }
            case 11: {
                return "Points Z";
            }
            case 21: {
                return "Points M";
            }
            case 3: {
                return "Arcs";
            }
            case 23: {
                return "ArcsM";
            }
            case 13: {
                return "ArcsM";
            }
            case 5: {
                return "Polygon";
            }
            case 25: {
                return "PolygonM";
            }
            case 15: {
                return "PolygonZ";
            }
            case 8: {
                return "Multipoint";
            }
            case 28: {
                return "MultipointM";
            }
            case 18: {
                return "MultipointZ";
            }
        }
        return "Undefined";
    }

    public static ShapeHandler getShapeHandler(Geometry geometry, int n) throws Exception {
        return Shapefile.getShapeHandler(Shapefile.getShapeType(geometry, n));
    }

    public static ShapeHandler getShapeHandler(int n) throws Exception {
        switch (n) {
            case 1: {
                return new PointHandler();
            }
            case 11: {
                return new PointHandler(11);
            }
            case 21: {
                return new PointHandler(21);
            }
            case 5: {
                return new PolygonHandler();
            }
            case 25: {
                return new PolygonHandler(25);
            }
            case 15: {
                return new PolygonHandler(15);
            }
            case 3: {
                return new MultiLineHandler();
            }
            case 23: {
                return new MultiLineHandler(23);
            }
            case 13: {
                return new MultiLineHandler(13);
            }
            case 8: {
                return new MultiPointHandler();
            }
            case 28: {
                return new MultiPointHandler(28);
            }
            case 18: {
                return new MultiPointHandler(18);
            }
        }
        return null;
    }

    public static int getShapeType(Geometry geometry, int n) throws ShapefileException {
        if (n != 2 && n != 3 && n != 4) {
            throw new ShapefileException("invalid ShapeFileDimentions for getShapeType - expected 2,3,or 4 but got " + n + "  (2=x,y ; 3=x,y,m ; 4=x,y,z,m)");
        }
        if (geometry instanceof Point) {
            switch (n) {
                case 2: {
                    return 1;
                }
                case 3: {
                    return 21;
                }
                case 4: {
                    return 11;
                }
            }
        }
        if (geometry instanceof MultiPoint) {
            switch (n) {
                case 2: {
                    return 8;
                }
                case 3: {
                    return 28;
                }
                case 4: {
                    return 18;
                }
            }
        }
        if (geometry instanceof Polygon || geometry instanceof MultiPolygon) {
            switch (n) {
                case 2: {
                    return 5;
                }
                case 3: {
                    return 25;
                }
                case 4: {
                    return 15;
                }
            }
        }
        if (geometry instanceof LineString || geometry instanceof MultiLineString) {
            switch (n) {
                case 2: {
                    return 3;
                }
                case 3: {
                    return 23;
                }
                case 4: {
                    return 13;
                }
            }
        }
        return -1;
    }
}

