/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.shapefile;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jump.io.EndianDataInputStream;
import java.io.IOException;
import org.geotools.shapefile.InvalidShapefileException;
import org.geotools.shapefile.ShapeHandler;

public class MultiLineHandler
implements ShapeHandler {
    int myShapeType = -1;

    public MultiLineHandler() {
        this.myShapeType = 3;
    }

    public MultiLineHandler(int n) throws InvalidShapefileException {
        if (n != 3 && n != 13 && n != 23) {
            throw new InvalidShapefileException("MultiLineHandler constructor - expected type to be 3,13 or 23");
        }
        this.myShapeType = n;
    }

    public Geometry read(EndianDataInputStream endianDataInputStream, GeometryFactory geometryFactory, int n) throws IOException, InvalidShapefileException {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = endianDataInputStream.readIntLE();
        n4 += 2;
        if (n5 == 0) {
            return new MultiLineString(null, new PrecisionModel(), 0);
        }
        if (n5 != this.myShapeType) {
            throw new InvalidShapefileException("MultilineHandler.read()  - file says its type " + n5 + " but i'm expecting type " + this.myShapeType);
        }
        double d = endianDataInputStream.readDoubleLE();
        d = endianDataInputStream.readDoubleLE();
        d = endianDataInputStream.readDoubleLE();
        d = endianDataInputStream.readDoubleLE();
        n4 += 16;
        int n6 = endianDataInputStream.readIntLE();
        int n7 = endianDataInputStream.readIntLE();
        n4 += 4;
        int[] nArray = new int[n6];
        for (int i = 0; i < n6; ++i) {
            nArray[i] = endianDataInputStream.readIntLE();
            n4 += 2;
        }
        LineString[] lineStringArray = new LineString[n6];
        Coordinate[] coordinateArray = new Coordinate[n7];
        for (n3 = 0; n3 < n7; ++n3) {
            coordinateArray[n3] = new Coordinate(endianDataInputStream.readDoubleLE(), endianDataInputStream.readDoubleLE());
            n4 += 8;
        }
        if (this.myShapeType == 13) {
            d = endianDataInputStream.readDoubleLE();
            d = endianDataInputStream.readDoubleLE();
            n4 += 8;
            for (n3 = 0; n3 < n7; ++n3) {
                coordinateArray[n3].z = endianDataInputStream.readDoubleLE();
                n4 += 4;
            }
        }
        if (this.myShapeType >= 13 && n >= (n3 = this.myShapeType == 13 ? 22 + 2 * n6 + n7 * 8 + 4 + 4 + 4 * n7 + 4 + 4 + 4 * n7 : 22 + 2 * n6 + n7 * 8 + 4 + 4 + 4 * n7)) {
            d = endianDataInputStream.readDoubleLE();
            d = endianDataInputStream.readDoubleLE();
            n4 += 8;
            for (n2 = 0; n2 < n7; ++n2) {
                d = endianDataInputStream.readDoubleLE();
                n4 += 4;
            }
        }
        while (n4 < n) {
            n3 = endianDataInputStream.readShortBE();
            ++n4;
        }
        n3 = 0;
        for (int i = 0; i < n6; ++i) {
            n2 = nArray[i];
            int n8 = i == n6 - 1 ? n7 : nArray[i + 1];
            int n9 = n8 - n2;
            Coordinate[] coordinateArray2 = new Coordinate[n9];
            for (int j = 0; j < n9; ++j) {
                coordinateArray2[j] = coordinateArray[n3];
                ++n3;
            }
            lineStringArray[i] = geometryFactory.createLineString(coordinateArray2);
        }
        if (n6 == 1) {
            return lineStringArray[0];
        }
        return geometryFactory.createMultiLineString(lineStringArray);
    }

    public int getShapeType() {
        return this.myShapeType;
    }

    public int getLength(Geometry geometry) {
        MultiLineString multiLineString = (MultiLineString)geometry;
        int n = multiLineString.getNumGeometries();
        int n2 = multiLineString.getNumPoints();
        if (this.myShapeType == 3) {
            return 22 + 2 * n + n2 * 8;
        }
        if (this.myShapeType == 23) {
            return 22 + 2 * n + n2 * 8 + 4 + 4 + 4 * n2;
        }
        return 22 + 2 * n + n2 * 8 + 4 + 4 + 4 * n2 + 4 + 4 + 4 * n2;
    }

    double[] zMinMax(Geometry geometry) {
        boolean bl = false;
        Coordinate[] coordinateArray = geometry.getCoordinates();
        double[] dArray = new double[2];
        double d = Double.NaN;
        double d2 = Double.NaN;
        for (int i = 0; i < coordinateArray.length; ++i) {
            double d3 = coordinateArray[i].z;
            if (Double.isNaN(d3)) continue;
            if (bl) {
                if (d3 < d) {
                    d = d3;
                }
                if (!(d3 > d2)) continue;
                d2 = d3;
                continue;
            }
            bl = true;
            d = d3;
            d2 = d3;
        }
        dArray[0] = d;
        dArray[1] = d2;
        return dArray;
    }
}

