/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;

public class PanTool
extends DragTool {
    private boolean dragging = false;
    private Image image;
    private Cursor cursor;

    public PanTool(Cursor cursor) {
        this.cursor = cursor;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        try {
            if (!this.dragging) {
                this.dragging = true;
                this.getPanel().getRenderingManager().setPaintingEnabled(false);
                this.cacheImage();
            }
            this.getPanel().erase((Graphics2D)this.getPanel().getGraphics());
            this.drawImage(mouseEvent.getPoint());
            super.mouseDragged(mouseEvent);
        }
        catch (Throwable throwable) {
            this.getPanel().getContext().handleThrowable(throwable);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.dragging) {
            return;
        }
        this.getPanel().getRenderingManager().setPaintingEnabled(true);
        this.dragging = false;
        super.mouseReleased(mouseEvent);
    }

    protected Shape getShape(Point2D point2D, Point2D point2D2) {
        return null;
    }

    protected void gestureFinished() throws NoninvertibleTransformException {
        double d = this.getModelDestination().x - this.getModelSource().x;
        double d2 = this.getModelDestination().y - this.getModelSource().y;
        Envelope envelope = this.getPanel().getViewport().getEnvelopeInModelCoordinates();
        this.getPanel().getViewport().zoom(new Envelope(envelope.getMinX() - d, envelope.getMaxX() - d, envelope.getMinY() - d2, envelope.getMaxY() - d2));
    }

    private void cacheImage() {
        this.image = this.getPanel().createBlankPanelImage();
        this.getPanel().paint(this.image.getGraphics());
    }

    private void drawImage(Point point) throws NoninvertibleTransformException {
        double d = point.getX() - this.getViewSource().getX();
        double d2 = point.getY() - this.getViewSource().getY();
        this.getPanel().getGraphics().drawImage(this.image, (int)d, (int)d2, this.getPanel());
    }
}

