/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;

public abstract class VertexStyle
implements Style {
    protected RectangularShape shape;
    protected int size = 4;
    private Color fillColor;
    private boolean enabled = false;

    protected VertexStyle(RectangularShape rectangularShape) {
        this.shape = rectangularShape;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getSize() {
        return this.size;
    }

    public void initialize(Layer layer) {
        this.fillColor = GUIUtil.alphaColor(layer.getBasicStyle().getLineColor(), layer.getBasicStyle().getAlpha());
    }

    public void paint(Feature feature, Graphics2D graphics2D, Viewport viewport) throws Exception {
        Coordinate[] coordinateArray = feature.getGeometry().getCoordinates();
        graphics2D.setColor(this.fillColor);
        for (int i = 0; i < coordinateArray.length; ++i) {
            if (!viewport.getEnvelopeInModelCoordinates().contains(coordinateArray[i])) continue;
            this.paint(graphics2D, viewport.toViewPoint(new Point2D.Double(coordinateArray[i].x, coordinateArray[i].y)));
        }
    }

    public void paint(Graphics2D graphics2D, Point2D point2D) {
        this.setFrame(point2D);
        this.render(graphics2D);
    }

    private void setFrame(Point2D point2D) {
        this.shape.setFrame(point2D.getX() - (double)this.getSize() / 2.0, point2D.getY() - (double)this.getSize() / 2.0, this.getSize(), this.getSize());
    }

    protected void render(Graphics2D graphics2D) {
        graphics2D.fill(this.shape);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }
}

