/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.GraphicsState;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.ImageObserver;

public class ThreadSafeImage
implements Cloneable {
    private Image image = null;
    private Graphics2D graphics = null;
    private LayerViewPanel panel;
    private GraphicsState dummyGraphicsState = new GraphicsState(){

        public void restore(Graphics2D graphics2D) {
        }
    };

    public ThreadSafeImage(LayerViewPanel layerViewPanel) {
        this.panel = layerViewPanel;
    }

    private Image getImage() {
        if (this.image == null) {
            this.image = this.panel.createBlankPanelImage();
        }
        return this.image;
    }

    private Graphics2D getGraphics() {
        if (this.graphics == null) {
            this.graphics = (Graphics2D)this.getImage().getGraphics();
            this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        return this.graphics;
    }

    public synchronized void copyTo(Graphics2D graphics2D, ImageObserver imageObserver) {
        if (this.getImage() == null) {
            return;
        }
        graphics2D.drawImage(this.getImage(), 0, 0, imageObserver);
    }

    private boolean isPanelReady() {
        if (this.panel.getSize().equals(new Dimension(0, 0))) {
            return false;
        }
        return this.getImage() != null;
    }

    public synchronized void draw(Drawer drawer) throws Exception {
        if (!this.isPanelReady()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        drawer.draw(graphics2D);
    }

    public synchronized GraphicsState getGraphicsState() {
        if (!this.isPanelReady()) {
            return this.dummyGraphicsState;
        }
        return new GraphicsState(this.getGraphics());
    }

    public synchronized void setGraphicsState(GraphicsState graphicsState) {
        if (!this.isPanelReady()) {
            return;
        }
        graphicsState.restore(this.getGraphics());
    }

    public Object clone() {
        ThreadSafeImage threadSafeImage = new ThreadSafeImage(this.panel);
        if (!threadSafeImage.isPanelReady()) {
            return null;
        }
        this.copyTo(threadSafeImage.getGraphics(), null);
        return threadSafeImage;
    }

    public static interface Drawer {
        public void draw(Graphics2D var1) throws Exception;
    }
}

