/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.ImageCachingFeatureCollectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import com.vividsolutions.jump.workbench.ui.renderer.SimpleFeatureCollectionRenderer;
import java.awt.Graphics2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public abstract class FeatureCollectionRenderer
implements Renderer {
    private ImageCachingFeatureCollectionRenderer imageCachingFeatureCollectionRenderer;
    private SimpleFeatureCollectionRenderer simpleFeatureCollectionRenderer;
    private Renderer currentFeatureCollectionRenderer;

    public FeatureCollectionRenderer(Object object, LayerViewPanel layerViewPanel) {
        this(object, layerViewPanel, new ImageCachingFeatureCollectionRenderer(object, layerViewPanel));
    }

    public FeatureCollectionRenderer(Object object, LayerViewPanel layerViewPanel, ImageCachingFeatureCollectionRenderer imageCachingFeatureCollectionRenderer) {
        this.imageCachingFeatureCollectionRenderer = imageCachingFeatureCollectionRenderer;
        this.simpleFeatureCollectionRenderer = new SimpleFeatureCollectionRenderer(object, layerViewPanel);
        this.currentFeatureCollectionRenderer = this.simpleFeatureCollectionRenderer;
    }

    public void clearImageCache() {
        this.imageCachingFeatureCollectionRenderer.clearImageCache();
        this.simpleFeatureCollectionRenderer.clearImageCache();
    }

    public boolean isRendering() {
        return this.currentFeatureCollectionRenderer.isRendering();
    }

    public Object getContentID() {
        return this.currentFeatureCollectionRenderer.getContentID();
    }

    public void copyTo(Graphics2D graphics2D) {
        this.currentFeatureCollectionRenderer.copyTo(graphics2D);
    }

    public Runnable createRunnable() {
        Map map = this.layerToFeaturesMap();
        Collection collection = this.styles();
        this.imageCachingFeatureCollectionRenderer.setLayerToFeaturesMap(map);
        this.imageCachingFeatureCollectionRenderer.setStyles(collection);
        this.simpleFeatureCollectionRenderer.setLayerToFeaturesMap(map);
        this.simpleFeatureCollectionRenderer.setStyles(collection);
        this.currentFeatureCollectionRenderer = this.featureCount(map) < 100 ? this.simpleFeatureCollectionRenderer : this.imageCachingFeatureCollectionRenderer;
        return this.currentFeatureCollectionRenderer.createRunnable();
    }

    private int featureCount(Map map) {
        int n = 0;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Collection collection = (Collection)iterator.next();
            n += collection.size();
        }
        return n;
    }

    protected abstract Map layerToFeaturesMap();

    protected abstract Collection styles();

    public void cancel() {
        this.imageCachingFeatureCollectionRenderer.cancel();
        this.simpleFeatureCollectionRenderer.cancel();
    }
}

