/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class DragTool
extends AbstractCursorTool {
    public static final int DEFAULT_VIEW_CLICK_BUFFER = 2;
    private int viewClickBuffer = 2;
    protected Coordinate modelSource = null;
    protected Coordinate modelDestination = null;
    private boolean dragApproved = false;

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.dragApproved = true;
        try {
            this.setViewSource(mouseEvent.getPoint());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            this.getPanel().getContext().handleThrowable(noninvertibleTransformException);
        }
    }

    protected void setViewClickBuffer(int n) {
        this.viewClickBuffer = n;
    }

    protected boolean wasClick() {
        return this.getModelSource().equals(this.getModelDestination());
    }

    protected Envelope getBoxInModelCoordinates() throws NoninvertibleTransformException {
        double d = Math.min(this.getModelSource().x, this.getModelDestination().x);
        double d2 = Math.max(this.getModelSource().x, this.getModelDestination().x);
        double d3 = Math.min(this.getModelSource().y, this.getModelDestination().y);
        double d4 = Math.max(this.getModelSource().y, this.getModelDestination().y);
        if (this.wasClick()) {
            d -= this.modelClickBuffer();
            d2 += this.modelClickBuffer();
            d3 -= this.modelClickBuffer();
            d4 += this.modelClickBuffer();
        }
        return new Envelope(d, d2, d3, d4);
    }

    protected double modelClickBuffer() {
        return (double)this.viewClickBuffer / this.getPanel().getViewport().getScale();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        try {
            if (!this.dragApproved) {
                return;
            }
            this.setViewDestination(mouseEvent.getPoint());
            this.redrawShape();
        }
        catch (Throwable throwable) {
            this.getPanel().getContext().handleThrowable(throwable);
        }
    }

    protected Coordinate getModelSource() {
        return this.modelSource;
    }

    protected Coordinate getModelDestination() {
        return this.modelDestination;
    }

    protected void setModelSource(Coordinate coordinate) {
        this.modelSource = coordinate;
    }

    protected void setViewSource(Point2D point2D) throws NoninvertibleTransformException {
        this.setModelSource(this.getPanel().getViewport().toModelCoordinate(point2D));
    }

    protected void setViewDestination(Point2D point2D) throws NoninvertibleTransformException {
        this.setModelDestination(this.getPanel().getViewport().toModelCoordinate(point2D));
    }

    protected void setModelDestination(Coordinate coordinate) {
        this.modelDestination = coordinate;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            boolean bl = this.isShapeOnScreen();
            this.clearShape();
            if (bl) {
                this.fireGestureFinished();
            }
            this.dragApproved = false;
        }
        catch (Throwable throwable) {
            this.getPanel().getContext().handleThrowable(throwable);
        }
    }

    protected Shape getShape() throws Exception {
        return this.getShape(this.getViewSource(), this.getViewDestination());
    }

    protected Point2D getViewSource() throws NoninvertibleTransformException {
        return this.getPanel().getViewport().toViewPoint(this.getModelSource());
    }

    protected Point2D getViewDestination() throws NoninvertibleTransformException {
        return this.getPanel().getViewport().toViewPoint(this.getModelDestination());
    }

    protected Shape getShape(Point2D point2D, Point2D point2D2) throws Exception {
        double d = Math.min(point2D.getX(), point2D2.getX());
        double d2 = Math.min(point2D.getY(), point2D2.getY());
        double d3 = Math.max(point2D.getX(), point2D2.getX());
        double d4 = Math.max(point2D.getY(), point2D2.getY());
        return new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
    }
}

