/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.feature;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class AttributeType {
    private static HashMap nameToAttributeTypeMap = new HashMap();
    public static final AttributeType STRING = new AttributeType("STRING", String.class);
    public static final AttributeType GEOMETRY = new AttributeType("GEOMETRY", Geometry.class);
    public static final AttributeType INTEGER = new AttributeType("INTEGER", Integer.class);
    public static final AttributeType DATE = new AttributeType("DATE", Date.class);
    public static final AttributeType DOUBLE = new AttributeType("DOUBLE", Double.class);
    public static final AttributeType OBJECT = new AttributeType("OBJECT", Object.class);
    private String name;
    private Class javaClass;

    public static Collection allTypes() {
        return nameToAttributeTypeMap.values();
    }

    private AttributeType(String string, Class clazz) {
        this.name = string;
        this.javaClass = clazz;
        nameToAttributeTypeMap.put(string, this);
    }

    public String toString() {
        return this.name;
    }

    public static final AttributeType toAttributeType(String string) {
        AttributeType attributeType = (AttributeType)nameToAttributeTypeMap.get(string);
        if (attributeType == null) {
            throw new IllegalArgumentException();
        }
        return attributeType;
    }

    public Class toJavaClass() {
        return this.javaClass;
    }

    public static AttributeType toAttributeType(Class clazz) {
        Iterator iterator = AttributeType.allTypes().iterator();
        while (iterator.hasNext()) {
            AttributeType attributeType = (AttributeType)iterator.next();
            if (attributeType.toJavaClass() != clazz) continue;
            return attributeType;
        }
        return null;
    }
}

